/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.similarity.csv.database;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import jp.ac.osaka_u.ist.sel.similarity.database.AbstractDAO;
import jp.ac.osaka_u.ist.sel.similarity.database.ColumnName;
import jp.ac.osaka_u.ist.sel.similarity.database.SQLGenerator;
import jp.ac.osaka_u.ist.sel.similarity.database.TableType;
import jp.ac.osaka_u.ist.sel.similarity.database.TransactionManager;

public class SelectionDomainDAO
extends AbstractDAO {
    private Map<Integer, String> mappedData = this.getMappedData();

    public SelectionDomainDAO(TransactionManager transactionManager) throws SQLException {
        super(transactionManager);
    }

    private Map<Integer, String> getMappedData() throws SQLException {
        HashMap<Integer, String> mappedData = new HashMap<Integer, String>();
        ColumnName[] columns = new ColumnName[]{ColumnName.ID, ColumnName.NAME};
        String sql = SQLGenerator.getSelectStatement(TableType.DOMAIN_INFO, columns);
        PreparedStatement pstmt = this.prepareStatement(sql);
        ResultSet results = this.executeQuery(pstmt);
        while (results.next()) {
            int fileId = results.getInt(1);
            String name = results.getString(2);
            mappedData.put(fileId, name);
        }
        return mappedData;
    }

    public String getName(int domainId) {
        return this.mappedData.get(domainId);
    }
}

