/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.similarity.csv;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import jp.ac.osaka_u.ist.sel.similarity.commons.Settings;
import jp.ac.osaka_u.ist.sel.similarity.csv.CsvWriterMain;
import jp.ac.osaka_u.ist.sel.similarity.database.TableType;
import jp.ac.osaka_u.ist.sel.similarity.database.TransactionManager;
import org.apache.log4j.BasicConfigurator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CsvWriterMainTest {
    private static String _dbname = Settings._defaultDatabasePath;
    private static String _workspace = "FC_TMP";
    private static String _csvpath = "info.csv";
    String _cpp1 = "../fc-resources/resource/testdata/cpp";
    String _cpp2 = "../fc-resources/resource/testdata/cpp/failed";
    String _cpp3 = "../fc-resources/resource/testdata/cpp/httpd-2.2.19";
    String _cpp4 = "../fc-resources/resource/testdata/cpp/freebsd-ports";
    String _java1 = "src";
    String _java2 = "testcase";
    String _java3 = "../fc-resources/resource/testdata/java";
    String _java4 = "../fc-resources/resource/testdata/java/failed";
    String _txt1 = "../fc-resources/resource/testdata/txt";

    @Before
    public void setUp() throws Exception {
        BasicConfigurator.configure();
        if (!CsvWriterMainTest.dropTable(TableType.CLONE_INFO)) {
            System.err.println("Not yet implemented " + (Object)((Object)TableType.CLONE_INFO));
        }
        if (!CsvWriterMainTest.dropTable(TableType.HASH_INFO)) {
            System.err.println("Not yet implemented " + (Object)((Object)TableType.HASH_INFO));
        }
        if (!CsvWriterMainTest.dropTable(TableType.TOKEN_INFO)) {
            System.err.println("Not yet implemented " + (Object)((Object)TableType.TOKEN_INFO));
        }
        if (!CsvWriterMainTest.dropTable(TableType.FILE_INFO)) {
            System.err.println("Not yet implemented " + (Object)((Object)TableType.FILE_INFO));
        }
        if (!CsvWriterMainTest.dropTable(TableType.DOMAIN_INFO)) {
            System.err.println("Not yet implemented " + (Object)((Object)TableType.DOMAIN_INFO));
        }
    }

    private static boolean dropTable(TableType tableType) throws SQLException {
        TransactionManager transactionManager = null;
        try {
            transactionManager = new TransactionManager(_dbname);
            String sql = "DROP TABLE " + (Object)((Object)tableType);
            PreparedStatement pstmt = transactionManager.prepareStatement(sql);
            if (transactionManager.executeUpdate(pstmt) != 0) {
                return false;
            }
        }
        catch (SQLSyntaxErrorException e) {
            return false;
        }
        finally {
            if (transactionManager != null) {
                try {
                    transactionManager.close();
                }
                catch (SQLException se) {
                    se.printStackTrace();
                }
            }
        }
        return true;
    }

    @Test
    public void testMain1_1() {
        String[] args = new String[]{"-jdb", _dbname, "-l", "JAVA", "-d", this._java1, this._java2, this._txt1, "-o", _csvpath};
        try {
            CsvWriterMain.main(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"catch a SQLException");
        }
    }

    @Test
    public void testMain2() {
        String[] args = new String[]{"-jdb", _dbname, "-l", "CPP", "-d", this._cpp3, "-o", _csvpath};
        try {
            CsvWriterMain.main(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"catch a SQLException");
        }
    }

    @Test
    public void testMain3() {
        String[] args = new String[]{"-jdb", _dbname, "-l", "CPP", "-d", this._cpp3, "-o", _csvpath};
        try {
            CsvWriterMain.main(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"catch a SQLException");
        }
    }

    @Test
    public void testMain4() {
        String[] args = new String[]{"-jdb", _dbname, "-l", "CPP", "-d", this._cpp2, "-o", _csvpath};
        try {
            CsvWriterMain.main(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"catch a SQLException");
        }
    }

    @Test
    public void testMain5_1() {
        String[] args = new String[]{"-jdb", _dbname, "-l", "JAVA", "-d", this._java3, "-o", _csvpath};
        try {
            CsvWriterMain.main(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"catch a SQLException");
        }
    }

    @Test
    public void testMain6() {
        String[] args = new String[]{"-w", _workspace, "-jdb", _dbname, "-l", "JAVA", "-d", this._java4, "-o", _csvpath};
        try {
            CsvWriterMain.main(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"catch a SQLException");
        }
    }

    @Test
    public void testMain7() {
        String[] args = new String[]{"-w", _workspace, "-jdb", _dbname, "-l", "CPP", "-d", this._cpp4, "-o", _csvpath};
        try {
            CsvWriterMain.main(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"catch a SQLException");
        }
    }
}

