/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.similarity.csv;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.ac.osaka_u.ist.sel.similarity.commons.ArgumentParser;
import jp.ac.osaka_u.ist.sel.similarity.commons.Settings;
import jp.ac.osaka_u.ist.sel.similarity.csv.CloneCsvExporter;
import jp.ac.osaka_u.ist.sel.similarity.csv.database.CsvWriterDAOManager;
import jp.ac.osaka_u.ist.sel.similarity.csv.database.SelectionCloneDAO;
import jp.ac.osaka_u.ist.sel.similarity.csv.database.SelectionDomainDAO;
import jp.ac.osaka_u.ist.sel.similarity.csv.database.SelectionFileDAO;
import jp.ac.osaka_u.ist.sel.similarity.csv.database.SelectionHashDAO;
import jp.ac.osaka_u.ist.sel.similarity.csv.database.object.FileCsvInfo;
import jp.ac.osaka_u.ist.sel.similarity.database.ColumnName;
import jp.ac.osaka_u.ist.sel.similarity.fileclone.register.CloneRegisterMain;

public class CsvWriterMain {
    public static void main(String[] args) throws SQLException {
        if (!ArgumentParser.parseArgument(args)) {
            return;
        }
        Settings settings = Settings.getInstance();
        CloneRegisterMain.main(args);
        String csvPath = Settings.getInstance().getCsvPath();
        if (csvPath == null) {
            return;
        }
        CsvWriterDAOManager selectionDAOManager = null;
        try {
            try {
                selectionDAOManager = new CsvWriterDAOManager(settings.getDatabasePath());
                CsvWriterMain.exportCsv(csvPath, selectionDAOManager);
            }
            catch (Throwable e) {
                e.printStackTrace();
                try {
                    if (selectionDAOManager != null) {
                        selectionDAOManager.close();
                    }
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (selectionDAOManager != null) {
                    selectionDAOManager.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private static void exportCsv(String csvPath, CsvWriterDAOManager selectionDAOManager) throws SQLException, IOException {
        SelectionCloneDAO cloneDAO = selectionDAOManager.getFileCloneDAO();
        Map<Integer, Integer> mappedIdData = cloneDAO.getMappedData();
        HashMap<Integer, ArrayList<Integer>> listedIdData = new HashMap<Integer, ArrayList<Integer>>();
        for (int fileId : mappedIdData.keySet()) {
            int cloneId = mappedIdData.get(fileId);
            ArrayList<Integer> fileIdList = (ArrayList<Integer>)listedIdData.get(cloneId);
            if (fileIdList == null) {
                fileIdList = new ArrayList<Integer>();
            }
            fileIdList.add(fileId);
            listedIdData.put(cloneId, fileIdList);
        }
        ArrayList<String> headers = new ArrayList<String>();
        headers.add(ColumnName.GROUP_ID.toString());
        headers.add(ColumnName.DOMAIN_ID.toString());
        headers.add(ColumnName.PATH.toString());
        headers.add(ColumnName.EXT.toString());
        headers.add(ColumnName.FILE_SIZE.toString());
        headers.add(ColumnName.MD5_HASH.toString());
        ArrayList<Map<String, String>> table = new ArrayList<Map<String, String>>();
        SelectionDomainDAO domainDAO = selectionDAOManager.getDomainDAO();
        SelectionFileDAO fileDAO = selectionDAOManager.getFileDAO();
        SelectionHashDAO hashDAO = selectionDAOManager.getHashDAO();
        Iterator iterator = listedIdData.keySet().iterator();
        while (iterator.hasNext()) {
            int cloneId = (Integer)iterator.next();
            List fileIdList = (List)listedIdData.get(cloneId);
            if (fileIdList.size() < 2) continue;
            Iterator iterator2 = fileIdList.iterator();
            while (iterator2.hasNext()) {
                int fileId = (Integer)iterator2.next();
                HashMap<String, String> mappedData = new HashMap<String, String>();
                String columnName = null;
                String value = null;
                columnName = ColumnName.GROUP_ID.toString();
                value = String.valueOf(cloneId);
                mappedData.put(columnName, value);
                FileCsvInfo fileInfo = fileDAO.getData(fileId);
                columnName = ColumnName.PATH.toString();
                value = fileInfo.getPath();
                mappedData.put(columnName, value);
                columnName = ColumnName.EXT.toString();
                value = fileInfo.getExt();
                mappedData.put(columnName, value);
                columnName = ColumnName.FILE_SIZE.toString();
                value = String.valueOf(fileInfo.getSize());
                mappedData.put(columnName, value);
                columnName = ColumnName.DOMAIN_ID.toString();
                int domainId = fileInfo.getDomainId();
                value = domainDAO.getName(domainId);
                mappedData.put(columnName, value);
                columnName = ColumnName.MD5_HASH.toString();
                value = CsvWriterMain.asHexString(hashDAO.getHash(fileId));
                mappedData.put(columnName, value);
                table.add(mappedData);
            }
        }
        File file = new File(csvPath);
        CloneCsvExporter.export(file, headers, table);
    }

    public static String asHexString(List<Byte> bytes) {
        StringBuffer buffer = new StringBuffer(bytes.size() * 2);
        int i = 0;
        while (i < bytes.size()) {
            int code = bytes.get(i).byteValue();
            if ((code &= 0xFF) < 16) {
                buffer.append('0');
            }
            buffer.append(Integer.toHexString(code));
            ++i;
        }
        return buffer.toString();
    }
}

