/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.similarity.commons;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import jp.ac.osaka_u.ist.sel.similarity.commons.StringValidator;

public class TextReader {
    private TextReader() {
    }

    private static String readText(Reader in) throws IOException {
        int ch;
        BufferedReader inReader = new BufferedReader(in);
        StringBuffer sBuf = new StringBuffer();
        while ((ch = inReader.read()) != -1) {
            sBuf.append((char)ch);
        }
        if (sBuf.toString() == null) {
            return sBuf.substring(0);
        }
        return sBuf.toString();
    }

    public static String readText(String filename) throws IOException {
        FileReader fReader = null;
        BufferedReader bReader = null;
        String text = null;
        try {
            fReader = new FileReader(filename);
            bReader = new BufferedReader(fReader);
            text = TextReader.readText(bReader);
        }
        finally {
            if (bReader != null) {
                bReader.close();
            }
            if (fReader != null) {
                fReader.close();
            }
        }
        return TextReader.getUnicodeString(text);
    }

    private static String getUnicodeString(String text) throws UnsupportedEncodingException {
        if (StringValidator.isUTF8(text)) {
            return TextReader.getUnicodeString(text, "UTF-8");
        }
        if (StringValidator.isEUC(text)) {
            return TextReader.getUnicodeString(text, "euc-jp");
        }
        if (StringValidator.isSJIS(text)) {
            return TextReader.getUnicodeString(text, "SJIS");
        }
        if (StringValidator.isWindows31j(text)) {
            return TextReader.getUnicodeString(text, "Windows-31j");
        }
        return null;
    }

    private static String getUnicodeString(String s, String charset) throws UnsupportedEncodingException {
        return new String(s.getBytes(charset), "UTF-8");
    }
}

