/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.similarity.commons;

import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SupportedLanguage {
    public static final String _KEY_LANG_C = "C";
    public static final String _KEY_LANG_CPP = "CPP";
    public static final String _KEY_LANG_JAVA = "JAVA";
    private static Pattern _periodPattern = Pattern.compile(".*\\.([^\\.]*)$");

    private SupportedLanguage() {
    }

    public static Set<String> getTargetExtensionSet(String lang) {
        TreeSet<String> extensions = new TreeSet<String>();
        if (_KEY_LANG_CPP.equals(lang.toUpperCase())) {
            extensions.add("c");
            extensions.add("h");
            extensions.add("cpp");
        } else if (_KEY_LANG_C.equals(lang.toUpperCase())) {
            extensions.add("c");
            extensions.add("h");
        } else if (_KEY_LANG_JAVA.equals(lang.toUpperCase())) {
            extensions.add("java");
        }
        return extensions;
    }

    public static String getTargetLanguage(String fileExtension) {
        if (fileExtension.equals("c")) {
            return _KEY_LANG_C;
        }
        if (fileExtension.equals("h")) {
            return _KEY_LANG_C;
        }
        if (fileExtension.equals("cpp")) {
            return _KEY_LANG_CPP;
        }
        if (fileExtension.equals("java")) {
            return _KEY_LANG_JAVA;
        }
        return null;
    }

    public static String getFileExtension(String filePath) {
        Matcher periodMatcher = _periodPattern.matcher(filePath);
        if (!periodMatcher.find()) {
            return "";
        }
        return periodMatcher.group(1);
    }

    public class FileExtensions {
        public static final String _EXT_C_C = "c";
        public static final String _EXT_C_H = "h";
        public static final String _EXT_CPP_CPP = "cpp";
        public static final String _EXT_JAVA = "java";

        private FileExtensions() {
        }
    }
}

