/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.similarity.commons;

import java.io.UnsupportedEncodingException;

public class StringValidator {
    public static final String _Windows_31j = "Windows-31j";
    public static final String _SJIS = "SJIS";
    public static final String _euc_jp = "euc-jp";
    public static final String _UTF_8 = "UTF-8";

    private StringValidator() {
    }

    private static boolean checkCharacterCode(String str, String encoding) {
        if (str == null) {
            return true;
        }
        try {
            byte[] bytes = str.getBytes(encoding);
            return str.equals(new String(bytes, encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isWindows31j(String str) {
        return StringValidator.checkCharacterCode(str, _Windows_31j);
    }

    public static boolean isSJIS(String str) {
        return StringValidator.checkCharacterCode(str, _SJIS);
    }

    public static boolean isEUC(String str) {
        return StringValidator.checkCharacterCode(str, _euc_jp);
    }

    public static boolean isUTF8(String str) {
        return StringValidator.checkCharacterCode(str, _UTF_8);
    }
}

