/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.similarity.commons;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class FileSearch {
    public static final int TYPE_FILE_OR_DIR = 1;
    public static final int TYPE_FILE = 2;
    public static final int TYPE_DIR = 3;
    private TreeSet<File> _set = new TreeSet();
    private Set<String> _finishedSet = new HashSet<String>();

    public File[] listFiles(String directoryPath, String fileName) throws IOException {
        if (fileName != null) {
            fileName = fileName.replace(".", "\\.");
            fileName = fileName.replace("*", ".*");
        }
        Pattern pattern = Pattern.compile(fileName, 2);
        this.listFiles(directoryPath, pattern, 2, true, 0);
        return this._set.toArray(new File[this._set.size()]);
    }

    public File[] listFiles(String directoryPath, String fileName, int type, boolean isRecursive, int period) throws IOException {
        if (fileName != null) {
            fileName = fileName.replace(".", "\\.");
            fileName = fileName.replace("*", ".*");
        }
        Pattern pattern = Pattern.compile(fileName, 2);
        this.listFiles(directoryPath, pattern, type, isRecursive, period);
        return this._set.toArray(new File[this._set.size()]);
    }

    private void listFiles(String directoryPath, Pattern fileNamePattern, int type, boolean isRecursive, int period) throws IOException {
        File dir = new File(directoryPath);
        if (!dir.exists() || !dir.canRead()) {
            throw new IllegalArgumentException("Denoted path [" + dir.getPath() + "] is not accessible.");
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Denoted path [" + dir.getPath() + "] is not a directory.");
        }
        String canonicalPath = dir.getCanonicalPath();
        if (this._finishedSet.contains(canonicalPath)) {
            return;
        }
        this._finishedSet.add(canonicalPath);
        File[] files = dir.listFiles();
        if (files == null) {
            throw new IllegalArgumentException("Denoted path [" + dir.getAbsolutePath() + "] is not found.");
        }
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            this.addFile(type, fileNamePattern, this._set, file, period);
            if (isRecursive && file.isDirectory()) {
                this.listFiles(file.getPath(), fileNamePattern, type, isRecursive, period);
            }
            ++i;
        }
    }

    private void addFile(int type, Pattern pattern, TreeSet<File> set, File file, int period) throws IOException {
        switch (type) {
            case 2: {
                if (file.isFile()) break;
                return;
            }
            case 3: {
                if (file.isDirectory()) break;
                return;
            }
        }
        if (pattern != null && !pattern.matcher(file.getName()).matches()) {
            return;
        }
        if (period != 0) {
            Date lastModifiedDate = new Date(file.lastModified());
            String lastModifiedDateStr = new SimpleDateFormat("yyyyMMdd").format(lastModifiedDate);
            long oneDayTime = 86400000L;
            long periodTime = oneDayTime * (long)Math.abs(period);
            Date designatedDate = new Date(System.currentTimeMillis() - periodTime);
            String designatedDateStr = new SimpleDateFormat("yyyyMMdd").format(designatedDate);
            if (period > 0 ? lastModifiedDateStr.compareTo(designatedDateStr) < 0 : lastModifiedDateStr.compareTo(designatedDateStr) > 0) {
                return;
            }
        }
        set.add(file);
    }

    public void clear() {
        this._set.clear();
        this._finishedSet.clear();
    }
}

