connect 'jdbc:derby:easydb;create=true';

CREATE TABLE APP_INFO (
  ID INT NOT NULL PRIMARY KEY
, PATH VARCHAR(1024) NOT NULL
);

--CREATE INDEX IDX_APP_INFO_ID ON APP_INFO(ID);
CREATE INDEX IDX_APP_PATH ON APP_INFO(PATH);

CREATE TABLE FILE_INFO (
  ID INT NOT NULL PRIMARY KEY -- Last ID = 2^32-1 = 2147483648-1
, PATH VARCHAR(1024) NOT NULL
, FILE_SIZE BIGINT NOT NULL -- file size
, MODIFIED BIGINT NOT NULL -- last modified
, EXT VARCHAR(64) NOT NULL -- file extension
, APP_ID INT NOT NULL
, FOREIGN KEY (APP_ID) REFERENCES APP_INFO(ID) -- app id
);

--CREATE INDEX IDX_FILE_ID ON FILE_INFO(ID);
CREATE INDEX IDX_FILE_INFO_PATH ON FILE_INFO(PATH);
CREATE INDEX IDX_FILE_INFO_SIZE ON FILE_INFO(FILE_SIZE);
CREATE INDEX IDX_FILE_INFO_MODIFIED ON FILE_INFO(MODIFIED);
CREATE INDEX IDX_FILE_INFO_EXT ON FILE_INFO(EXT);
--CREATE INDEX IDX_FILE_APP_ID ON FILE_INFO(APP_ID);

exit;

