/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.similarity.cli;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import jp.ac.osaka_u.ist.sel.similarity.commons.ArgumentParser;
import jp.ac.osaka_u.ist.sel.similarity.commons.CopyUtils;
import jp.ac.osaka_u.ist.sel.similarity.commons.Settings;
import jp.ac.osaka_u.ist.sel.similarity.database.DatabaseCreationDAO;
import jp.ac.osaka_u.ist.sel.similarity.database.TableType;
import jp.ac.osaka_u.ist.sel.similarity.database.TransactionManager;
import jp.ac.osaka_u.ist.sel.similarity.fileclone.database.SelectionDAOManager;
import jp.ac.osaka_u.ist.sel.similarity.fileclone.register.CloneInfoRegister;
import jp.ac.osaka_u.ist.sel.similarity.register.AppInfoRegister;
import jp.ac.osaka_u.ist.sel.similarity.register.database.InsertionDAOManager;
import jp.ac.osaka_u.ist.sel.similarity.tokenizer.CScanPreserver;
import jp.ac.osaka_u.ist.sel.similarity.tokenizer.database.TokenizerDAOManager;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class CliMain {
    private Settings _settings = Settings.getInstance();
    private static Logger _log = Logger.getLogger((String)"CliMain");

    public static void main(String[] args) {
        BasicConfigurator.configure();
        _log.setLevel(Level.INFO);
        CliMain register = new CliMain();
        if (ArgumentParser.parseArgument((String[])args)) {
            register.execute();
        }
    }

    protected void init() throws IOException, SQLException {
        block17: {
            TransactionManager transactionManager = null;
            try {
                File tmpDir = new File(this._settings.getWorkingPath());
                if (tmpDir.exists()) {
                    CopyUtils.removeDirectory((String)this._settings.getWorkingPath());
                }
                if (!tmpDir.mkdir()) {
                    throw new RuntimeException("Can not make dir: " + this._settings.getWorkingPath());
                }
                if (new File(Settings._defaultDatabaseName).canRead()) {
                    CopyUtils.copyDirectory((String)Settings._defaultDatabaseName, (String)this._settings.getDatabasePath());
                    break block17;
                }
                transactionManager = new TransactionManager(this._settings.getDatabasePath());
                DatabaseCreationDAO creationDAO = new DatabaseCreationDAO(transactionManager);
                if (!creationDAO.createAppInfo()) {
                    throw new RuntimeException("Can not " + TableType.APP_INFO + " table: " + this._settings.getDatabasePath());
                }
                if (!creationDAO.createFileInfo()) {
                    throw new RuntimeException("Can not " + TableType.FILE_INFO + " table: " + this._settings.getDatabasePath());
                }
                if (!creationDAO.createHashInfo()) {
                    throw new RuntimeException("Can not " + TableType.HASH_INFO + " table: " + this._settings.getDatabasePath());
                }
                if (!creationDAO.createCloneInfo()) {
                    throw new RuntimeException("Can not " + TableType.CLONE_INFO + " table: " + this._settings.getDatabasePath());
                }
                return;
            }
            finally {
                if (transactionManager != null) {
                    try {
                        transactionManager.close();
                    }
                    catch (SQLException se) {
                        se.printStackTrace();
                    }
                }
            }
        }
    }

    protected void register() throws SQLException, IOException {
        InsertionDAOManager insertionDAOManager = null;
        try {
            insertionDAOManager = new InsertionDAOManager(this._settings.getDatabasePath());
            switch (this._settings.getListMode()) {
                case DIR_LIST: {
                    for (String targetPath : this._settings.getTargetDirectories()) {
                        if (!new File(targetPath).canRead()) {
                            System.err.println("Invalid path: " + targetPath);
                            continue;
                        }
                        if (!new File(targetPath).isDirectory()) {
                            System.err.println("Invalid directory: " + targetPath);
                            continue;
                        }
                        AppInfoRegister analyzer = new AppInfoRegister(targetPath, insertionDAOManager);
                        analyzer.search();
                    }
                    break;
                }
                case FILE_LIST: {
                    Map fileMap = this._settings.getFileMap();
                    for (String targetPath : fileMap.keySet()) {
                        if (!new File(targetPath).canRead()) {
                            System.err.println("Invalid path: " + targetPath);
                            continue;
                        }
                        if (!new File(targetPath).isDirectory()) {
                            System.err.println("Invalid directory: " + targetPath);
                            continue;
                        }
                        AppInfoRegister analyzer = new AppInfoRegister(targetPath, insertionDAOManager);
                        Set filePathSet = (Set)fileMap.get(targetPath);
                        analyzer.registerFileSet(filePathSet);
                    }
                }
            }
        }
        finally {
            if (insertionDAOManager != null) {
                try {
                    insertionDAOManager.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void tokenize() throws SQLException {
        TokenizerDAOManager tokenizerDAOManager = null;
        try {
            tokenizerDAOManager = new TokenizerDAOManager(this._settings.getDatabasePath());
            CScanPreserver preserver = new CScanPreserver(this._settings.getWorkingPath(), tokenizerDAOManager);
            preserver.analyze();
        }
        finally {
            if (tokenizerDAOManager != null) {
                try {
                    tokenizerDAOManager.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void analyze() throws Exception {
        SelectionDAOManager selectionDAOManager = null;
        try {
            selectionDAOManager = new SelectionDAOManager(this._settings.getDatabasePath());
            CloneInfoRegister portsAnalyzer = new CloneInfoRegister(selectionDAOManager);
            portsAnalyzer.execute();
        }
        finally {
            if (selectionDAOManager != null) {
                try {
                    selectionDAOManager.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void execute() {
        block15: {
            block14: {
                block13: {
                    block12: {
                        time = 0L;
                        try {
                            time = new Date().getTime();
                            this.init();
                            time = new Date().getTime() - time;
                            CliMain._log.info((Object)("init: " + time + " msec."));
                            break block12;
                        }
                        catch (Throwable e) {
                            e.printStackTrace(System.err);
                            var8_10 = stacktraces = e.getStackTrace();
                            var7_14 = stacktraces.length;
                            var6_18 = 0;
                            ** while (var6_18 < var7_14)
                        }
lbl-1000:
                        // 1 sources

                        {
                            stacktrace = var8_10[var6_18];
                            System.err.println(stacktrace);
                            ++var6_18;
                            continue;
                        }
lbl18:
                        // 1 sources

                        return;
                    }
                    try {
                        time = new Date().getTime();
                        this.register();
                        time = new Date().getTime() - time;
                        CliMain._log.info((Object)("register: " + time + " msec."));
                        break block13;
                    }
                    catch (Throwable e) {
                        e.printStackTrace(System.err);
                        var8_11 = stacktraces = e.getStackTrace();
                        var7_15 = stacktraces.length;
                        var6_19 = 0;
                        ** while (var6_19 < var7_15)
                    }
lbl-1000:
                    // 1 sources

                    {
                        stacktrace = var8_11[var6_19];
                        System.err.println(stacktrace);
                        ++var6_19;
                        continue;
                    }
lbl36:
                    // 1 sources

                    return;
                }
                try {
                    time = new Date().getTime();
                    this.tokenize();
                    time = new Date().getTime() - time;
                    CliMain._log.info((Object)("tokenize: " + time + " msec."));
                    break block14;
                }
                catch (Throwable e) {
                    e.printStackTrace(System.err);
                    var8_12 = stacktraces = e.getStackTrace();
                    var7_16 = stacktraces.length;
                    var6_20 = 0;
                    ** while (var6_20 < var7_16)
                }
lbl-1000:
                // 1 sources

                {
                    stacktrace = var8_12[var6_20];
                    System.err.println(stacktrace);
                    ++var6_20;
                    continue;
                }
lbl54:
                // 1 sources

                return;
            }
            try {
                time = new Date().getTime();
                this.analyze();
                time = new Date().getTime() - time;
                CliMain._log.info((Object)("analyze: " + time + " msec."));
                break block15;
            }
            catch (Throwable e) {
                e.printStackTrace(System.err);
                var8_13 = stacktraces = e.getStackTrace();
                var7_17 = stacktraces.length;
                var6_21 = 0;
                ** while (var6_21 < var7_17)
            }
lbl-1000:
            // 1 sources

            {
                stacktrace = var8_13[var6_21];
                System.err.println(stacktrace);
                ++var6_21;
                continue;
            }
lbl72:
            // 1 sources

            return;
        }
    }
}

