#define _GNU_SOURCE
#define DEST "tmp⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊⿊.tmp"

#include "check_lsof.h"
#include "ch_time_and_mod.h"
#include "ch_time_and_mod_dir.h"
#include "filefrag_custom.h"
#include "global.h"
#include "md5.h"
#include "verify_hash.h"
#include "xmalloc.h"

#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <string.h>

#include <errno.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <linux/limits.h>
#include <linux/falloc.h>

char *write_now = NULL;

static char *buf;
static char *md5hash;

#define FALLOC_MISS \
{\
	if(close(ifrom) == -1)\
	{\
		perror("close");\
	}\
\
	if(close(ito) == -1)\
	{\
		perror("close");\
	}\
\
	r = stat(global_parent, &tmp);\
\
	if(unlink(DEST) == -1)\
	{\
		perror("unlink");\
	}\
\
	write_now = NULL;\
\
	if(r > -1)\
	{\
		ch_time_and_mod_dir(global_parent, &tmp);\
	}\
\
	printf("スキップ : (%d) %s\n", from_extents, src);\
	fflush(stdout);\
\
	return;\
}

static void do_rename(const char *src, const struct stat *stat_from);

/*******************************************************************************
*******************************************************************************/
void cp(const char *src, const int from_extents)
{
	struct stat stat_from;

	if(stat(src, &stat_from) == -1)
	{
		perror("stat");
		return;
	}

	_Bool flag_size_check = false;

	if(flag_and_gigabyte == false)
	{
		if(stat_from.st_size >= 1024 * 1024 * 1024)
		{
			flag_size_check = true;
		}
	}

	if(flag_only_gigabyte == true)
	{
		if(stat_from.st_size < 1024 * 1024 * 1024)
		{
			flag_size_check = true;
		}
	}

	if(flag_size_check == true)
	{
		printf("スキップ : (%d) %s\n", from_extents, src);
		return;
	}

	if(check_lsof(src) == false)
	{
		printf("他のプロセスが使用中です : (%d) %s\n", from_extents, src);
		return;
	}

	if(buf == NULL)
	{
		buf = xmalloc(BUF_SIZE);
	}

	int ifrom = open(src, O_RDONLY | O_NOATIME | O_NOFOLLOW);

	if(ifrom == -1)
	{
		switch(errno)
		{
		case EPERM:
			errno = 0;

			if((ifrom = open(src, O_RDONLY)) == -1)
			{
				perror("open");
				return;
			}
			break;

		default:
			perror("open");
			return;
			break;
		}
	}

	struct stat tmp;
	int r = stat(global_parent, &tmp);

	int ito = open(DEST, O_WRONLY | O_CREAT, S_IRWXU);

	if(ito == -1)
	{
		if(close(ifrom) == -1)
		{
			perror("close");
		}

		return;
	}

	write_now = DEST;

	if(r > -1)
	{
		ch_time_and_mod_dir(global_parent, &tmp);
	}

	int to_extents = INT_MAX;
	_Bool file_alloc = false;

	/* Ubuntu 11.04だとfallocateの第二引数は FALLOC_FL_KEEP_SIZE と FALLOC_FL_PUNCH_HOLE の二つ。linux/falloc.h のincludeが必要。 */
	if(fallocate(ito, FALLOC_FL_KEEP_SIZE, 0, stat_from.st_size) == -1)
	{
		perror("fallocate");

		int p_f_r;

		if((p_f_r = posix_fallocate(ito, 0, stat_from.st_size)) != 0)
		{
			errno = p_f_r;
			perror("posix_fallocate");
		}
		else
		{
			file_alloc = true;
		}
	}
	else
	{
		file_alloc = true;
	}

	if(file_alloc == true)
	{
		to_extents = filefrag_custom(DEST);

		if(from_extents <= to_extents)
		{
			FALLOC_MISS
		}
	}
	else
	{
		FALLOC_MISS
	}

	md5_state_t state;
	md5_byte_t digest[16];

	md5_init(&state);

	if(md5hash == NULL)
	{
		md5hash = xmalloc((16 * 2) + 1);
		md5hash[0] = '\0';
	}
	else
	{
		md5hash[0] = '\0';
	}

	{
		printf("デフラグ中 : (%d) %s -> ", from_extents, src);
		fflush(stdout);

		int i = 0;
		char *p;
		char *endp;
		ssize_t b;

		while((i = read(ifrom, buf, BUF_SIZE)) > 0)
		{
			p = buf;
			endp = buf + i;

			while(p < endp)
			{
				b = write(ito, p, endp - p);
				p += b;
			}

			md5_append(&state, (md5_byte_t *)buf, i);
		}
	}

	md5_finish(&state, digest);

	for(int di = 0; di < 16; ++di)
	{
		sprintf(md5hash + di * 2, "%02x", digest[di]);
	}

	struct stat stat_to;

	fstat(ifrom, &stat_from);
	fstat(ito, &stat_to);

	if(fdatasync(ito) == -1)
	{
		perror("fdatasync");
	}

	if(close(ifrom) == -1)
	{
		perror("close");
	}

	if(close(ito) == -1)
	{
		perror("close");
	}

	_Bool ch_flag = false;

	if(stat_from.st_size == stat_to.st_size)
	{
		int i;
		if((i = open(src, O_RDONLY)) != -1)
		{
			ch_time_and_mod(i, DEST, &stat_from);

			if(close(i) == -1)
			{
				perror("close");
			}
		}

		ch_flag = true;
	}

	_Bool b = false;

	b = verify_hash(DEST, stat_to.st_size, md5hash);

	if((b == true) && (ch_flag == true) && (from_extents > to_extents))
	{
		do_rename(src, &stat_from);
		printf("(%d)\n", to_extents);
		fflush(stdout);
	}
	else
	{
		r = stat(global_parent, &tmp);

		if(unlink(DEST) == -1)
		{
			perror("unlink");
		}

		if(r > -1)
		{
			ch_time_and_mod_dir(global_parent, &tmp);
		}

		printf("(%d)\n", from_extents);
		fflush(stdout);
	}

	write_now = NULL;
}

/*******************************************************************************
*******************************************************************************/
void do_rename(const char *src, const struct stat *stat_from)
{
	struct stat tmp;
	int r = stat(global_parent, &tmp);

	if(rename(DEST, src) == -1)
	{
		perror("rename");

		if(unlink(DEST) == -1)
		{
			perror("unlink");
		}

		if(r > -1)
		{
			ch_time_and_mod_dir(global_parent, &tmp);
		}
	}
	else
	{
		if(r > -1)
		{
			ch_time_and_mod_dir(global_parent, &tmp);
		}

		int i;
		if((i = open(src, O_RDONLY)) != -1)
		{
			ch_time_and_mod(i, src, stat_from);

			if(close(i) == -1)
			{
				perror("close");
			}
		}
	}
}
