#define _GNU_SOURCE

#include "replace_string.h"

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <stdbool.h>

#include <linux/limits.h>
#include <errno.h>

_Bool check_lsof(const char *src)
{
	const int REPLACE_LEN = PATH_MAX * 4;
	FILE *pipe_dst = NULL;
	char pipe_buf_dst[PATH_MAX];
	char re_dst[REPLACE_LEN];
	char command_dst[REPLACE_LEN + sizeof("lsof -f -- \'\'") + 1];

	pipe_buf_dst[0] = '\0';
	re_dst[0] = '\0';
	command_dst[0] = '\0';

	strcpy(re_dst, src);
	replace_string(re_dst, "'", "'\\''", REPLACE_LEN);
	sprintf(command_dst, "%s%s%s%s", "lsof -f -- ", "\'", re_dst, "\'");

	{
		errno = 0;
		/* バッファ掃除用の領域 */
		char ctmp[PATH_MAX];

		pipe_dst = popen(command_dst, "r");

		if(pipe_dst != NULL)
		{
			fread(pipe_buf_dst, 1, PATH_MAX, pipe_dst);
			/* パイプのバッファを空にするためにグルグル回す */
			while(fread(ctmp, 1, PATH_MAX, pipe_dst) > 0) {}
		}
	}

	_Bool check;

	if((pipe_dst != NULL) && (strlen(pipe_buf_dst) == 0))
	{
		check = true;
	}
	else
	{
		check = false;
	}

	if(pipe_dst != NULL)
	{
		pclose(pipe_dst);
	}

	/* プロセスがファイルを使用中の場合はfalseを返す */
	return check;
}
