#define _GNU_SOURCE

#include <stdio.h>

#include <errno.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>

/*******************************************************************************
*******************************************************************************/
void ch_time_and_mod_dir(const char *file_path, const struct stat *stat_buf)
{
	errno = 0;

	if(chmod(file_path, stat_buf->st_mode) == -1)
	{
		perror("chmod");
	}
	if(chown(file_path, stat_buf->st_uid, stat_buf->st_gid) == -1)
	{
		perror("chown");
	}

	struct timespec time_s[2];
	time_s[0].tv_sec = stat_buf->st_atime;
	time_s[1].tv_sec = stat_buf->st_mtime;

	time_s[0].tv_nsec = stat_buf->st_atim.tv_nsec;
//	time_s[0].tv_nsec = stat_buf->st_atimensec;
	time_s[1].tv_nsec = stat_buf->st_mtim.tv_nsec;
//	time_s[1].tv_nsec = stat_buf->st_mtimensec;

	// 第四引数は0かAT_SYMLINK_NOFOLLOW
	if(utimensat(AT_FDCWD, file_path, time_s, AT_SYMLINK_NOFOLLOW) == -1)
	{
		perror("utimensat");
	}
}
