#!/usr/bin/env ruby
#
# This file is gererated by ruby-glade-create-template 1.1.3.
#
require 'remastering/glade/remastertool_initGlade'
require 'remastering/remastertool_module'
require 'remastering/remastertool_utility'

require 'fileutils'
require 'rexml/document'

class Remastertool_Init < RemastertoolInitGlade
  include GetText
  include Remastertool_FuncModule

  attr :glade

	bindtextdomain(PROG_NAME, nil, nil, "UTF-8")

	PROG_PATH = "remastertool_init.glade"

	FUNC_NAME = _("Initialize environment")
	FUNC_INIT = _("Initialize")

	# 初期設定ペインの XML要素
	XML_ROOT = ["InitInfo",  _("Initialize_information") ]
	XML_OS = ["OS", _("OS_Information") ]
	XML_OS_XPATH = XML_ROOT[0] + "/" + XML_OS[0]
	XML_OS_NAME = ["name", _("name") ]
	XML_OS_NAME_XPATH = XML_OS_XPATH + "/" + XML_OS_NAME[0]
	XML_OS_VERSION = ["version", _("version") ]
	XML_OS_VERSION_XPATH = XML_OS_XPATH + "/" + XML_OS_VERSION[0]
	XML_DIRECTORY = ["Directory", _("Directory_Information") ]
	XML_DIRECTORY_XPATH = XML_ROOT[0] + "/" + XML_DIRECTORY[0]
	XML_DIRECTORY_MEDIA = ["media", _("media_directory") ]
	XML_DIRECTORY_MEDIA_XPATH = XML_DIRECTORY_XPATH + "/" + XML_DIRECTORY_MEDIA[0]
	XML_DIRECTORY_WORK = ["work", _("work_directory") ]
	XML_DIRECTORY_WORK_XPATH = XML_DIRECTORY_XPATH + "/" + XML_DIRECTORY_WORK[0]

	# メッセージ文字列
	TILTE_DIALOG_BASE_MEDIA_CHOOSER = _("Choose a directory of base media for remastering")
	TILTE_DIALOG_WORK_CHOOSER = _("Choose a working directory")
	WARN_MEDIA_DIR_EMPTY = _("Please sepcify a Base media")
	WARN_WORK_DIR_EMPTY = _("Please sepcify a Working directory")
	WARN_UNKNOWN_MEDIA = _("OS media not found. Please specify Base media correctly")
	ERROR_WORK_DIR_CANT_CREATE = _("Failed to create a Working directory(%s).")
	QUES_INITIALIZE = _("May I initialize remastering environment?")
	WARN_UNKNOWN_PACKAGETYPE = _("%s plugin is requires %s plugin.")


	#=== コンストラクタ
	#
	#画面オブジェクトの作成&初期状態への設定を行う。
	#
	#gladeDir:: gladeファイル格納ディレクトリ
	#domain:: メッセージファイルのドメイン名
	#復帰値:: なし
	#
	def initialize(gladeDir, domain)
		super(File.join(gladeDir, PROG_PATH), nil, domain, nil, GladeXML::FILE)
		init_environ
	end

	#===リマスタリング手順のロード
	#
	#XML形式のリマスタリング手順から画面に表示する要素(メディアディレクトリと作業用
	#ディレクトリ)を取り出し、対応するエントリに設定する。
	#
	#root:: リマスタリング手順 XMLドキュメント
	#復帰値:: なし
	#
	def load_xml(root)
		# XMLドキュメントから メディアディレクトリと作業用ディレクトリを抽出し、
		# インスタンス変数と対応するエントリに設定する。
		elm = root.get_elements(XML_DIRECTORY_MEDIA_XPATH)[0]

		@glade["entry_cd"].text = (elm && elm.text) ? elm.text : ""
		elm = root.get_elements(XML_DIRECTORY_WORK_XPATH)[0]
		@glade["entry_work"].text = (elm && elm.text) ? elm.text : ""

		# 画面の状態設定を行う(OSプラグインを特定するために作業ディレクトリ、またはメディアディレクトリ
		# から特定する)。
		plugin = get_os_plugin(File.join(@glade["entry_work"].text ))
		RTUtility.get_logger.debug("init:load_xml OS(1st): " + plugin.to_s)

		# OSプラグインがサポートしているパッケージプラグインが存在するかチェックする
		if plugin && RTUtility.get_package_plugins().key?(plugin.get_package_type) == false
			# Package type not supported by package plugin
			dlg = Gtk::MessageDialog.new(RTUtility.mainWindow, Gtk::Dialog::MODAL, Gtk::MessageDialog::ERROR,
											Gtk::MessageDialog::BUTTONS_OK,
											sprintf(WARN_UNKNOWN_PACKAGETYPE, plugin.get_plugin_name, plugin.get_package_type))
			dlg.run
			dlg.destroy
			return
		end

#		plugin = get_os_plugin(@glade["entry_cd"].text) unless plugin
		set_display(plugin, @glade["entry_work"].text)

		# 現在の状態を「手順変更なし」に設定する
		fix_procedure
	end

	#===リマスタリング手順のXML化
	#
	#リマスタリング手順をXML形式の要素にして返却する。
	#
	#localize:: ローカライゼーション(0:非ローカライゼーション化XMLを作成, 1:ローカライゼーション化XMLを作成)
	#復帰値:: XML要素(初期設定部)
	#
	def make_xml(localize = 0)
		elmOS = REXML::Element.new(XML_OS[localize])
		os = ""
		ver = ""
		if RTUtility.get_os_plugin
			os = RTUtility.get_os_plugin.get_OS_name
			ver = RTUtility.get_os_plugin.get_OS_version
		end
		elm_child = REXML::Element.new(XML_OS_NAME[localize])
		elm_child.text = os
		elmOS.add_element elm_child
		elm_child = REXML::Element.new(XML_OS_VERSION[localize])
		elm_child.text = ver
		elmOS.add_element elm_child

		elmDir = REXML::Element.new(XML_DIRECTORY[localize])
		elm_child = REXML::Element.new(XML_DIRECTORY_MEDIA[localize])
		elm_child.text = @glade["entry_cd"].text.strip
		elmDir.add_element elm_child
		elm_child = REXML::Element.new(XML_DIRECTORY_WORK[localize])
		elm_child.text = @glade["entry_work"].text.strip
		elmDir.add_element elm_child

		elmRoot = REXML::Element.new(XML_ROOT[localize])
		elmRoot.add_element elmOS
		elmRoot.add_element elmDir

		elmRoot
	end

	#=== リマスタリング手順の変更確認
	#
	#リマスタリング手順に変更があったかを返却する。
	#新規にリマスタリングを開始した場合、起動時からの変更の有無を返却する。
	#リマスタリング手順ファイルを読み込み、続きから作業用を開始した場合は手順
	#読み込み後かの変更の有無を返却する。
	#
	#復帰値:: BOOL true=変更あり、false=変更なし。
	#
	def isModified?
		return @cdDir != @glade["entry_cd"].text || @workDir != @glade["entry_work"].text
	end

	#=== リマスタリング手順の変更確定
	#
	#リマスタリング手順に変更を確定する。
	#本メソッドはリマスタリング手順保存成功時に呼び出される。
	#各プラグインは現在の設定状態はリマスタリング手順変更なしの状態に設定する。
	#次回 isModified? メソッドが呼び出された場合、本メソッドの呼出時からの変更
	#を返却する。
	#
	#復帰値:: なし。
	#
	def fix_procedure
		@cdDir = @glade["entry_cd"].text
		@workDir = @glade["entry_work"].text
	end

	#===リマスタリング環境の初期化
	#
	#リマスタリング環境を初期状態に設定する。
	#
	#復帰値:: なし
	#
	def init_environ
		RTUtility.get_logger.debug("init:init_environ called")
		@cdDir = ""
		@workDir = ""
		@glade["entry_cd"].text = @cdDir
		@glade["entry_work"].text = @workDir

		set_display
	end

	#===手順リスト一覧の取得
	#
	#リマスタリング手順の一覧を返却する。
	#返却した手順一覧は操作手順編集画面の表示に使用される。
	#
	#復帰値:: 手順一覧リスト
	#         [ [手順1], [手順2],...]
	#          手順n = [実行済み(true) or 未実行(false) , 機能名 , 操作内容 , 対象 ]
	#
	def get_procedure_list
		ary = Array.new
		ary.push( [ RTUtility.get_os_plugin != nil, FUNC_NAME, FUNC_INIT, @workDir ] )
		ary
	end

	#===手順リスト一覧の変更反映
	#
	#リマスタリング手順の一覧を現在の手順に反映する。
	#返却した手順一覧は操作手順編集画面での編集結果が通知される。
	#
	#list:: 手順一覧リスト
	#         [ [手順1], [手順2],...]
	#          手順n = [実行済み(true) or 未実行(false) , 機能名 , 操作内容 , 対象 ]
	#復帰値:: なし
	#
	def set_procedure_list(list)
		set_display unless list[0][0]
	end

private

	#=== [参照]ボタン(ベースメディア)クリック持のイベントハンドラ
	#
	#[参照]ボタン(ベースメディア)クリック時に呼び出される。
	#ファイル選択ダイアログを表示し、ベースメディアディレクトリを指定する。指定した
	#ディレクトリは[ベースメディア]エントリに設定する。
	#
	#widget:: [参照]ボタン(ベースメディア)のWidget
	#復帰値:: なし
	#
	def on_button_cd_clicked(widget)
		chooser = Gtk::FileChooserDialog.new(TILTE_DIALOG_BASE_MEDIA_CHOOSER,
												RTUtility.mainWindow,
												Gtk::FileChooser::ACTION_SELECT_FOLDER,
												nil,
												[Gtk::Stock::CANCEL, Gtk::Dialog::RESPONSE_CANCEL],
												[Gtk::Stock::OPEN, Gtk::Dialog::RESPONSE_OK])
		@glade["entry_cd"].set_text(chooser.filename) if chooser.run == Gtk::Dialog::RESPONSE_OK
		chooser.destroy
	end

	#=== [参照]ボタン(作業ディレクトリ)クリック持のイベントハンドラ
	#
	#[参照]ボタン(作業ディレクトリ)クリック時に呼び出される。
	#ファイル選択ダイアログを表示し、作業用ディレクトリを指定する。指定した
	#ディレクトリは[作業ディレクトリ]エントリに設定する。
	#
	#widget:: [参照]ボタン(作業ディレクトリ)のWidget
	#復帰値:: なし
	#
	def on_button_work_clicked(widget)
		chooser = Gtk::FileChooserDialog.new(TILTE_DIALOG_WORK_CHOOSER,
												RTUtility.mainWindow,
												Gtk::FileChooser::ACTION_SELECT_FOLDER,
												nil,
												[Gtk::Stock::CANCEL, Gtk::Dialog::RESPONSE_CANCEL],
												[Gtk::Stock::OPEN, Gtk::Dialog::RESPONSE_OK])
		@glade["entry_work"].set_text(chooser.filename) if chooser.run == Gtk::Dialog::RESPONSE_OK
		chooser.destroy
	end

	#=== [初期化実行]ボタンクリック持のイベントハンドラ
	#
	#[初期化実行]ボタンクリック時に呼び出される。
	#画面の入力欄の内容をチェックし、ベースメディアに対応したOSプラグインの copy_media
	#メソッドを呼び出し、リマスタリング作業環境を作成する。
	#
	#widget:: [初期化実行]ボタンのWidget
	#復帰値:: なし
	#
	def on_button_init_clicked(widget)
		# 設定したディレクトリを検査する。エラー時は入力画面に戻る。
		return unless plugin = check_entry

		# 環境を初期化してもいいか確認する
		dlg = Gtk::MessageDialog.new(RTUtility.mainWindow, Gtk::Dialog::MODAL, Gtk::MessageDialog::QUESTION,
										Gtk::MessageDialog::BUTTONS_YES_NO, QUES_INITIALIZE)
		response = dlg.run
		dlg.destroy
		return false unless response == Gtk::Dialog::RESPONSE_YES

		# 作業ディレクトリの作成
		begin
			FileUtils.mkdir_p(@glade["entry_work"].text)
		rescue
			RTUtility.get_logger.debug("init:on_button_init_clicked called")
			dlgMsg = sprintf(ERROR_WORK_DIR_CANT_CREATE, $!.to_s)
			dlg = Gtk::MessageDialog.new(RTUtility.mainWindow, Gtk::Dialog::MODAL, Gtk::MessageDialog::ERROR,
											Gtk::MessageDialog::BUTTONS_OK, dlgMsg)
			dlg.run
			dlg.destroy
			RTUtility.get_logger.debug("init:on_button_init_clicked " + dlgMsg)
			return
		end

		# 初期化を行うにあたりデフォルト画面の初期化を行う
		set_display
	
		# copy media to working directory
		if plugin.copy_media(@glade["entry_cd"].text.strip, @glade["entry_work"].text.strip)
			set_display(plugin, @glade["entry_work"].text.strip)
			RTUtility.import	# 環境のimportを実施する
		end
	end

	#=== 入力項目チェック処理
	#
	#ベースメディア、作業ディレクトリに指定されているディレクトリが正しいかチェックする。
	#
	#復帰値:: 入力チェックOK時=OSプラグインのインスタンス, 入力チェックNG時=nil
	#
	def check_entry
		begin
			#
			# エディットボックスの内容をチェックする
			#
			# No.1 : ベースメディアの未入力をチェックする。
			raise WARN_MEDIA_DIR_EMPTY if @glade["entry_cd"].text.strip.empty?
	
			# No.2 : Working directory is empty? 
			raise WARN_WORK_DIR_EMPTY if @glade["entry_work"].text.strip.empty?

			# No.3 : ベースメディアが正しく指定されているかチェックする。
			plugin = get_os_plugin @glade["entry_cd"].text.strip
			raise WARN_UNKNOWN_MEDIA unless plugin

			# No4: OSプラグインがサポートしているパッケージプラグインが存在するかチェックする
			unless RTUtility.get_package_plugins().key?(plugin.get_package_type)
				# Package type not supported by package plugin
				raise sprintf(WARN_UNKNOWN_PACKAGETYPE, plugin.get_plugin_name, plugin.get_package_type)
			end

			plugin

		rescue
			# 警告メッセージを表示する
			dlg = Gtk::MessageDialog.new(RTUtility.mainWindow, Gtk::Dialog::MODAL, Gtk::MessageDialog::WARNING,
											Gtk::MessageDialog::BUTTONS_OK, $!.to_s)
			dlg.run
			dlg.destroy
			RTUtility.get_logger.error("init:check_entry " + $!.to_s)

			nil
		end
	end

	#=== OSプラグインの取得
	#
	#メディアディレクトリの設定からどのOSプラグインに対応しているメディアかチェックする。
	#
	#復帰値:: OSプラグインのインスタンス。該当するOSプラグインがなければnil
	#
	def get_os_plugin(media)
		plugin = nil
		RTUtility.get_os_plugins.each_value {|value|
			# 各OSプラグインに対してベースメディアが自プラグインでサポートしている
			# 形式か確認する
			if value.isYou? media
				# ベースメディアに対応するプラグインが見つかったらループを抜ける
				plugin = value
				break
			end
		}
		plugin
	end

	#=== 画面状態の設定
	#
	#OSプラグインに作業用ディレクトリの初期設定が完了しているか問い合わせを行い、
	#その結果により、画面の状態(サイドバーの有効/無効)、ユーティリティクラスへの
	#OSプラグイン、ネイティブパッケージ形式)を通知する。
	#
	#plugin:: OSプラグイン(省略値はnil)
	#workDir:: 作業用ディレクトリ(省略値は"")
	#復帰値:: なし
	#
	def set_display(plugin = nil, workDir = "")
		if plugin && plugin.isInitialized?(workDir)
			plugin.use_directory workDir
			RTUtility.set_work_dir(workDir)
			RTUtility.set_os_plugin plugin.get_plugin_name
			RTUtility.set_native_pkg_plugin plugin.get_package_type
			RTUtility.enable_sidebar_button true
		else

			RTUtility.enable_sidebar_button false	# サイドバーボタンを一部マスク
			RTUtility.set_os_plugin nil				# OSプラグインの初期化
			RTUtility.set_native_pkg_plugin nil		# パッケージプラグインの初期化
		end
	end

end
