#!/usr/bin/env ruby
#
# This file is gererated by ruby-glade-create-template 1.1.3.
#

require 'gnomevfs'

require 'remastering/glade/remastertool_fileGlade'
require 'remastering/remastertool_module'

class RemastertoolFile < RemastertoolFileGlade
  include GetText
  include Remastertool_FuncModule

  attr :glade

	PROG_PATH = "remastertool_file.glade"

	bindtextdomain(PROG_NAME, nil, nil, "UTF-8")

	EDITWORK = "editwork"

	APPEND = _("append")
	DELETE = _("delete")
	EDIT = _("edit")

	HASH_TO_XML = { APPEND => "append", DELETE => "delete", EDIT => "edit" }
	HASH_FROM_XML = HASH_TO_XML.invert

	HEADER_SELECT_LIST = [_("Name"), _("Source"), _("Operation"), _("executed") ]
	FUNC_NAME = _("File exchange")

	# ファイル操作ペインの XML要素
	XML_ROOT = ["FileInfo", _("File_operation_information")]
	XML_FILE = ["File", _("File ")]
	XML_FILE_ATTR_NAME = ["name", _("name")]
	XML_FILE_ATTR_OPERATION = ["operation", _("operation")]
	XML_FILE_ATTR_SOURCE = ["source", _("source")]
	XML_FILE_ATTR_EXEC = ["exec", _("execution")]
	XML_FILE_XPATH = XML_ROOT[0] + "/" + XML_FILE[0]
	XML_DO_EXECUTED = [_("done"), _("not done")]

	CMD_DELETE = "rm -f %s"
	CMD_COPY = "cp -a %s %s"

	MSG_WARN_NO_WORKOSFILE = _("Please specify the file which copied from works OS.")
	MSG_WARN_NO_REMASTEROSFILE = _("Please specify the file which copied to remastering OS.")
	MSG_TITLE_WORKOSFILE = _("Choose file copied from work OS")
	MSG_TITLE_REMASTEROSFILE = _("Choose file copied from remastering OS.")
	MSG_TITLE_CHOOSE_APPLICATION = _("Choose edit command.")
	MSG_WAIT_EXPORT = _("The resource used by the file operation function is exported.")
	MSG_WAIT_IMPORT = _("The resource used by the file operation function is imported.")
	MSG_WAIT_INSTALL_FILE = _("Now executing operation of file.\nPlease wait for a while.")
	MSG_ERR_EXPORT = _("Failed to export.\n%s")
	MSG_ERR_IMPORT = _("Failed to import.\n%s")
	MSG_ERR_INSTALL_FILE = _("Failed to operation of the %s file(%d).")
	MSG_ERR_COPY_TO_EDIT = _("Failed to copy of file to work area(%s).")

	# Gconf アクセスキー
	CONF_KEY_EDIT_APPLICATION = "/apps/remasteringtool/file/application"

	#=== ファイル面面の初期化処理
	#
	#ファイル画面を初期化する。
	#
	#gladeDir:: gladeファイル格納ディレクトリ
	#domain:: メッセージファイルドメイン名
	#file_pane_obj:: ファイル画面のインスタンス
	#復帰値:: なし
	#
	def initialize(gladeDir, domain)
		super(File.join(gladeDir, PROG_PATH), nil, domain, nil, GladeXML::FILE)

		@treeFile = nil
		@modified = false
		@mimelist = Array.new

		# Gnome-VFS initialize
		GnomeVFS.init

		# display selected file list
		careate_selected_file_list

		# create edit dialog
		create_edit_dialog

		# initialize environment
		init_environ
	end

	#===リマスタリング手順のロード
	#
	#XML形式のリマスタリング手順から画面に表示する要素(メディアディレクトリと作業用
	#ディレクトリ)を取り出し、対応するエントリに設定する。
	#
	#root:: リマスタリング手順 XMLドキュメント
	#復帰値:: なし
	#
	def load_xml(root)
		# XMLドキュメントから メディアディレクトリと作業用ディレクトリを抽出し、
		# インスタンス変数と対応するエントリに設定する。
		root.get_elements(XML_FILE_XPATH).each{|elm|
			name = elm.attributes[XML_FILE_ATTR_NAME[0]]
			operation = HASH_FROM_XML[elm.attributes[XML_FILE_ATTR_OPERATION[0]]]
			source = elm.attributes[XML_FILE_ATTR_SOURCE[0]]
			executed = elm.attributes[XML_FILE_ATTR_EXEC[0]]

			next if name == nil || operation == nil || source == nil || executed == nil
			# 操作ファイル一覧リストに追加する
			apped_select_list(name, operation, source, (executed.casecmp(true.to_s) == 0).to_s)
			@modified = false
		}
	end

	#===リマスタリング手順のXML化
	#
	#リマスタリング手順をXML形式の要素にして返却する。
	#
	#localize:: ローカライゼーション(0:非ローカライゼーション化XMLを作成, 1:ローカライゼーション化XMLを作成)
	#復帰値:: XML要素(初期設定部)
	#
	def make_xml(localize = 0)
		elmRoot = REXML::Element.new(XML_ROOT[localize])
		
		iter = @glade["treeview_list"].model.iter_first
		if iter
			begin
				elm = REXML::Element.new(XML_FILE[localize])
				elm.add_attribute(XML_FILE_ATTR_NAME[localize], iter[0])
				if localize == 0
					elm.add_attribute(XML_FILE_ATTR_OPERATION[localize], HASH_TO_XML[iter[2]])
				else
					elm.add_attribute(XML_FILE_ATTR_OPERATION[localize], iter[2])
				end
				elm.add_attribute(XML_FILE_ATTR_SOURCE[localize], iter[1])
				if localize == 0
					elm.add_attribute(XML_FILE_ATTR_EXEC[localize], iter[3])
				else
					elm.add_attribute(XML_FILE_ATTR_EXEC[localize], iter[3].casecmp(true.to_s) == 0 ? XML_DO_EXECUTED[0] : XML_DO_EXECUTED[1])
				end
				elmRoot.add_element elm
			end while iter.next!
		end
		elmRoot
	end

	#===リマスタリング環境の初期化
	#
	#リマスタリング環境を初期状態に設定する。
	#
	#復帰値:: なし
	#
	def init_environ
		@glade["treeview_list"].model.clear
		@modified = false
	end

	#===手順リスト一覧の取得
	#
	#リマスタリング手順の一覧を返却する。
	#返却した手順一覧は操作手順編集画面の表示に使用される。
	#
	#復帰値:: 手順一覧リスト
	#         [ [手順1], [手順2],...]
	#          手順n = [実行済み(true) or 未実行(false) , 機能名 , 操作内容 , 対象 ]
	#
	def get_procedure_list
		ary = Array.new
		iter = @glade["treeview_list"].model.iter_first
		if iter
			begin
				ary.push( [ iter[3].casecmp(true.to_s) == 0, FUNC_NAME, iter[2], iter[0] ] )
			end while iter.next!
		end
		ary
	end

	#===手順リスト一覧の変更反映
	#
	#リマスタリング手順の一覧を現在の手順に反映する。
	#返却した手順一覧は操作手順編集画面での編集結果が通知される。
	#
	#list:: 手順一覧リスト
	#         [ [手順1], [手順2],...]
	#          手順n = [実行済み(true) or 未実行(false) , 機能名 , 操作内容 , 対象 ]
	#復帰値:: なし
	#
	def set_procedure_list(list)
		index = 0
		iter = @glade["treeview_list"].model.iter_first
		if iter
			begin
				iter[3] = (list[index][0]).to_s
				index+= 1
			end while iter.next!
		end
	end

	#===ファイルの入れ替え
	#
	#操作一覧リストの手順にしたがってファイルの入れ替えを行う。
	#
	#復帰値:: BOOL true=問題なし、false=問題あり
	#
	def install_file
		iter = @glade["treeview_list"].model.iter_first
		if iter
			RTUtility.show_wait_window(RTUtility.mainWindow, MSG_WAIT_INSTALL_FILE)
			begin
				unless iter[3].casecmp(true.to_s) == 0
					case iter[2]
					when APPEND, EDIT
						dest = File.join(RTUtility.get_os_plugin.get_root_dir, iter[0])
						FileUtils.mkdir_p(File.dirname(dest))
						cmd = sprintf(CMD_COPY, File.join(RTUtility.get_work_dir, EDITWORK, iter[0]), dest)
					when DELETE
						cmd = sprintf(CMD_DELETE, File.join(RTUtility.get_os_plugin.get_root_dir, iter[0]))
					else
						next
					end
					status = RTUtility.exec_workOS_command(cmd)
					unless status == 0
						RTUtility.end_wait_window
						dlgMsg = sprintf(MSG_ERR_INSTALL_FILE, iter[0], status)
						dlg = Gtk::MessageDialog.new(RTUtility.mainWindow, Gtk::Dialog::MODAL,
								Gtk::MessageDialog::ERROR, Gtk::MessageDialog::BUTTONS_OK, dlgMsg)
						dlg.run
						dlg.destroy
						RTUtility.get_logger.error("file:install_file " + dlgMsg)
						return false
					end
					iter[3] = true.to_s
					@modified = true
				end
			end while iter.next!
			RTUtility.end_wait_window
		end
		true
	end

	#=== 最新情報への更新
	#
	#画面の表示情報を最新状態に更新する。
	#
	#復帰値:: なし
	#
	def refresh
		@treeFile.refresh if @treeFile
	end

	#=== リマスタリング環境のインポート
	#
	#引数のdirで示すディレクトリ内の資産を現在のリマスタリング環境に適用する。
	#
	#dir:: インポート資源ディレクトリ
	#復帰値:: BOOL true=正常終了、false=異常終了
	#
	def import(dir)
		src = File.join(dir, EDITWORK)
		begin
			RTUtility.exec_workOS_command("cp -a " + src + " " + RTUtility.get_work_dir, nil, nil, nil, RTUtility.mainWindow, MSG_WAIT_IMPORT) if File.directory?(src)
		rescue
			dlg = Gtk::MessageDialog.new(RTUtility.mainWindow, Gtk::Dialog::MODAL,
						Gtk::MessageDialog::ERROR, Gtk::MessageDialog::BUTTONS_OK, sprintf(MSG_ERR_IMPORT, $!.to_s))
			dlg.run
			dlg.destroy
			RTUtility.get_logger.error("file:import " + sprintf(MSG_ERR_IMPORT, $!.to_s))
			return false
		end
		true
	end

	#=== リマスタリング環境のエクスポート
	#
	#引数のdirで示すディレクトリにの現在のリマスタリング環境資産を格納する。
	#
	#dir:: エクスポート先ディレクトリ
	#復帰値:: BOOL true=正常終了、false=異常終了
	#
	def export(dir)
		# 作業用ディレクトリ配下のeditworkディレクトリをexpoerディレクトリにコピーする
		src = File.join(RTUtility.get_work_dir, EDITWORK)
		begin
			RTUtility.exec_workOS_command("cp -a " + src + " " + dir, nil, nil, nil, RTUtility.mainWindow, MSG_WAIT_EXPORT) if File.directory?(src)
		rescue
			dlg = Gtk::MessageDialog.new(RTUtility.mainWindow, Gtk::Dialog::MODAL,
						Gtk::MessageDialog::ERROR, Gtk::MessageDialog::BUTTONS_OK, sprintf(MSG_ERR_EXPORT, $!.to_s))
			dlg.run
			dlg.destroy
			RTUtility.get_logger.error("file:export " + sprintf(MSG_ERR_EXPORT, $!.to_s))
			return false
		end
		true
	end

private

	#=== ファイル操作画面表示時のイベントハンドラ
	#
	#ファイル操作画面表示時に呼び出され、初回表示時にリマスタリング対象OSのツリーを作成する。
	#
	#widget:: ファイル操作画面のボックスwidget
	#復帰値:: なし
	#
	def on_mainBox_map(widget)
		return if @treeFile

		@treeFile = RTFileTreeView.new(true)

		# ツリークリック時のシグナルを登録する
		@treeFile.signal_connect("button_press_event") {|widget, event|
			if event.kind_of?(Gdk::EventButton) && event.button == 3
				path = @treeFile.get_selected_file
				sense = path ? true : false
				edit_sense = (path and File.directory?(path) == false)
				@glade["item_tree_edit"].sensitive = edit_sense
				@glade["item_tree_delete"].sensitive = sense
				@glade["menu_tree"].popup(nil, nil, event.button, event.time)
			end
		}
		@glade["label_title_tree"].mnemonic_widget = @treeFile
		@glade["scrolledwindow_tree"].add(@treeFile)
	end

	#=== 操作ファイル一覧リストの作成
	#
	#操作ファイル一覧リストを作成する。
	#
	#復帰値:: なし
	#
	def careate_selected_file_list
		HEADER_SELECT_LIST.each_with_index { |name, i|
			@glade["treeview_list"].append_column(Gtk::TreeViewColumn.new(name, Gtk::CellRendererText.new, :text => i))
		}
		@glade["treeview_list"].columns.each{|col| col.resizable = true}
		@glade["treeview_list"].get_column(3).visible = false

		model = Gtk::ListStore.new(String, String, String, String)
		@glade["treeview_list"].set_model(model)
		@glade["treeview_list"].selection.mode = Gtk::SELECTION_MULTIPLE
	end


	#=== [削除]ボタン(操作ファイル一覧)のイベントハンドラ
	#
	#[削除]ボタン(操作ファイル一覧)のクリック時に操作ファイル一覧リストで選択しているファイルをリスト
	#から削除する
	#
	#widget:: [削除]ボタン(操作ファイル一覧)のWidget
	#復帰値:: なし
	#
	def on_button_list_del_clicked(widget)
		if RTUtility.del_list(@glade["treeview_list"])
			@modified = true
			RTUtility.need_osimage_remake	# OSイメージの再作成が必要であることを通知
		end
	end

	#=== [削除]ボタン(ツリー)のイベントハンドラ
	#
	#[削除]ボタン(ツリー)のクリック時にツリーで選択しているファイル(ディレクトリ)を
	#操作ファイル一覧リストに操作=削除で追加する。
	#
	#widget:: [削除]ボタン(ツリー)のWidget
	#復帰値:: なし
	#
	def on_button_tree_del_clicked(widget)
		path = @treeFile.get_selected_file
		return unless path

		apped_select_list(path.sub(/^#{RTUtility.get_os_plugin.get_root_dir}/, ""), DELETE)
	end

	#=== [追加]ボタン(ツリー)のイベントハンドラ
	#
	#[追加]ボタン(ツリー)のクリック時にファイル選択ダイアログを開き、作業用OSからコピーする
	#ファイルを選択する。
	#
	#widget:: [追加]ボタン(ツリー)のWidget
	#復帰値:: なし
	#
	def on_button_tree_add_clicked(widget)
		path = @treeFile.get_selected_file ? @treeFile.get_selected_file : ""

		@glade["entry_remasteros_file"].text = path
		@glade["dialog_fileadd"].set_transient_for(RTUtility.mainWindow)
		@glade["dialog_fileadd"].show
	end

	#=== [編集]ボタン(ツリー)のイベントハンドラ
	#
	#[編集]ボタン(ツリー)のクリック時にファイル編集ダイアログを開き、編集に使用するアプリケーションを
	#選択する。
	#
	#widget:: [編集]ボタン(ツリー)のWidget
	#復帰値:: なし
	#
	def on_button_tree_edit_clicked(widget)
		path = @treeFile.get_selected_file
		return unless path
		return if File.directory?(path)

		@glade["dialog_fileedit"].set_transient_for(RTUtility.mainWindow)
		@glade["dialog_fileedit"].show
		@glade["dialog_fileedit"].run
		return if @launch_cmd.empty?

		# ツリーで選択したファイルを一時ファイルにコピーする
		dest_dir = File.join(RTUtility.get_work_dir, EDITWORK, File.dirname(path))
		begin
			FileUtils.mkdir_p(dest_dir)
			dest = File.join(RTUtility.get_work_dir, EDITWORK, path)
			src = File.join(RTUtility.get_os_plugin.get_root_dir, path)
			RTUtility.exec_workOS_command(sprintf(CMD_COPY, src, dest)) unless File.exist?(dest)
		rescue
			dlg = Gtk::MessageDialog.new(RTUtility.mainWindow, Gtk::Dialog::MODAL,
					Gtk::MessageDialog::ERROR,
					Gtk::MessageDialog::BUTTONS_OK, sprintf(MSG_ERR_COPY_TO_EDIT, $!.to_s))
			dlg.run
			dlg.destroy
			RTUtility.get_logger.error("file:on_button_tree_edit_clicked " + $!.to_s)
			return
		end

		apped_select_list(path, EDIT, "")
		system(@launch_cmd + " " + dest + "&")
	end

	#=== [操作ファイル一覧]リスト上でのマウスクリック時のイベントハンドラ
	#
	#[操作ファイル一覧]リスト上でマウスを右クリックしたときにポップアップメニューを表示する。
	#
	#widget:: [操作ファイル一覧]リストのWidget
	#event:: イベント
	#復帰値:: なし
	#
	def on_treeview_list_button_press_event(widget, event)
		if event.kind_of?(Gdk::EventButton) && event.button == 3
			select = false
			widget.selection.selected_each{|model, path, iter|
				select = true
				break
			}
			@glade["item_list_delete"].sensitive = select
			@glade["menu_list"].popup(nil, nil, event.button, event.time)
		end
	end

	#=== ポップアップメニューの[削除]クリック時のイベントハンドラ(操作ファイル一覧リスト)
	#
	#削除ボタンクリック時のイベントハンドラを呼び出し、[削除]ボタンクリック時と同じ動作を
	#実現する。
	#
	#widget:: ポップアップメニューのWidget
	#復帰値:: なし
	#
	def on_item_list_delete_activate(widget)
		on_button_list_del_clicked(@glade["button_list_del"])
	end

	#=== ポップアップメニューの[追加]クリック時のイベントハンドラ(ツリー)
	#
	#追加ボタンクリック時のイベントハンドラを呼び出し、[追加]ボタンクリック時と同じ動作を
	#実現する。
	#
	#widget:: ポップアップメニューのWidget
	#復帰値:: なし
	#
	def on_item_tree_add_activate(widget)
		on_button_tree_add_clicked(@glade["button_tree_add"])
	end

	#=== ポップアップメニューの[削除]クリック時のイベントハンドラ(ツリー)
	#
	#削除ボタンクリック時のイベントハンドラを呼び出し、[削除]ボタンクリック時と同じ動作を
	#実現する。
	#
	#widget:: ポップアップメニューのWidget
	#復帰値:: なし
	#
	def on_item_tree_delete_activate(widget)
		on_button_tree_del_clicked(@glade["button_tree_del"])
	end

	#=== ポップアップメニューの[編集]クリック時のイベントハンドラ(ツリー)
	#
	#編集ボタンクリック時のイベントハンドラを呼び出し、[編集]ボタンクリック時と同じ動作を
	#実現する。
	#
	#widget:: ポップアップメニューのWidget
	#復帰値:: なし
	#
	def on_item_tree_edit_activate(widget)
		on_button_tree_edit_clicked(@glade["button_tree_edit"])
	end


	#=== 操作ファイル一覧リストへのエントリ追加
	#
	#操作ファイル一覧リストエントリを追加する。既に同一ファイルに対するエントリが存在する場合、
	#エントリを追加しない。
	#
	#file:: 操作ファイル一覧リストに追加するファイル名
	#operation:: 操作内容
	#source:: コピー元(編集した一時ファイル)のパス
	#executed:: 手順実行済み(true) or 未実行(false)
	#復帰値:: なし
	#
	def apped_select_list(file, operation, source = "", executed = false)
		exist = false
		iter = @glade["treeview_list"].model.iter_first
		if iter
			begin
				if iter[0] == file
					exist = true
					break
				end
			end while iter.next!
		end

		# 同一ファイルが存在している場合、同一エントリありとみなす
		return false if exist

		iter = @glade["treeview_list"].model.append
		iter[0] = file
		iter[1] = source
		iter[2] = operation
		iter[3] = executed.to_s
		@modified = true	# 手順の変更あり

		RTUtility.need_osimage_remake	# OSイメージの再作成が必要であることを通知
		true
	end

	########################################################
	# ファイル追加ダイアログ
	########################################################

	#=== [x]ボタンクリック持のイベントハンドラ
	#
	#[x]ボタンクリック時に[閉じる]ボタンのハンドラを呼び出し、[閉じる]ボタンと同じ動作を実現する。
	#
	#widget:: ファイル追加ダイアログのWidget
	#arg0:: 未使用
	#復帰値:: なし
	#
	def on_dialog_fileadd_delete_event(widget, arg0)
		on_fileadd_cancelbutton_clicked(@glade["fileadd_cancelbutton"])
	end

	#=== [キャンセル]ボタンクリック持のイベントハンドラ
	#
	#[キャンセル]ボタンクリック時にファイル追加ダイアログを閉じる。
	#
	#widget:: キャンセルボタンのWidget
	#復帰値:: なし
	#
	def on_fileadd_cancelbutton_clicked(widget)
		@glade["entry_workos_file"].text = @glade["entry_remasteros_file"].text = ""
		@glade["dialog_fileadd"].hide
	end

	#=== [OK]ボタンクリック持のイベントハンドラ
	#
	#[OK]ボタンクリック時に指定したファイルのコピー情報をファイル操作画面のリストに追加する。
	#
	#widget:: OKボタンのWidget
	#復帰値:: なし
	#
	def on_fileadd_okbutton_clicked(widget)
		begin
			# 入力チェック
			raise MSG_WARN_NO_WORKOSFILE if @glade["entry_workos_file"].text.strip.empty?
			raise MSG_WARN_NO_REMASTEROSFILE if @glade["entry_remasteros_file"].text.strip.empty?
		rescue
			dlg = Gtk::MessageDialog.new(RTUtility.mainWindow, Gtk::Dialog::MODAL,
					Gtk::MessageDialog::WARNING,
					Gtk::MessageDialog::BUTTONS_OK, $!.to_s)
			dlg.run
			dlg.destroy
			RTUtility.get_logger.warn("file:on_fileadd_okbutton_clicked " + $!.to_s)
			return
		end

		# コピー元のファイルを一時ファイルにコピーする
		src = @glade["entry_workos_file"].text.strip
		dest = File.join(RTUtility.get_work_dir, EDITWORK, @glade["entry_remasteros_file"].text.strip)
		real_dest = File.join(RTUtility.get_os_plugin.get_root_dir,  @glade["entry_remasteros_file"].text.strip)
		begin
			FileUtils.mkdir_p(File.dirname(dest))
			FileUtils.mkdir_p(dest) if File.directory?(real_dest)
			RTUtility.exec_workOS_command(sprintf(CMD_COPY, src, dest))
		rescue
			dlg = Gtk::MessageDialog.new(RTUtility.mainWindow, Gtk::Dialog::MODAL,
					Gtk::MessageDialog::ERROR,
					Gtk::MessageDialog::BUTTONS_OK, sprintf(MSG_ERR_COPY_TO_EDIT, $!.to_s))
			dlg.run
			dlg.destroy
			RTUtility.get_logger.error("file:on_fileadd_okbutton_clicked " + $!.to_s)
			return
		end

		# ファイル操作リストに指定したファイルのエントリを追加する
		apped_select_list(@glade["entry_remasteros_file"].text.strip, APPEND, @glade["entry_workos_file"].text.strip)
		on_fileadd_cancelbutton_clicked(@glade["fileadd_cancelbutton"])
	end

	#=== [参照]ボタンクリック持のイベントハンドラ
	#
	#[参照]ボタンクリック時にファイル選択ダイアログを開き、リマスタリング対象OS(コピー先)
	#のファイルを選択する。選択したファイルはファイル追加ダイアログに設定する。
	#
	#widget:: 参照ボタンのWidget
	#復帰値:: なし
	#
	def on_button_sel_remaster_os_clicked(widget)
		dialog = Gtk::FileChooserDialog.new(MSG_TITLE_REMASTEROSFILE,
							@glade["dialog_fileadd"],
							Gtk::FileChooser::ACTION_OPEN,
							nil,
							[Gtk::Stock::CANCEL, Gtk::Dialog::RESPONSE_CANCEL],
							[Gtk::Stock::OPEN, Gtk::Dialog::RESPONSE_OK])

		name = File.join(RTUtility.get_os_plugin.get_root_dir, @glade["entry_remasteros_file"].text.strip)
		if File.directory?(name)
			dialog.current_folder = name
		elsif File.directory?(File.dirname(name))
			dialog.current_folder = File.dirname(name)
			dialog.filename = name
		else
			dialog.current_folder = RTUtility.get_os_plugin.get_root_dir
		end
		
		if dialog.run == Gtk::Dialog::RESPONSE_OK
			@glade["entry_remasteros_file"].text = dialog.filename.sub(RTUtility.get_os_plugin.get_root_dir, "")
		end
		dialog.destroy
	end

	#=== [参照]ボタンクリック持のイベントハンドラ
	#
	#[参照]ボタンクリック時にファイル選択ダイアログを開き、作業用OS(コピー元)
	#のファイルを選択する。選択したファイルはファイル追加ダイアログに設定する。
	#
	#widget:: 参照ボタンのWidget
	#復帰値:: なし
	#
	def on_button_sel_workos_clicked(widget)
		dialog = Gtk::FileChooserDialog.new(MSG_TITLE_WORKOSFILE,
							@glade["dialog_fileadd"],
							Gtk::FileChooser::ACTION_OPEN,
							nil,
							[Gtk::Stock::CANCEL, Gtk::Dialog::RESPONSE_CANCEL],
							[Gtk::Stock::OPEN, Gtk::Dialog::RESPONSE_OK])
		name = @glade["entry_workos_file"].text.strip
		name = "/" if name.empty?
		if File.directory?(name)
			dialog.current_folder = name
		elsif File.directory?(File.dirname(name))
			dialog.current_folder = File.dirname(name)
			dialog.filename = name
		else
			dialog.current_folder = "/"
		end

		if dialog.run == Gtk::Dialog::RESPONSE_OK
			@glade["entry_workos_file"].text = dialog.filename
		end
		dialog.destroy
	end

	########################################################
	# ファイル編集ダイアログ
	########################################################

	#=== ファイル編集ダイアログの作成
	#
	#ファイル編集ダイアログ内部品を作成する。
	#
	#復帰値:: なし
	#
	def create_edit_dialog
		@glade["treeview_edit_list"].append_column(Gtk::TreeViewColumn.new("name", Gtk::CellRendererText.new, :text => 0))
		@glade["treeview_edit_list"].append_column(Gtk::TreeViewColumn.new("index", Gtk::CellRendererText.new, :text => 1))
		@glade["treeview_edit_list"].set_model(Gtk::ListStore.new(String, String))
		@glade["treeview_edit_list"].get_column(1).visible = false
	end

	#=== ファイル編集ダイアログ表示時のイベントハンドラ
	#
	#ファイル操作画面で[編集]ボタンクリック時に、ファイル編集ダイアログが表示される
	#ときに呼び出されるイベントハンドラ。
	#編集に使用可能なアプリケーションの一覧をリストに設定する。
	#
	#widget:: ファイル編集ダイアログのWidget
	#復帰値:: なし
	#
	def on_dialog_fileedit_map(widget)
		# 変数の初期化
		@mimelist.clear
		@type = nil
		@launch_cmd = ""

		# ツリーで選択しているファイルを取得する
		path = @treeFile.get_selected_file
		return unless path
		path = File.join(RTUtility.get_os_plugin.get_root_dir, path)
		return if File.directory?(path)

		# mime typeの判定
		@type = GnomeVFS::get_mime_type(path)

		# デフォルト（前回選択した）アプリケーションを取得する
		gconf = GConf::Client.default
		default = gconf[CONF_KEY_EDIT_APPLICATION + "/" + (@type ? @type : "unknown")]

		# mime typeからアプリケーションの一覧を作成
		sel_iter = nil
		if @type
			@glade["treeview_edit_list"].model.clear
			@mimelist = GnomeVFS::Mime::get_all_applications(@type)
			@mimelist && @mimelist.each_with_index{|mime, idx|
				iter = @glade["treeview_edit_list"].model.append
				iter[0] = mime.name
				iter[1] = idx.to_s
				sel_iter = iter if mime.name == default
			}
		end
		if sel_iter
			@glade["treeview_edit_list"].selection.select_iter(sel_iter)
		elsif default
			iter = @glade["treeview_edit_list"].model.append
			iter[0] = default
			iter[1] = ""
			@glade["treeview_edit_list"].selection.select_iter(iter)
		end
	end

	#=== [x]ボタンクリック持のイベントハンドラ
	#
	#[x]ボタンクリック時に[閉じる]ボタンのハンドラを呼び出し、[閉じる]ボタンと同じ動作を実現する。
	#
	#widget:: ファイル追加ダイアログのWidget
	#arg0:: 未使用
	#復帰値:: なし
	#
	def on_dialog_fileedit_delete_event(widget, arg0)
		on_button_edit_cancel_clicked(@glade["button_edit_cancel"])
	end


	#=== [キャンセル]ボタンクリック持のイベントハンドラ
	#
	#[キャンセル]ボタンクリック時にファイル追加ダイアログを閉じる。
	#
	#widget:: キャンセルボタンのWidget
	#復帰値:: なし
	#
	def on_button_edit_cancel_clicked(widget)
		@launch_cmd = ""
		@glade["dialog_fileedit"].hide
	end

	#=== [OK]ボタンクリック持のイベントハンドラ
	#
	#[OK]ボタンクリック時に選択したアプリケーション起動コマンドをメンバ変数
	#に設定してダイアログを閉じる。
	#
	#widget:: OKボタンのWidget
	#復帰値:: なし
	#
	def on_button_edit_ok_clicked(widget)
		iter = @glade["treeview_edit_list"].selection.selected
		return unless iter

		name = ""
		cmd = ""
		if iter[1].empty?
			name = cmd = iter[0]
		else
			appMime = @mimelist[iter[1].to_i]
			if appMime.requires_terminal
				cmd = sprintf("kterm -e %s ", appMime.command)
			else
				cmd = appMime.command
			end
			name = appMime.name
		end
		@launch_cmd = cmd
		@launch_cmd.gsub!(/%./, "")
		@launch_cmd.gsub!(/-caption/, "")
		@launch_cmd.gsub!(/""/, "")
		@glade["dialog_fileedit"].hide
		gconf = GConf::Client.default
		gconf[CONF_KEY_EDIT_APPLICATION + "/" + (@type ? @type : "unknown")] = name
	end

	#=== [その他]ボタンクリック持のイベントハンドラ
	#
	#[その他]ボタンクリック時にファイル選択ダイアログを開き、ファイルの編集に使用
	#するアプリケーションを選択する
	#
	#widget:: その他ボタンのWidget
	#復帰値:: なし
	#
	def on_button_edit_other_clicked(widget)
		dialog = Gtk::FileChooserDialog.new(MSG_TITLE_CHOOSE_APPLICATION,
							@glade["dialog_fileedit"],
							Gtk::FileChooser::ACTION_OPEN,
							nil,
							[Gtk::Stock::CANCEL, Gtk::Dialog::RESPONSE_CANCEL],
							[Gtk::Stock::OPEN, Gtk::Dialog::RESPONSE_OK])

		if dialog.run == Gtk::Dialog::RESPONSE_OK
			@launch_cmd = dialog.filename + " "
			gconf = GConf::Client.default
			gconf[CONF_KEY_EDIT_APPLICATION + "/" + (@type ? @type : "unknown")] = @launch_cmd
			@glade["dialog_fileedit"].hide
		end
		dialog.destroy
	end

end
