require "remastering/remastertool_const"
require "remastering/pluginBase"

class PluginBaseOS < PluginBase

	#=== プラグイン基底クラスのコンストラクタ
	#
	#プラグインの初期化処理を実施する。
	#
	#復帰値:: なし
	#
	def initialize
		super
		@root_dir = ""
		@media_dir = ""
		@package_type = ""
		@os_name = ""
		@os_version = ""
		@path_boot_image = Hash.new
		@path_boot_catalog = Hash.new
		@resolv_conf = "/etc/resolv.conf"
		@can_accel = false
	end

	#=== プラグイン形式の取得
	#
	#プラグインの形式を返却する。OSプラグインでは"OS"を返却する。
	#
	#復帰値:: プラグインタイプ("OS")
	#
	def get_plugin_type
		PLUGIN_TYPE_OS
	end

	#=== リマスタリング対象OS名の取得
	#
	#リマスタリング対象OSのOS名を返却する。
	#
	#復帰値:: リマスタリング対象OSのOS名
	#
	def get_OS_name
		@os_name
	end

	#=== リマスタリング対象OSのバージョン取得
	#
	#リマスタリング対象OSのOSバージョンを返却する。
	#
	#復帰値:: リマスタリング対象OSのOSバージョン
	#
	def get_OS_version
		@os_version
	end

	#=== リマスタリング対象OSの作業用OS上でのパス取得
	#
	#リマスタリング対象OSの作業用OS上でのルートディレクトリの絶対パスを返却する。
	#
	#復帰値:: リマスタリング対象OSの作業用OS上でのルートディレクトリ
	#
	def get_root_dir
		@root_dir
	end

	#=== リマスタリング対象OSのメディア形式格納ディレクトリのパス取得
	#
	#リマスタリング対象OSのメディア形式を格納しているディレクトリの絶対パスを返却する。
	#
	#復帰値:: リマスタリング対象OSのメディア形式格納ディレクトリ
	#
	def get_media_dir
		@media_dir
	end

	#=== リマスタリング対象OSのネイティブパッケージ形式の取得
	#
	#リマスタリング対象OSで使用されるネイティブなパッケージ形式を返却する。
	#
	#復帰値:: リマスタリング対象OSで使用されるネイティブなパッケージ形式
	#
	def get_package_type
		@package_type
	end

	#=== リマスタリング対象OSのプロファイリング準備
	#
	#リマスタリング対象OSをプロファイリングするにあたり、その準備を実装する。
	#
	#復帰値:: BOOL true=正常終了、false=異常終了
	#
	def prepare_profile
		true
	end

	#=== リマスタリング対象OSのプロファイリング
	#
	#リマスタリング対象OSのプロファイリング、および結果の適用を実装する。
	#
	#media_image:: メディアイメージファイル
	#emu_plugin:: プロファイリングに使用するエミュレータプラグインのオブジェクト
	#復帰値:: BOOL true=正常終了、false=異常終了
	#
	def do_profile(media_image, emu_plugin)
		true
	end

	#=== 初期設定が完了しているかのチェック
	#
	#指定された作業用ディレクトリの初期設定が完了しているか否かを返却する。
	#
	#work_dir:: 作業用ディレクトリ
	#復帰値:: BOOL true=正常終了、false=異常終了
	#
	def isInitialized?(work_dir)
		false
	end

	#=== 作業用ディレクトリの設定
	#
	#指定されたディレクトリを作業用ディレクトリとして扱う。
	#isInitialized? メソッドで true を返却したディレクトリが指定される。
	#
	#work_dir:: 作業用ディレクトリ
	#復帰値:: なし
	#
	def use_directory(work_dir)
	end

	#=== ブートイメージファイルの取得
	#
	#ブート可能なメディアを作成する際に使用するブートイメージファイルを返却する。
	#返却するブートイメージファイルは指定されたブートローダに対応するものをメデ
	#ィアディレクトリからの相対パス形式で返却する。
	#
	#boot_loader:: ブートローダ(V1.0では常にisolinuxとなる)
	#復帰値:: ブートイメージファイル。サポートしてないブートローダが指定された
	#場合nilを返却する。
	#
	def get_boot_image(boot_loader)
		@path_boot_image[boot_loader]
	end

	#=== ブートカタログファイルの取得
	#
	#ブート可能なメディアを作成する際に使用するブートカタログファイルを返却する。
	#返却するブートカタログファイルは指定されたブートローダに対応するものをメデ
	#ィアディレクトリからの相対パス形式で返却する。
	#
	#boot_loader:: ブートローダ(V1.0では常にisolinuxとなる)
	#復帰値:: ブートカタログファイル。サポートしてないブートローダが指定された
	#場合nilを返却する。
	#
	def get_boot_catalog(boot_loader)
		@path_boot_catalog[boot_loader]
	end

	#=== ディストリビューション作成時の設定項目チェック
	#
	#ディストリビューション作成時画面でOSイメージを作成する直前に呼び出され、
	#設定項目のチェックを実施する。
	#
	#復帰値:: BOOL true=設定エラーなし、false=設定エラーあり
	#
	def check_for_make_distribution
		true
	end

	#=== resolv.confファイルのパス取得
	#
	#IPアドレス解決のために使用するresolv.confファイルの絶対パスを返却する。
	#
	#復帰値:: resolv.confファイルの絶対パス
	#
	def get_resolvconf_path
		@resolv_conf
	end

	#=== リマスタリング対象OSの起動高速化の可/不可の取得
	#
	#リマスタリング対象OSで起動高速化の適用が可能か否かを返却する。
	#
	#復帰値:: BOOL true=起動高速化適用可能、false=起動高速化適用不可
	#
	def can_accelerate?
		@can_accel
	end

end