require "remastering/remastertool_const"
require "remastering/pluginBase"

class PluginBaseExport < PluginBase

	#=== プラグイン基底クラスのコンストラクタ
	#
	#プラグインの初期化処理を実施する。
	#
	#復帰値:: なし
	#
	def initialize
		super
	end

	#=== プラグイン形式の取得
	#
	#プラグインの形式を返却する。エキスポートプラグインでは"EXPORT"を返却する。
	#
	#復帰値:: プラグインタイプ("EXPORT")
	#
	def get_plugin_type
		PLUGIN_TYPE_EXPORT
	end

	#===リマスタリング手順ファイルのロード
	#
	#パラメタで指定されたファイルからリマスタリング手順を読み込む。
	#
	#fname:: リマスタリング手順ファイル名
	#復帰値:: 正常終了時=XMLドキュメント(REXML::Document)、異常終了時:nil
	#
	def read_procedure(fname)
		nil
	end

	#===リマスタリング手順ファイルの保存
	#
	#パラメタで指定されたXMLドキュメントをファイルに保存する
	#
	#fname:: 保存先リマスタリング手順ファイル
	#doc:: リマスタリング手順XMLドキュメント
	#復帰値:: BOOL  true=保存成功, false=保存失敗
	#
	def write_procedure(fname, doc)
		true
	end

	#===保存ファイルの形式取得
	#
	#プラグインで保存するファイル形式の情報を返却する
	#
	#復帰値:: Array [説明, 拡張子]
	#
	def get_file_type()
		Array.new
	end

end