#!/usr/bin/env ruby
#
# This file is gererated by ruby-glade-create-template 1.1.3.
#
require 'remastering/remastertool_utility'

class PluginBase
  include GetText

	#=== プラグイン基底クラスのコンストラクタ
	#
	#プラグインの初期化処理を実施する。
	#
	#復帰値:: なし
	#
	def initialize
		#initialize instance variables
		@display_name = nil				# plugin name
		@version = nil					# plugin version
		@have_about = true				# about dialog is having
		@have_option = false			# Option dialog is not having
		@copyright = nil				# copyright
		@license = nil					# license
		@modified = false				# modified?
	end

	#=== リマスタリングツールとプラグインの整合性チェック
	#
	#本プラグインがリマスタリングツールのバージョン下で動作可能かチェックする。
	#
	#tool_version:: リマスタリングツールのバージョン
	#復帰値:: BOOL true=動作可能、false=動作不可能
	#
	def start_plugin(tool_version)
		true
	end

	#=== プラグインの終了処理
	#
	#プラグイン固有の終了処理を実装する。基底クラスの終了処理では何もしない。
	#
	#復帰値:: なし
	#
	def end_plugin
	end

	#=== プラグイン名の返却
	#
	#プラグイン名を返却する。
	#
	#復帰値:: プラグイン名
	#
	def get_plugin_name
		@display_name
	end

	#=== プラグインバージョンの返却
	#
	#プラグイン名を返却する。
	#
	#復帰値:: プラグインバージョン
	#
	def get_plugin_version
		@version
	end

	#=== アバウトダイアログ有無の返却
	#
	#プラグインがアバウトダイアログを持っているかを返却する。
	#
	#復帰値:: BOOL true=アバウトダイアログ有り、false=アバウトダイアログ無し
	#
	def have_about?
		@have_about
	end

	#=== アバウトダイアログの表示
	#
	#プラグインのアバウトダイアログを表示する。
	#have_about?メソッドで true を返却した場合のみ呼び出される。
	#
	#復帰値:: なし
	#
	def show_about
		RTUtility.show_about(@display_name + " plugin", @version, @copyright, @license)
	end

	#=== オプション設定ダイアログ有無の返却
	#
	#プラグインがオプション設定ダイアログを持っているかを返却する。
	#
	#復帰値:: BOOL true=オプション設定ダイアログ有り、false=オプション設定ダイアログ無し
	#
	def have_option?
		@have_option
	end

	#=== オプション設定ダイアログの表示
	#
	#プラグインのオプション設定ダイアログを表示する。
	#have_option?メソッドで true を返却した場合のみ呼び出される。
	#
	#復帰値:: なし
	#
	def show_option
	end

	#=== リマスタリング手順のロード
	#
	#XML形式のリマスタリング手順から自プラグインに対する情報を取得する。
	#
	#root:: リマスタリング手順ファイル名のルート要素(REXML::Element)
	#復帰値:: なし
	#
	def load_xml(root)
	end

	#=== リマスタリング手順の作成
	#
	#自プラグインに対するリマスタリング手順情報をXML化して返却する。
	#
	#localize:: ローカライゼーション(0:非ローカライゼーション化XMLを作成, 1:ローカライゼーション化XMLを作成)
	#復帰値:: REXML::Element 自プラグインのリマスタリング手順。返却したXML要素はルート要素
	#の子要素としてXML化される。
	#自プラグインでXML化する手順がない場合、nilを返却する。
	#
	def make_xml(localize = 0)
		nil
	end

	#=== リマスタリング手順の変更確認
	#
	#リマスタリング手順に変更があったかを返却する。
	#新規にリマスタリングを開始した場合、起動時からの変更の有無を返却する。
	#リマスタリング手順ファイルを読み込み、続きから作業用を開始した場合は手順
	#読み込み後かの変更の有無を返却する。
	#
	#復帰値:: BOOL true=変更あり、false=変更なし。
	#
	def isModified?
		@modified
	end

	#=== リマスタリング手順の変更確定
	#
	#リマスタリング手順に変更を確定する。
	#本メソッドはリマスタリング手順保存成功時に呼び出される。
	#各プラグインは現在の設定状態はリマスタリング手順変更なしの状態に設定する。
	#次回 isModified? メソッドが呼び出された場合、本メソッドの呼出時からの変更
	#を返却する。
	#
	#復帰値:: なし。
	#
	def fix_procedure
		@modified = false
	end

	#=== リマスタリング環境の初期化
	#
	#リマスタリング作業用を新規に開始するために環境を初期状態に戻す。
	#
	#復帰値:: なし
	#
	def init_environ
	end

	#=== リマスタリング手順一覧リストの取得
	#
	#作業手順編集画面で表示する手順の一覧を返却する。。
	#
	#復帰値:: 手順一覧リスト(手順がない場合はnil)
	#         Array1[Array2, Array2, ...]
	#          Array2[0] = true(実行済)/false(未実行)
	#          Array2[1] = 機能名
	#          Array2[2] = 機能内容
	#          Array2[3] = 操作対象
	#
	def get_procedure_list
		nil
	end

	#===手順リスト一覧の変更反映
	#
	#リマスタリング手順の一覧を現在の手順に反映する。
	#手順一覧は操作手順編集画面での編集結果が通知される。
	#
	#list:: 手順一覧リスト
	#         [ [手順1], [手順2],...]
	#          手順n = [実行済み(true) or 未実行(false) , 機能名 , 操作内容 , 対象 ]
	#復帰値:: なし
	#
	def set_procedure_list(list)
	end

	#=== 最新情報への更新
	#
	#画面の表示情報を最新状態に更新する。
	#
	#復帰値:: なし
	#
	def refresh
	end

	#=== リマスタリング環境のインポート
	#
	#引数のdirで示すディレクトリ内の資産を現在のリマスタリング環境に適用する。
	#
	#dir:: インポート資源ディレクトリ
	#復帰値:: BOOL true=正常終了、false=異常終了
	#
	def import(dir)
		true
	end

	#=== リマスタリング環境のエクスポート
	#
	#引数のdirで示すディレクトリにの現在のリマスタリング環境資産を格納する。
	#
	#dir:: エクスポート先ディレクトリ
	#復帰値:: BOOL true=正常終了、false=異常終了
	#
	def export(dir)
		true
	end

end

