#!/usr/bin/env ruby
#
# This file is gererated by ruby-glade-create-template 1.1.3.
#

require 'remastering/remastertool_utility'
require 'pluginfiletestGlade'

require "gettext"

class Filetest < PluginfiletestGlade

  include GetText

  attr :glade

	PROG_PATH = "pluginfiletest.glade"
	PROG_NAME = "remastertool_plugin_filetest"

	bindtextdomain(PROG_NAME, nil, nil, "UTF-8")
  
	DISPLAY_NAME	= _("File test")	# display name
	VERSION			= "V1.0"			# plugin version 

	HEADER_LIST = [_("File name"), _("Type"), _("test content"), _("Result")]

	MSG_WARN_NO_CMD = _("Please input the file name")

	# XMLプラグイン向けの XML要素
	XML_ROOT = ["PluginInfo", _("Plugin_information")]
	XML_ROOT_ATTR = ["name", _("name")]
	XML_PLUGIN_NAME = ["File_Test", _("File_Test")]
	XML_TESTSET = ["test", _("Test_set")]
	XML_FILE = ["file", _("file")]
	XML_FILE_XPATH = XML_TESTSET[0] + "/" + XML_FILE[0]
	XML_ATTR_TYPE = ["Type", _("file_type")]
	XML_ATTR_CHECK = ["check", _("check_content")]
	XML_ATTR_RESULT = ["result", _("result")]

	# コマンド実行用文字列
	CMD_TEST = "test -f %s"

	# コマンドの実行結果表示
	LIST_EXIST = _("exist")
	LIST_NOEXIST = _("not exist")
	LIST_FILE = _("file")
	LIST_DIRECTORY = _("directory")
	CMD_RESULT_OK = "OK"
	CMD_RESULT_NG = "NG"
	CHECK_TO_XML = { _("exist") => "exist", _("not exist") => "not exist" }
	CHECK_FROM_XML = CHECK_TO_XML.invert
	TYPE_TO_XML = { _("file") => "file", _("directory") => "directory" }
	TYPE_FROM_XML = TYPE_TO_XML.invert
	XML_ATTR_TEST = ["effective", _("effective")]


	#=== プラグインのコンストラクタ
	#
	#プラグインの初期化処理を実施する。
	#
	#dir:: プラグイン格納ディレクトリ
	#復帰値:: なし
	#
	def initialize(dir)
		super(File.join(dir, PROG_PATH), nil, PROG_NAME)	
		@display_name = DISPLAY_NAME
		@version = VERSION
		@have_about = true			# about dialog is having
		@have_option = false		# Option dialog is not having
		@copyright = SSL_COPYRIGHT
		@license = SSL_LICENSE

		@treeFile = nil
		@tool_min_vl = "V1.0"

		@modified = false

		create_list			# テスト項目一覧リストの作成

		init_environ		# 環境の初期化

	end

	#=== リマスタリングツールとプラグインの整合性チェック
	#
	#本プラグインがリマスタリングツールのバージョン下で動作可能かチェックする。
	#
	#tool_version:: リマスタリングツールのバージョン
	#復帰値:: BOOL true=動作可能、false=動作不可能
	#
	def start_plugin(tool_version)
		return tool_version >= @tool_min_vl
	end

	#=== 自動テスト設定/実行画面のタブ内に表示するWidgetの返却
	#
	#自動テスト設定/実行画面で「ファイルテスト」タブが選択されたときに表示する
	#Widgetを返却する。
	#
	#復帰値:: 自動テスト設定/実行画面のタブ内に表示するWidget
	#
	def get_test_set_widget
		# ダミーウインドウと切り離されていない場合は切り離す
		@glade["window1"].remove(@glade["hbox_main"]) if @glade["hbox_main"].parent == @glade["window1"]
		@glade["hbox_main"]
	end

	#=== テスト設定ビューの表示/非表示の切り替え
	#
	#自動テスト設定/実行画面向けにテスト項目設定ビューの表示、非表示の切り替えを行う。
	#
	#mode:: BOOL true=テスト項目設定ビューを表示する、false=表示しない
	#復帰値:: なし
	#
	def show_setting_view(mode)
		if mode
			[@glade["vbox1"], @glade["vseparator1"], @glade["hbuttonbox2"]].each{|widget| widget.show }
		else
			[@glade["vbox1"], @glade["vseparator1"], @glade["hbuttonbox2"]].each{|widget| widget.hide }
		end
	end

	#===リマスタリング手順のロード
	#
	#XML形式のリマスタリング手順から画面に表示する要素を取り出し、対応するエントリに設定する。
	#
	#root:: リマスタリング手順 XMLドキュメント
	#復帰値:: なし
	#
	def load_xml(root)
		# 環境の初期化
		init_environ

		# 自プラグインのXMLドキュメント要素を探す
		elmTop = nil
		root.get_elements(XML_ROOT[0]).each{|elm|
			if elm.attributes[XML_ROOT_ATTR[0]] == XML_PLUGIN_NAME[0]
				elmTop = elm
				break
			end
		}
		return unless elmTop

		# XMLドキュメントから 畏怖テスト項目を抽出してテスト項目リストに設定する
		elmTop.get_elements(XML_FILE_XPATH).each{|elm|
			file = elm.text
			next unless file
			type = elm.attributes.get_attribute(XML_ATTR_TYPE[0]) ?
				elm.attributes.get_attribute(XML_ATTR_TYPE[0]).value : nil
			check =  elm.attributes.get_attribute(XML_ATTR_CHECK[0]) ?
				elm.attributes.get_attribute(XML_ATTR_CHECK[0]).value : nil
			result =  elm.attributes.get_attribute(XML_ATTR_RESULT[0]) ?
				elm.attributes.get_attribute(XML_ATTR_RESULT[0]).value : nil
			doing = elm.attributes.get_attribute(XML_ATTR_TEST[0]) ?
				elm.attributes.get_attribute(XML_ATTR_TEST[0]).value : nil
			# リストに追加
			RTUtility.add_list(@glade["treeview_right"],
					[ file, TYPE_FROM_XML[type], CHECK_FROM_XML[check], result, doing] )
		}
		# 現在の状態を「手順変更なし」に設定する
		fix_procedure
	end

	#===リマスタリング手順のXML化
	#
	#リマスタリング手順をXML形式の要素にして返却する。
	#
	#localize:: ローカライゼーション(0:非ローカライゼーション化XMLを作成, 1:ローカライゼーション化XMLを作成)
	#復帰値:: XML要素(ファイルテストプラグイン)
	#
	def make_xml(localize = 0)
		elmRoot = REXML::Element.new(XML_ROOT[localize])
		elmRoot.add_attribute(XML_ROOT_ATTR[localize], XML_PLUGIN_NAME[localize])
		elm_child = REXML::Element.new(XML_TESTSET[localize], elmRoot)

		if (iter = @glade["treeview_right"].model.iter_first)
			begin
				elm_grandchild = REXML::Element.new(XML_FILE[localize], elm_child)
				elm_grandchild.text = iter[0]
				if localize == 0
					elm_grandchild.add_attribute(XML_ATTR_TYPE[localize], TYPE_TO_XML[iter[1]])
					elm_grandchild.add_attribute(XML_ATTR_CHECK[localize], CHECK_TO_XML[iter[2]])
				else
					elm_grandchild.add_attribute(XML_ATTR_TYPE[localize], iter[1])
					elm_grandchild.add_attribute(XML_ATTR_CHECK[localize], iter[2])
				end
				elm_grandchild.add_attribute(XML_ATTR_RESULT[localize], iter[3])
				elm_grandchild.add_attribute(XML_ATTR_TEST[localize], iter[4])
			end while iter.next!
		end
		elmRoot
	end

	#===リマスタリング環境の初期化
	#
	#リマスタリング環境を初期状態に設定する。
	#
	#復帰値:: なし
	#
	def init_environ
		@glade["treeview_right"].model.clear
		@glade["entry_main_file"].text = ""
		@glade["radiobutton_main_file"].clicked
	end

	#===テストの実行
	#
	#設定されたテスト項目にしたがってテストを実施する。
	#
	#復帰値:: なし
	#
	def exec_test
		return unless (iter = @glade["treeview_right"].model.iter_first)
		begin
			unless iter[4] == true.to_s
				expect = (iter[2] == LIST_EXIST)
				path = File.join(RTUtility.get_os_plugin.get_root_dir, iter[0])
				if iter[1] == LIST_DIRECTORY
					ret = FileTest.directory?(path)
				else
					ret = FileTest.file?(path)
				end
				if ret == expect
					# テストOKの場合、OKをリストに表示し、実行済とする。
					iter[3] = CMD_RESULT_OK
					iter[4] = true.to_s
				else
					# テストNGの場合、NGをリストに表示する（実行済としない)。
					iter[3] = CMD_RESULT_NG
				end
				@modified = true
			end
		end while iter.next!
	end

	#===手順リスト一覧の取得
	#
	#リマスタリング手順の一覧を返却する。
	#返却した手順一覧は操作手順編集画面の表示に使用される。
	#
	#復帰値:: 手順一覧リスト
	#         [ [手順1], [手順2],...]
	#          手順n = [実行済み(true) or 未実行(false) , 機能名 , 操作内容 , 対象 ]
	#
	def get_procedure_list
		ary = Array.new
		iter = @glade["treeview_right"].model.iter_first
		if iter
			begin
				ary.push( [ iter[4] == true.to_s, @display_name, iter[1] + iter[2], iter[0] ] )
			end while iter.next!
		end
		ary
	end

	#===手順リスト一覧の変更反映
	#
	#リマスタリング手順の一覧を現在の手順に反映する。
	#手順一覧は操作手順編集画面での編集結果が通知される。
	#
	#list:: 手順一覧リスト
	#         [ [手順1], [手順2],...]
	#          手順n = [実行済み(true) or 未実行(false) , 機能名 , 操作内容 , 対象 ]
	#復帰値:: なし
	#
	def set_procedure_list(list)
		i = 0
		iter = @glade["treeview_right"].model.iter_first
		if iter
			begin
				iter[4] = list[i][0].to_s
				i+= 1
			end while iter.next!
		end
	end

	#=== 最新情報への更新
	#
	#画面の表示情報を最新状態に更新する。
	#
	#復帰値:: なし
	#
	def refresh
		@treeFile.refresh if @treeFile
	end

private

	#=== テスト項目一覧リストの作成
	#
	#テスト項目一覧リストのヘッダ部を作成する。
	#
	#復帰値:: なし
	#
	def create_list
		# テスト内容リストのヘッダを作成する
		HEADER_LIST.each_with_index { |name, i|
			column = Gtk::TreeViewColumn.new(name, Gtk::CellRendererText.new, :text => i)
			column.resizable = true
			@glade["treeview_right"].append_column(column)
		}
		# unvisible column
		column = Gtk::TreeViewColumn.new("unvisible", Gtk::CellRendererText.new)
		column.visible = false
		@glade["treeview_right"].append_column(column)

		model = Gtk::ListStore.new(String, String, String, String, String)
		@glade["treeview_right"].set_model(model)
		@glade["treeview_right"].selection.mode = Gtk::SELECTION_MULTIPLE
	end

	#=== テスト設定/実行画面表示時のイベントハンドラ
	#
	#リマスタリング対象OSツリーを生成する(未生成の場合のみ)。
	#
	#widget:: テスト設定/実行画面のWidget
	#復帰値:: なし
	#
	def on_hbox_main_map(widget)
		unless @treeFile
			@treeFile = RTFileTreeView.new(true)
			@glade["scrolledwindow_left"].add(@treeFile)

			# ツリー選択変更時のシグナルを登録する
			@treeFile.selection.signal_connect("changed"){ |widget|
				path = @treeFile.get_selected_file
				if path
					@glade["entry_main_file"].text = path
					if FileTest.directory?(File.join(RTUtility.get_os_plugin.get_root_dir, path))
						@glade["radiobutton_main_directory"].clicked
					else
						@glade["radiobutton_main_file"].clicked
					end
				end
			}
		end
	end

	#=== [削除]ボタンクリック持のイベントハンドラ
	#
	#[削除]ボタンクリック時に選択中のテスト項目をリストから削除する。
	#
	#widget:: 削除ボタンのWidget
	#復帰値:: なし
	#
	def on_button_main_delete_clicked(widget)
		# ユーティリティクラスを使用してリストで選択中の項目を削除する
		@modified = true if RTUtility.del_list(@glade["treeview_right"])
	end

	#=== [存在チェック]/[不在チェック]ボタンクリック持のイベントハンドラ
	#
	#[存在チェック]/[不在チェック]ボタンクリック時に左ペインの内容をリストに追加する。
	#
	#widget:: [存在チェック]/[不在チェック]ボタンのWidget
	#復帰値:: なし
	#
	def on_button_main_add_clicked(widget)
		if @glade["entry_main_file"].text.strip.empty?
			dlg = Gtk::MessageDialog.new(RTUtility.mainWindow, Gtk::Dialog::MODAL,
										 Gtk::MessageDialog::WARNING,
										 Gtk::MessageDialog::BUTTONS_OK, MSG_WARN_NO_CMD)
			dlg.run
			dlg.destroy
			return
		end

		# 既に同じテスト項目がリスト中に存在するかチェックする
		found = false
		iter = @glade["treeview_right"].model.iter_first
		if iter
			begin
				if iter[0] == @glade["entry_main_file"].text.strip &&
				   iter[1] == (@glade["radiobutton_main_file"].active?  ? LIST_FILE : LIST_DIRECTORY) &&
				   iter[2] == (widget == @glade["button_main_exist"] ? LIST_EXIST : LIST_NOEXIST)
					found = true
					break
				end
			end while iter.next!
		end

		# 既存のリストに存在しない(iterがnil)の場合だけリストに登録する
		unless found
			iter = @glade["treeview_right"].model.append
			iter[0] = @glade["entry_main_file"].text.strip
			iter[1] = @glade["radiobutton_main_file"].active? ? LIST_FILE : LIST_DIRECTORY
			iter[2] = widget == @glade["button_main_exist"] ? LIST_EXIST : LIST_NOEXIST
			iter[3] = ""
			iter[4] = false.to_s
			@modified = true
		end

		# 追加したデータをエントリ領域から削除する
		@glade["entry_main_file"].text = ""

	end

end
