/*
 *
 * ExportSrc
 *
 * Copyright (c) 2002, matsumo
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the author may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * -----------------------------------------------------------------------------
 *
 * () ȉ͓{̕₷l̂߂ɁAp̒쌠\
 * ͂łBȒ쌠́Ap̌{ɏ]B
 *
 * ExportSrc
 *
 * Copyright (c) 2002, matsumo
 * All rights reserved.
 *
 * ύX̗Lɂ炸A\[XуoCi`̍ĔzzїṕA
 * ȉ̏𖞂Ă΁AB
 *
 * 1. \[XER[h̍ĔzźAL̒쌠\ȀځAсA
 * ȉ̖ƐӎۑȂ΂ȂȂB
 *
 * 2. oCi`̍ĔzźAL̒쌠\ȀځAсA
 * ̖ƐӎA̔zzɕtA邢͂̑̎̂
 * ɖLȂ΂ȂȂB
 *
 * 3. Oēʂɋ𓾂ȂÃ\tgEFAhi
 * ̔î߂ɁA̒쌠Җ𗘗pĂ͂ȂȂB
 *
 * ̃\tgEFÁû܂܂̌`Łv񋟂AI邢͌O̕ۏ
 * ́AppѓړIւ̓Kɑ΂錾O̕ۏ؂܂݁A܂
 * Ɍ炸A݂ȂBƂȉ̂悤ȑQ̉\Ă
 * ƂĂAǂ̂悤Ȍ`ɂ낱̃\tgEFA̗p甭
 * āA̒쌠҂́A(֐iT[rX̒B; pAf[^A
 * 邢͗v̑; 邢͉cƂ̒f܂ށA܂炾Ɍ炸)
 * ړIɁAԐړIɁARɁAʂɁAA邢́AKRIɐĂ܂
 * Qɑ΂ӔC͂ȂAȂӔC_ł_̗LɌW炸
 * ȐӔC͂ȂA܂(ߎ邢͂̑܂)s@sׂɑ΂ĂӔC͂
 * B
 *
 */

/***************************************************************************
	NX}\[X𐶐DynamicDrawpvOC
	  ExportSrc.dll
	$Id: ExtractInfo.cpp,v 1.13 2002/11/30 10:55:48 matsumo Exp $
***************************************************************************/
/*!
	@file		ExtractInfo.cpp
	@brief		NX}ClassInfo֕Kvȏ̒osNX
	@author		matsumo
	@date		2002/5/28 VK쐬
	$Revision: 1.13 $
 */

#include "stdafx.h"
#include <tchar.h>		// For _TCHAR.
#include "Module.h"		// For FMpgGetModule().
#include "ExtractInfo.h"
#include "VersionInfo.h"

/*****************************************************************************/
/*!
	@brief	RXgN^
 */
/*****************************************************************************/
ExtractInfo::ExtractInfo()
{
	//ݓ擾āARgp̕쐬
	SYSTEMTIME st;
	GetLocalTime(&st);
	
	wchar_t t[32];
	swprintf(t, L"%4d/%2d/%2d", st.wYear, st.wMonth, st.wDay);
	date = t;
}

/////////////////////////////////////////////////////////////////////////////////
//OĂ΂郁\bh

/*****************************************************************************/
/*!
	@brief	\[Xo͂̃j[IɌĂ΂
			tH_IɂׂẴV[gAimF
	@param	path		ۑ̃pX
	@param	all			o͑Ώ(TRUE=S, FALSE=Î̂)
	@return				G[R[h
	@todo				INX݂̂̏sSł
 */
/*****************************************************************************/
ES_Err::code ExtractInfo::exec(wstring &path, BOOL all)
{
	//UMLev[ggpĂ邩ǂmF
	const FCEnvExp* pEnv = (const FCEnvExp*)FMpgGetMolipMain()->GetEnv();
	const FDChipGroupIDVector& cgidv = pEnv->GetFreqChipGroupVector();
	if(cgidv.size() != 1) return(ES_Err::BAD_TEMPLATE);	//ev[gI or Ⴄev[ggp
	wstring cgidname = pEnv->cgid2name(cgidv[0]);
	if(cgidname.compare(L"UMLNX}p") != 0) return(ES_Err::BAD_TEMPLATE);	//Ⴄev[ggp

	//̒o
	const FCSheetManagerExp* pSheetMgr = (const FCSheetManagerExp*)FMpgGetMolipMain()->GetDocument()->GetSheetManager();
	FDSheetIDVector::const_iterator iSt;
	ObjBaseVector vObj;

	if(all){
		//SẴNX
		for(iSt = pSheetMgr->GetFreqSheetVector().begin();
			iSt != pSheetMgr->GetFreqSheetVector().end(); iSt++){

			FCLayerManagerExp* pLayerMgr = (FCLayerManagerExp*)pSheetMgr->GetSheet(*iSt);
			pLayerMgr->GetZOrder(vObj);
			ExtractObjects(vObj);
		}
	}else{
		//INX̂
		vObj = FMpgGetMolipMain()->GetView()->SelectObjVector();
		ExtractObjects(vObj);
	}

	//t@CɏoNX邩`FbN
	if(ciMap.empty()) return(ES_Err::CLASS_NOT_FOUND);

	//eClassInfot@Cɏo
	return(write(path));
}

/////////////////////////////////////////////////////////////////////////////////
//Ŏgp郁\bh

/*****************************************************************************/
/*!
	@brief	NẌʒu<mdrwpos `>^O𐶐
	@param	pObj		^O쐬IuWFNg
	@return				ꂽ^O
 */
/*****************************************************************************/
wstring ExtractInfo::GetTag(const FCObjectExp* pObj)
{
	FCDocumentExp* pDoc = FMpgGetMolipMain()->GetDocument();
//	FCViewExp* pView = FMpgGetMolipMain()->GetView();
//	DBLRect mmrt;

	// r[SWZoB
//	pView->GetClientRectMM(mmrt);
//	DBLPoint mmpt = mmrt.CenterPoint();
	DBLPoint mmptF, mmptB;
	pObj->GetEdgePoint(mmptF, mmptB);
	CString strCenterX;
	CString strCenterY;
	// SWlAŕ쐬B
	strCenterX.Format(_T("%d"), (LONG)((mmptF.x+mmptB.x)/2));
	strCenterY.Format(_T("%d"), (LONG)((mmptF.y+mmptB.y)/2));
	CString strPos;
	strPos.Format(_T("<mdrwpos file=\"%s\" sheet=\"%ld\" cposx=\"%s\" cposy=\"%s\"/>"),
	    pDoc->GetPathName(), pDoc->GetCurrentSheetId(),
	    strCenterX, strCenterY);

	wstring r = TStrToWStr(strPos);
	return(r);
}

/*****************************************************************************/
/*!
	@brief	sN`[IDƐ̎ނA[U[ID𐄒肷
			(ΉĂ̂TVĉATV̂)
	@param	pObj		^O쐬IuWFNg
	@return				[U[ID
 */
/*****************************************************************************/
DWORD ExtractInfo::GetObjID(const FCObjectExp *pObj)
{
	DWORD ArrowID = 0, LineStyle = 0;

	//sN`[ID
	if(pObj->GetArrowBType() == FDUG_ARW_TYPE_PICT){
		FCObjectExp* pObjArwB = (FCObjectExp*)FMpgGetMolipMain()->GetEnv()->GetPictArrowRec(pObj->GetPictArrowB())->m_objpPictArrowMaster1;
		ArrowID = pObjArwB->GetObjUserUlong();	//id
	}
/*	if(pObj->GetArrowFType() == FDUG_ARW_TYPE_PICT){
		FCObjectExp* pObjArwF = (FCObjectExp*)FMpgGetMolipMain()->GetEnv()->GetPictArrowRec(pObj->GetPictArrowF())->m_objpPictArrowMaster1;
		ArrowID = pObjArwF->GetObjUserUlong();	//Oid
	}*/

	//̎
	const FCPenStyleRec* pStyleRec = FMpgGetMolipMain()->GetEnv()->GetPenStyleRec(pObj->GetStdPenStyle());
	if (pStyleRec->m_mmfaData[0] == 0 && pStyleRec->m_mmfaData[1] == 0 &&
		pStyleRec->m_mmfaData[2] == 0 && pStyleRec->m_mmfaData[3] == 0){
		LineStyle = 1;		//
	}else{
		LineStyle = 2;		//j
	}

	//sN`
	//1000 UML arrow
	//1001 UML generarization
	//1002 UML aggregation
	//1003 UML aggregation (painted)
	//1004 UML point

	//̎ނƃsN`[ID画
	if(ArrowID == 1001 && LineStyle == 1){
		return(9);	//TVĉ
	}
	if(ArrowID == 1001 && LineStyle == 2){
		return(10);	//TV
	}

	return(0);
}

/*****************************************************************************/
/*!
	@brief	t@C݂邩ǂ`FbN
	@param	fn			`FbNpX+t@C
	@retval	TRUE		݂
	@retval	FALSE		݂Ȃ
 */
/*****************************************************************************/
BOOL ExtractInfo::checkExistFile(const wstring &fn)
{
	HANDLE hFind;
	WIN32_FIND_DATAW fd;
	if((hFind=::FindFirstFileW(fn.c_str(), &fd)) != INVALID_HANDLE_VALUE){
		::FindClose(hFind);
		return(TRUE);	//łɑ݂
	}
	return(FALSE);		//݂Ȃ
}

/*****************************************************************************/
/*!
	@brief	t@C㏑̏
	@param	fn			t@CۑpX+t@C
	@retval	TRUE		I
	@retval	FALSE		ُI
 */
/*****************************************************************************/
BOOL ExtractInfo::onOverWrite(const wstring &fn)
{
/*
	//㏑mF
	wstring m = fn.substr(fn.rfind(L'\\')+1);
	m += L"͊ɑ݂܂\n㏑܂?";
	if(::MessageBoxW(FMpgGetMolipMain()->GetMainWindow(), m.c_str(), L"ExportSrc", MB_YESNO | MB_ICONINFORMATION | MB_TOPMOST) != IDYES){
		//[]
		return(FALSE);;
	}
	return(TRUE);
*/
	//̃t@C*.bakɃl[(ł*.bakꍇ͍폜Ă)
	wstring old = fn;
	old += L".bak";

	if(checkExistFile(old.c_str())){
		//delete backup file
		if(!DeleteFileW(old.c_str())) return(FALSE);
	}
	//rename file
	if(!MoveFileW(fn.c_str(), old.c_str())) return(FALSE);

	return(TRUE);
}

/*****************************************************************************/
/*!
	@brief	ObjBaseVector̃IvWFNgSĂ𒊏o
	@param	vObj		oIuWFNgvector
	@retval	TRUE		
	@retval	FALSE		s
 */
/*****************************************************************************/
BOOL ExtractInfo::ExtractObjects(ObjBaseVector& vObj)
{
	ObjBaseVector::iterator iObj;

	//NX̒o
	for(iObj = vObj.begin(); iObj != vObj.end(); iObj++){
		ExtractChipMaster(*iObj);
	}

	//NXԂ̊֌W̒o
	for(iObj = vObj.begin(); iObj != vObj.end(); iObj++){
		//p𒊏o
		ExtractArrow(*iObj);
	}

	return(TRUE);
}

/////////////////////////////////////////////////////////////////////////////////
//pŎgp郁\bh

/*****************************************************************************/
/*!
	@brief	ChipMaster̃eLXgi̕𒊏o
	@param	pObj		oIuWFNg
	@retval	TRUE		
	@retval	FALSE		s
 */
/*****************************************************************************/
BOOL ExtractInfo::ExtractChipMaster(FCObjectExp* pObj)
{
	ClassInfo ci;
	FCObjBase **objBaseArray = pObj->GetMemberArray();
	DWORD cid;

//----test start
//x = pObj->GetObjID();
//----test end

	//exportΏۂ̕iǂmF
	if (pObj->Type() != FDOJ_CHIP_MASTER){
		return(FALSE);
	}
	// 2 SZNX
	// 3 SZۃNX
	// 4 SZC^[tFCXipj
	cid = pObj->GetObjUserUlong();
	if(cid != 2 && cid != 3 && cid != 4){
		return(FALSE);
	}

	//o
	for(int i = 0; i < pObj->GetMemberSize(); i++){
		const FCObjectExp* pObj_ = (const FCObjectExp*)objBaseArray[i];
		if(pObj_->GetRichText() != NULL){
			FCRichTextExp* pRT= (FCRichTextExp*)pObj_->GetRichText();
			wstring txt;

			switch(i){
			case 0:	//class name
				pRT->GetText(txt);
				ci.header.push_back(GetTag(pObj_));
				ci.setName(txt);
				break;
			case 1:	//property name
				if(cid == 4){
					//interface͑Ȃ
					ci.setOperation(pRT);
				}else{
					ci.setAttribute(pRT);
				}
				break;
			case 2:	//method name
				ci.setOperation(pRT);
				break;
			default:
				break;
			}
		}
	}
	ciMap.insert(ClassInfoMap_pair(pObj->GetObjID(), ci));
	return(TRUE);
}

/*****************************************************************************/
/*!
	@brief	̊֌W𒊏o
	@param	pObj		oIuWFNg
	@retval	TRUE		
	@retval	FALSE		s
 */
/*****************************************************************************/
BOOL ExtractInfo::ExtractArrow(FCObjectExp* pObj)
{
	//Ώۂ̕iǂmF
	if(pObj->Type() != FDOJ_POLY){
		return(FALSE);
	}
	// 9 TVĉ
	//10 TV
	DWORD cid = GetObjID(pObj);
	if(cid != 9 && cid != 10){
		return(FALSE);
	}

	//ON敔iid擾
	DWORD ObjIDF = 0, ObjIDT = 0;
	FCLinkRecPVector vAffected;
	FCLinkManagerExp* pLinkMgr = (FCLinkManagerExp*)FMpgGetMolipMain()->GetDocument()->LinkManager();
	pLinkMgr->GetAffectedByTo(vAffected,
								FCMolipRec(pObj->GetObjID(), 0));
	if(!vAffected.empty() && vAffected.size() == 1){
		ObjIDF = vAffected[0]->m_mlpFrom.dwObjID;
	}
	vAffected.clear();

	//ナN敔iid擾
	pLinkMgr->GetAffectedByTo(vAffected,
							FCMolipRec(pObj->GetObjID(),
									FCObjPoly::JointIDtoMolipID(pObj->GetJointSize() - 1)));
	if(!vAffected.empty() && vAffected.size() == 1){
		ObjIDT = vAffected[0]->m_mlpFrom.dwObjID;
	}

	if(ObjIDF == 0 || ObjIDT == 0){
		//ON敔iidナN敔iidݒ肳ĂȂ
		return(FALSE);
	}

	//OÑNXɌナÑNX
	ClassInfoMap::iterator cIterF = ciMap.find(ObjIDF);
	ClassInfoMap::iterator cIterT = ciMap.find(ObjIDT);
	if(cIterF == ciMap.end() || cIterT == ciMap.end()){
		//YNXȂ
		return(FALSE);
	}
	switch(cid){
	// 9 TVĉ
	case 9:
		(*cIterF).second.generalization.push_back((*cIterT).first);	//p
		break;
	//10 TV
	case 10:
		(*cIterF).second.realization.push_back((*cIterT).first);	//interface
		break;
	// 5 TV֘Aij
	// 6 TV֘Aij
	// 7 TB֘AiȐj
	// 8 TV֘Ai_j
	//11 TVˑ
	//12 TVW
	//13 TVW
	default:
		return(FALSE);	//ΏۊO̖
	}

	return(TRUE);
}

/*****************************************************************************/
/*!
	@brief	\[X𐶐ăt@Cɏ
			(fnbase+NX+gq)
	@param	fnbase		t@CۑpX
	@return				G[R[h
 */
/*****************************************************************************/
ES_Err::code ExtractInfo::write(const wstring &fnbase)
{
	ES_Err::code ret = ES_Err::SUCCESS;
	VersionInfo vi;

	//eClassInfot@Cɏo
	ClassInfoMap::iterator ciIter;
	for(ciIter = ciMap.begin(); ciIter != ciMap.end(); ciIter++){
		//t@C𐶐(NX+gq)
		wstring fn;
		fn = (*ciIter).second.name.name;
		fn += GetFileExt();

		//\[Xwb_ɋʂŏo͂
		(*ciIter).second.header.push_back(L"");
		(*ciIter).second.header.push_back(fn);
		wstring t = L" (generated by ";
		t += vi.getProductName();
		t += L" ";
		t += vi.getProductVersion();
		t += L")";
		(*ciIter).second.header.push_back(t);
		(*ciIter).second.header.push_back(L"");

		//\[X𐶐
		if(!makeSource((*ciIter).second)){
			ret = ES_Err::SOURCEGENERATION_FAILED;
			continue;		//Ɏsꍇ͏݂XLbv
		}

		//tpX+t@C
		wstring filename = fnbase + fn;

		//㏑`FbNƊmF
		if(checkExistFile(filename)){
			if(!onOverWrite(filename)){
				ret = ES_Err::OVERWRITE_ABORTED;
				continue;	//㏑LZꍇ͏݂XLbv
			}
		}

		//t@Cɏ
		ES_Err::code cd = (*ciIter).second.write(filename);
		if(cd != ES_Err::SUCCESS) return(cd);	//݂Ɏsꍇ͑A
	}
	return(ret);
}

/*****************************************************************************/
/*!
	@brief	Object IDɑΉNXԂ
	@param	ObjID		Object ID
	@retval	NULLȊO	Object IDɑΉNX
	@retval	NULL		ΉNX
 */
/*****************************************************************************/
wstring ExtractInfo::GetClassName(DWORD ObjID)
{
	ClassInfoMap::iterator cIter = ciMap.find(ObjID);
	if(cIter == ciMap.end()){
		//YNXȂ
		return(NULL);
	}
	return((*cIter).second.name.name);
}

/*****************************************************************************/
/*!
	@brief	Object ID̃NXɎw肳ꂽ\bh݂邩ǂׂ
	@param	ObjID		Object ID
	@param	method		\bh
	@retval	TRUE		݂
	@retval	FALSE		݂Ȃ
 */
/*****************************************************************************/
BOOL ExtractInfo::checkExistMethod(DWORD ObjID, const wstring &method)
{
	ClassInfoMap::iterator cIter = ciMap.find(ObjID);
	if(cIter == ciMap.end()){
		//YNXȂ
		return(FALSE);
	}
	ClassInfo &ci = (*cIter).second;
	for(int i=0; i<ci.operation.size(); i++){
		if(ci.operation[i].name.compare(method) == 0 && ci.operation[i].bAbstract){	//*Ƃ肠abstract`FbN
			//
			return(TRUE);
		}
	}
	return(FALSE);
}

/////

/*!
	@brief	t@C̐擪pDoxygenRg𐶐
	@param	filename	t@C̖O
	@param	ret			DoxygenRgi[vector
 */
void ExtractInfo::MakeFileComment(wstring &filename, vector<wstring> &ret)
{
	wstring t;
	t = L"@file\t\t" + filename + L"\n";
	ret.push_back(t);
	t = L"@brief\t\tt@C̊Tv\n";
	ret.push_back(t);
	t = L"@author\t\tȂ̖O\n";
	ret.push_back(t);
	t = L"@date\t\t";
	t += date;
	t += L" VK쐬\n";
	ret.push_back(t);
}

/*!
	@brief	NXpDoxygenRg𐶐
	@param	ci			NX̏
	@param	ret			DoxygenRgi[vector
 */
void ExtractInfo::MakeClassComment(ClassInfo &ci, vector<wstring> &ret)
{
	wstring t = L"@brief NX̐\n";
	ret.push_back(t);
}

/*!
	@brief	\bhpDoxygenRg𐶐
	@param	op			\bh̏
	@param	ret			DoxygenRgi[vector
	@todo	param̕ϐƐ̊Ԃ̃^uȂ悤ɒ
 */
void ExtractInfo::MakeMethodComment(ClassInfo::Operation &op, vector<wstring> &ret)
{
	wstring t;
	t = L"@brief\t\t\bh̊Tv\n";
	ret.push_back(t);

	if(op.param.size()){
		for(int i=0; i<op.param.size(); i++){
			t = L"@param\t\t";
			t += op.param[i].name;
			t += L"\t\t\t̐\n";
			ret.push_back(t);
		}
	}
	if(!op.return_type.empty()){
		t  = L"@return\t\t\t\t\t߂l̐\n";
		ret.push_back(t);
	}
}

/*!
	@brief	pDoxygenRg𐶐
	@param	at			̏
	@param	ret			DoxygenRgi[vector
 */
void ExtractInfo::MakeAttributeComment(ClassInfo::Attribute &at, vector<wstring> &ret)
{
	wstring t;
	t = L"@brief\t\t̊Tv\n";
	ret.push_back(t);
}

/////

/*!
	@brief	JavaDocX^C̃Rgt
	@param	indent		Rg̍[ɕtCfg
	@param	str			RgtvectorRgtĖ߂
 */
void  ExtractInfo::AddComment(wstring &indent, vector<wstring> &str)
{
	wstring t;
	vector<wstring>::iterator i;
	for(i = str.begin(); i != str.end(); i++){
		t = indent;
		t += L" * ";
		t += *i;
		str.erase(i);
		str.insert(i, t);
	}
	t = indent;
	t += L"/**\n";
	str.insert(str.begin(), t);
	t = indent;
	t += L" */\n";
	str.push_back(t);
}


/////

/*!
	@brief	t@C̐擪pDoxygenRgt
	@param	filename	t@C̖O
	@param	ret			DoxygenRgtvector
 */
void ExtractInfo::AddFileComment(wstring &filename, vector<wstring> &ret)
{
	vector <wstring> data;
	wstring t = filename;
	t += GetFileExt();
	MakeFileComment(t, data);
	t = L"";
	AddComment(t, data);

	vector<wstring>::iterator i;
	for(i = data.begin(); i != data.end(); i++){
		ret.push_back(*i);
	}
}

/*!
	@brief	NXpDoxygenRgt
	@param	ci			NX̏
	@param	ret			DoxygenRgtvector
 */
void ExtractInfo::AddClassComment(ClassInfo &ci, vector<wstring> &ret)
{
	vector <wstring> data;
	MakeClassComment(ci, data);
	wstring t = L"";
	AddComment(t, data);

	vector<wstring>::iterator i;
	for(i = data.begin(); i != data.end(); i++){
		ret.push_back(*i);
	}
}

/*!
	@brief	\bhpDoxygenRgt
	@param	op			\bh̏
	@param	indent		Rg̍[ɕtCfg
	@param	ret			DoxygenRgtvector
 */
void ExtractInfo::AddMethodComment(ClassInfo::Operation &op, wstring &indent, vector<wstring> &ret)
{
	vector <wstring> data;
	MakeMethodComment(op, data);
	AddComment(indent, data);

	vector<wstring>::iterator i;
	for(i = data.begin(); i != data.end(); i++){
		ret.push_back(*i);
	}
}

/*!
	@brief	pDoxygenRgt
	@param	at			̏
	@param	indent		Rg̍[ɕtCfg
	@param	ret			DoxygenRgtvector
 */
void ExtractInfo::AddAttributeComment(ClassInfo::Attribute &at, wstring &indent, vector<wstring> &ret)
{
	vector <wstring> data;
	MakeAttributeComment(at, data);
	AddComment(indent, data);

	vector<wstring>::iterator i;
	for(i = data.begin(); i != data.end(); i++){
		ret.push_back(*i);
	}
}

///////////---

//[EOF]
