// $Id: gui.cpp,v 1.2 2002/12/27 06:05:31 yuya Exp $

////////////////////////////////////////////////////////////////////////////////

#include "exerb.h"

////////////////////////////////////////////////////////////////////////////////

int WINAPI WinMain(HINSTANCE hCurrentInstance, HINSTANCE hPrevInstance, LPSTR lpszCmdLine, int iShowCmd);

static void ExOnError(LPSTR pszMessage);
static void ExOnFail(VALUE errinfo);
static LRESULT CALLBACK ExFailDialogProc(HWND hWnd, UINT uiMessage, WPARAM wParam, LPARAM lParam);

////////////////////////////////////////////////////////////////////////////////

int WINAPI
WinMain(HINSTANCE hCurrentInstance, HINSTANCE hPrevInstance, LPSTR lpszCmdLine, int iShowCmd)
{
	return ExMain(0, NULL, ExOnError, ExOnFail);
}


static void
ExOnError(LPSTR pszMessage)
{
	char szSelfFileName[MAX_PATH] = "";
	::ExGetSelfFileName(szSelfFileName, sizeof(szSelfFileName));
	::MessageBox(NULL, pszMessage, szSelfFileName, MB_ICONERROR);
}

static void
ExOnFail(VALUE errinfo)
{
	::DialogBoxParam(
		::GetModuleHandle(NULL),
		MAKEINTRESOURCE(IDD_EXCEPTION),
		NULL,
		(DLGPROC)::ExFailDialogProc,
		(LPARAM)errinfo);
}

static LRESULT CALLBACK
ExFailDialogProc(HWND hWnd, UINT uiMessage, WPARAM wParam, LPARAM lParam)
{
	switch ( uiMessage ) {
		case WM_INITDIALOG:
			if ( lParam ) {
				const VALUE errinfo          = (VALUE)lParam;
				const VALUE vType            = ::rb_funcall(errinfo, ::rb_intern("type"), 0);
				const VALUE vTypeName        = ::rb_funcall(vType, ::rb_intern("name"), 0);
				const VALUE vMessage         = ::rb_funcall(errinfo, ::rb_intern("message"), 0);
				const VALUE vMessageString   = ::rb_funcall(vMessage, ::rb_intern("gsub"), 2, ::rb_str_new2("\n"), ::rb_str_new2("\r\n"));
				const VALUE vBacktrace       = ::rb_funcall(errinfo, ::rb_intern("backtrace"), 0);
				const VALUE vBacktraceString = ::rb_str_concat(::rb_ary_join(vBacktrace, ::rb_str_new2("\r\n")), rb_str_new2("\r\n"));

				::SetDlgItemText(hWnd, IDC_EDIT_TYPE,      STR2CSTR(vTypeName));
				::SetDlgItemText(hWnd, IDC_EDIT_MESSAGE,   STR2CSTR(vMessageString));
				::SetDlgItemText(hWnd, IDC_EDIT_BACKTRACE, STR2CSTR(vBacktraceString));
			}

			{
				char szSelfFileName[MAX_PATH]      = "";
				char szWindowTitleFormat[MAX_PATH] = "";
				char szWindowTitle[MAX_PATH]       = "";
				::ExGetSelfFileName(szSelfFileName, sizeof(szSelfFileName));
				::GetWindowText(hWnd, szWindowTitleFormat, sizeof(szWindowTitleFormat));
				::wsprintf(szWindowTitle, szWindowTitleFormat, szSelfFileName);
				::SetWindowText(hWnd, szWindowTitle);
			}

			{
				const HFONT hFont = ::CreateFont(14, 0, 0, 0, FW_REGULAR, FALSE, FALSE, FALSE, SHIFTJIS_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, PROOF_QUALITY, FIXED_PITCH | FF_MODERN, "Terminal");				SetWindowFont(::GetDlgItem(hWnd, IDC_EDIT_TYPE),      hFont, false);
				SetWindowFont(::GetDlgItem(hWnd, IDC_EDIT_MESSAGE),   hFont, false);
				SetWindowFont(::GetDlgItem(hWnd, IDC_EDIT_BACKTRACE), hFont, false);
			}

			::MessageBeep(MB_ICONHAND);

			return TRUE;
		case WM_CLOSE:
			::EndDialog(hWnd, ID_CLOSE);
			return TRUE;
		case WM_COMMAND:
			if ( LOWORD(wParam) == ID_CLOSE ) {
				::EndDialog(hWnd, ID_CLOSE);
				return TRUE;
			}
			break;
	}

	return FALSE;
}

////////////////////////////////////////////////////////////////////////////////
