// $Id: cui.cpp,v 1.2 2002/12/27 06:05:31 yuya Exp $

////////////////////////////////////////////////////////////////////////////////

#include "exerb.h"

////////////////////////////////////////////////////////////////////////////////

int main(int argc, char** argv);

static void ExOnError(LPSTR pszMessage);
static void ExOnFail(VALUE errinfo);

////////////////////////////////////////////////////////////////////////////////

int
main(int argc, char** argv)
{
	return ExMain(argc, argv, ExOnError, ExOnFail);
}


static void
ExOnError(LPSTR pszMessage)
{
	::fprintf(stderr, "%s\n", pszMessage);
}

static void
ExOnFail(VALUE errinfo)
{
	const VALUE type       = ::rb_funcall(::rb_funcall(errinfo, ::rb_intern("type"), 0), ::rb_intern("name"), 0);
	const VALUE message    = ::rb_funcall(errinfo, ::rb_intern("message"), 0);
	const VALUE backtrace  = ::rb_funcall(errinfo, ::rb_intern("backtrace"), 0);
	const VALUE backtrace1 = ::rb_ary_shift(backtrace);
	const VALUE backtrace2 = ::rb_str_concat(::rb_str_new2("\tfrom "), ::rb_ary_join(backtrace, ::rb_str_new2("\n\tfrom ")));

	::fprintf(stderr, "%s: %s (%s)\n", STR2CSTR(backtrace1), STR2CSTR(message), STR2CSTR(type));
	if ( FIX2INT(::rb_funcall(backtrace, ::rb_intern("size"), 0)) > 0 ) {
		::fprintf(stderr, "%s\n", STR2CSTR(backtrace2));
	}
}

////////////////////////////////////////////////////////////////////////////////
