package org.bbreak.excella.reports.others;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;

import org.bbreak.excella.reports.exporter.ExcelExporter;
import org.bbreak.excella.reports.model.ReportBook;
import org.bbreak.excella.reports.model.ReportSheet;
import org.bbreak.excella.reports.processor.ReportProcessor;
import org.bbreak.excella.reports.tag.ImageParamParser;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

/**
 * 摜`mF̂߂̃eXgNX
 * 
 * @since 1.0
 */
public class ImageDisplayTest {

    /**
     * ev[gV[g̃V[gRs[
     */
    private static final Integer SINGLE_COPY_NUM_OF_SHETTS = 3;

    /**
     * ev[g̏ꍇ1ڂ̃ev[gV[g̃Rs[
     */
    private static final Integer PLURAL_COPY_FIRST_NUM_OF_SHEETS = 3;

    /**
     * ev[g̏ꍇ2ڂ̃ev[gV[g̃Rs[
     */
    private static final Integer PLURAL_COPY_SECOND_NUM_OF_SHEETS = 4;

    /**
     * @throws java.lang.Exception
     */
    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    /**
     * @throws java.lang.Exception
     */
    @Before
    public void setUp() throws Exception {
    }

    /**
     * ڎmFp̉摜tt@Co͂܂
     */
    @Test
    public void testImagePrint() throws Exception {
        // 摜^Otev[gɏ㏑Œ[o
        printTagedImage( false);
        // 摜^Otev[gRs[Ē[o
        printTagedImage( true);

        // 摜tev[gɏ㏑Œ[o
        printImage( false);
        // 摜tev[gRs[Ē[o
        printImage( true);

        // 摜^Otev[g𕡐V[gRs[Ē[o
        printPluralTagedImage( true);
        // 摜^Otev[g2V[geXV[gRs[Ē[o
        printPluralTagedImage( false);

        // 摜tev[g𕡐V[gRs[Ē[o
        printPluralImage( true);
        // 摜tev[g2V[geXV[gRs[Ē[o
        printPluralImage( false);
    }

    private static void printTagedImage( boolean copyTemplate) throws Exception {
        boolean useTag = true;
        // Excel 2003`ŏo
        printExcel( "摜^Otev[g.xls", copyTemplate, useTag);
        // Excel 2007`ŏo
        printExcel( "摜^Otev[g.xlsx", copyTemplate, useTag);
    }

    private static void printImage( boolean copyTemplate) throws Exception {
        boolean useTag = false;
        // Excel 2003`ŏo
        printExcel( "摜tev[g.xls", copyTemplate, useTag);
        // Excel 2007`ŏo
        printExcel( "摜tev[g.xlsx", copyTemplate, useTag);

    }

    private static void printPluralTagedImage( boolean singleTempSheet) throws Exception {
        boolean useTag = true;
        // Excel 2003`ŏo
        if ( singleTempSheet) {
            printPluralExcel( "摜^Otev[g.xls", singleTempSheet, useTag);
        } else {
            printPluralExcel( "摜^Otev[g.xls", singleTempSheet, useTag);
        }
        // Excel 2007`ŏo
        if ( singleTempSheet) {
            printPluralExcel( "摜^Otev[g.xlsx", singleTempSheet, useTag);
        } else {
            printPluralExcel( "摜^Otev[g.xlsx", singleTempSheet, useTag);
        }
    }

    private static void printPluralImage( boolean singleTempSheet) throws Exception {
        boolean useTag = false;
        // Excel 2003`ŏo
        if ( singleTempSheet) {
            printPluralExcel( "摜tev[g.xls", singleTempSheet, useTag);
        } else {
            printPluralExcel( "摜tev[g.xls", singleTempSheet, useTag);
        }
        // Excel 2007`ŏo
        if ( singleTempSheet) {
            printPluralExcel( "摜tev[g.xlsx", singleTempSheet, useTag);
        } else {
            printPluralExcel( "摜tev[g.xlsx", singleTempSheet, useTag);
        }
    }

    private static void printExcel( String templateFileName, boolean copyTemplate, boolean useTag) throws Exception {
        // ReportBook̐
        ReportBook outputBook = null;
        if ( copyTemplate) {
            if ( useTag) {
                outputBook = createReportBook( templateFileName, "TagImage_Single_Template_Single_Copy");
            } else {
                outputBook = createReportBook( templateFileName, "Image_Single_Template_Single_Copy");
            }
        } else {
            if ( useTag) {
                outputBook = createReportBook( templateFileName, "TagImage_OverWrite_Template");
            } else {
                outputBook = createReportBook( templateFileName, "Image_OverWrite_Template");
            }
        }
        // ReportSheet̃Zbg
        setReportSheet( outputBook, copyTemplate);
        // Processor̎s
        executeProcessor( new ReportProcessor(), outputBook);
    }

    private static void printPluralExcel( String templateFileName, boolean singleTempSheet, boolean useTag) throws Exception {
        // ReportBook̐
        ReportBook outputBook = null;
        if ( singleTempSheet) {
            if ( useTag) {
                outputBook = createReportBook( templateFileName, "TagImage_Single_Template_Plural_Copy");
            } else {
                outputBook = createReportBook( templateFileName, "Image_Single_Template_Plural_Copy");
            }
        } else {
            if ( useTag) {
                outputBook = createReportBook( templateFileName, "TagImage_Plural_Template_Plural_Copy");
            } else {
                outputBook = createReportBook( templateFileName, "Image_Plural_Template_Plural_Copy");
            }
        }
        // ReportSheet̃Zbg()
        setReportSheets( singleTempSheet, outputBook);
        // Processor̎s
        executeProcessor( new ReportProcessor(), outputBook);
    }

    private static void setReportSheet( ReportBook outputBook, boolean copyTemplate) throws Exception {
        ReportSheet outputSheet = null;
        if ( copyTemplate) {
            outputSheet = new ReportSheet( "", "Rs[");
        } else {
            outputSheet = new ReportSheet( "");
        }
        // V[gɃp[^ݒ
        setParamToSheet( outputSheet);
        // ubNɃV[gZbg
        outputBook.addReportSheet( outputSheet);
    }

    private static void setReportSheets( boolean singleTempSheet, ReportBook outputBook) throws Exception {
        if ( singleTempSheet) {
            for ( int i = 1; i <= SINGLE_COPY_NUM_OF_SHETTS; i++) {
                ReportSheet outputSheet = new ReportSheet( "", "Rs[" + i);
                // V[gɃp[^ݒ
                setParamToSheet( outputSheet);
                // ubNɃV[gZbg
                outputBook.addReportSheet( outputSheet);
            }
        } else {
            for ( int i = 1; i <= PLURAL_COPY_FIRST_NUM_OF_SHEETS; i++) {
                ReportSheet outputSheet = new ReportSheet( "A", "ARs[" + i);
                // V[gɃp[^ݒ
                setParamToSheet( outputSheet);
                // ubNɃV[gZbg
                outputBook.addReportSheet( outputSheet);
            }
            int start = PLURAL_COPY_FIRST_NUM_OF_SHEETS + 1;
            int end = PLURAL_COPY_FIRST_NUM_OF_SHEETS + PLURAL_COPY_SECOND_NUM_OF_SHEETS;
            for ( int i = start; i <= end; i++) {
                ReportSheet outputSheet = new ReportSheet( "B", "BRs[" + i);
                // V[gɃp[^ݒ
                setParamToSheet( outputSheet);
                // ubNɃV[gZbg
                outputBook.addReportSheet( outputSheet);
            }
        }
    }

    private static void executeProcessor( ReportProcessor reportProcessor, ReportBook outputBook) throws Exception {
        reportProcessor.process( outputBook);
    }

    private static void setParamToSheet( ReportSheet outputSheet) throws Exception {
        URL imageFileUrl = ImageDisplayTest.class.getResource( "S.JPG");
        String imageFilePath = URLDecoder.decode( imageFileUrl.getPath(), "UTF-8");
        outputSheet.addParam( ImageParamParser.DEFAULT_TAG, "ЃS", imageFilePath);

        URL imageFileUrl2 = ImageDisplayTest.class.getResource( "SQ.PNG");
        String imageFilePath2 = URLDecoder.decode( imageFileUrl2.getPath(), "UTF-8");
        outputSheet.addParam( ImageParamParser.DEFAULT_TAG, "ЃSQ", imageFilePath2);
    }

    private static ReportBook createReportBook( String templateFileName, String outputFileName) throws UnsupportedEncodingException {
        String templateFilePath = getTemplateFilePath( templateFileName);
        String tmpDirPath = System.getProperty( "user.dir") + "/work/test/";
        File file = new File( tmpDirPath);
        if ( !file.exists()) {
            file.mkdirs();
        }
        String outputFilePath = tmpDirPath.concat( outputFileName);
        ReportBook outputBook = new ReportBook( templateFilePath, outputFilePath, ExcelExporter.FORMAT_TYPE);
        return outputBook;
    }

    private static String getTemplateFilePath( String templateFileName) throws UnsupportedEncodingException {
        URL templateFileUrl = ImageDisplayTest.class.getResource( templateFileName);
        String templateFilePath = URLDecoder.decode( templateFileUrl.getPath(), "UTF-8");
        return templateFilePath;
    }

}
