/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Reports - Excelt@C𗘗p[c[
 *
 * $Id: ReportsTestUtil.java 197 2010-11-19 09:14:57Z akira-yokoi $
 * $Revision: 197 $
 *
 * This file is part of ExCella Reports.
 *
 * ExCella Reports is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Reports is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Reports.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.reports;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.hssf.util.PaneInformation;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Footer;
import org.apache.poi.ss.usermodel.Header;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.bbreak.excella.reports.processor.CheckMessage;
import org.bbreak.excella.reports.processor.ReportsCheckException;

/**
 * eXgp̃[eBeBNX
 * 
 * @since 1.0
 */
public class ReportsTestUtil {

    /**
     * O
     */
    private static Log log = LogFactory.getLog( ReportsTestUtil.class);

    /**
     * XSSFő
     */
    public static final int XSSF_MAX_COLUMN_NUMBER = 16384; // 2^14

    /**
     * HSSFő
     */
    public static final int HSSF_MAX_COLUMN_NUMBER = 256; // 2^8

    /**
     * V[g
     * 
     * @param expected ҒlV[g
     * @param actual lV[g
     * @param isActCopyOfExp lV[g[NubN̊ҒlV[g̃Rs[Ȃtrue
     * @throws ReportsCheckException G[
     */
    public static void checkSheet( Sheet expected, Sheet actual, boolean isActCopyOfExp) throws ReportsCheckException {

        List<CheckMessage> errors = new ArrayList<CheckMessage>();

        Workbook expectedWorkbook = expected.getWorkbook();
        Workbook actualWorkbook = actual.getWorkbook();

        if ( log.isDebugEnabled()) {
            log.debug( "V[g[" + actualWorkbook.getSheetName( actualWorkbook.getSheetIndex( actual)) + "] check start!");
        }

        // ----------------------
        // V[gPʂ̃`FbN
        // ----------------------
        // V[g
        String eSheetName = expectedWorkbook.getSheetName( expectedWorkbook.getSheetIndex( expected));
        String aSheetName = actualWorkbook.getSheetName( actualWorkbook.getSheetIndex( actual));

        if ( !isActCopyOfExp) {
            if ( !eSheetName.equals( aSheetName)) {
                errors.add( new CheckMessage( "V[g", eSheetName, aSheetName));
            }
        }

        // ݒ
        String ePrintSetupString = getPrintSetupString( expected.getPrintSetup());
        String aPrintSetupString = getPrintSetupString( actual.getPrintSetup());

        if ( !ePrintSetupString.equals( aPrintSetupString)) {
            errors.add( new CheckMessage( "ݒ", ePrintSetupString, aPrintSetupString));
        }

        // wb_Atb^
        String eHeaderString = getHeaderString( expected.getHeader());
        String aHeaderString = getHeaderString( actual.getHeader());
        if ( !eHeaderString.equals( aHeaderString)) {
            errors.add( new CheckMessage( "wb_", eHeaderString, aHeaderString));
        }
        String eFooterString = getFooterString( expected.getFooter());
        String aFooterString = getFooterString( actual.getFooter());
        if ( !eFooterString.equals( aFooterString)) {
            errors.add( new CheckMessage( "tb^", eFooterString, aFooterString));
        }

        // y[W
        String eBreaksString = getBreaksString( expected);
        String aBreaksString = getBreaksString( actual);
        log.debug( eBreaksString + "/" + aBreaksString);
        if ( !eBreaksString.equals( aBreaksString)) {
            errors.add( new CheckMessage( "y[W", eBreaksString, aBreaksString));
        }

        // ͈
        String expectedPrintArea = expectedWorkbook.getPrintArea( expectedWorkbook.getSheetIndex( expected));
        String actualPrintArea = actualWorkbook.getPrintArea( actualWorkbook.getSheetIndex( actual));
        if ( expectedPrintArea != null || actualPrintArea != null) {
            // lV[gҒlV[g̃Rs[̏ꍇAlV[g͈̈͂NullɂȂoÔߏC܂Ń`FbNȂ
            // if ( expectedPrintArea == null || actualPrintArea == null || !equalPrintArea( expectedPrintArea, actualPrintArea, isActCopyOfExp)) {
            // errors.add( new CheckMessage( "͈", expectedPrintArea, actualPrintArea));
            // }
            if ( !isActCopyOfExp) {
                if ( expectedPrintArea == null || actualPrintArea == null || !expectedPrintArea.equals( actualPrintArea)) {
                    errors.add( new CheckMessage( "͈", expectedPrintArea, actualPrintArea));
                }
            }
        }

        // EBhEg(ŒA)
        String ePaneInformationString = getPaneInformationString( expected.getPaneInformation());
        String aPaneInformationString = getPaneInformationString( actual.getPaneInformation());

        if ( !ePaneInformationString.equals( aPaneInformationString)) {
            errors.add( new CheckMessage( "EBhEg(ŒA)", expectedPrintArea, actualPrintArea));
        }

        // s^CgA^CgEEEZbg͂ł邪BBB

        // \Y[EEEZbg͂ł邪BBB

        // AEgCEEEZbg͂ł邪BBB

        // ZRg

        // ObhC\
        if ( expected.isDisplayGridlines() ^ actual.isDisplayGridlines()) {
            errors.add( new CheckMessage( "ObhC\", String.valueOf( expected.isDisplayGridlines()), String.valueOf( actual.isDisplayGridlines())));
        }

        // o\
        if ( expected.isDisplayRowColHeadings() ^ actual.isDisplayRowColHeadings()) {
            errors.add( new CheckMessage( "o\", String.valueOf( expected.isDisplayRowColHeadings()), String.valueOf( actual.isDisplayRowColHeadings())));
        }

        // \
        if ( expected.isDisplayFormulas() ^ actual.isDisplayFormulas()) {
            errors.add( new CheckMessage( "\", String.valueOf( expected.isDisplayFormulas()), String.valueOf( actual.isDisplayFormulas())));
        }
        // Z
        if ( expected.getNumMergedRegions() != actual.getNumMergedRegions()) {
            errors.add( new CheckMessage( "Z", String.valueOf( expected.getNumMergedRegions()), String.valueOf( actual.getNumMergedRegions())));
        }

        for ( int i = 0; i < actual.getNumMergedRegions(); i++) {

            CellRangeAddress actualAddress = null;
            if ( expected instanceof HSSFSheet) {
                actualAddress = (( HSSFSheet) actual).getMergedRegion( i);
            } else if ( expected instanceof XSSFSheet) {
                actualAddress = (( XSSFSheet) actual).getMergedRegion( i);
            }

            StringBuffer expectedAdressBuffer = new StringBuffer();
            boolean equalAddress = false;
            for ( int j = 0; j < expected.getNumMergedRegions(); j++) {
                CellRangeAddress expectedAddress = null;
                if ( expected instanceof HSSFSheet) {
                    expectedAddress = (( HSSFSheet) expected).getMergedRegion( j);
                } else if ( expected instanceof XSSFSheet) {
                    expectedAddress = (( XSSFSheet) expected).getMergedRegion( j);
                }
                if ( expectedAddress.toString().equals( actualAddress.toString())) {
                    equalAddress = true;
                    break;
                }
                CellReference crA = new CellReference( expectedAddress.getFirstRow(), expectedAddress.getFirstColumn());
                CellReference crB = new CellReference( expectedAddress.getLastRow(), expectedAddress.getLastColumn());
                expectedAdressBuffer.append( " [" + crA.formatAsString() + ":" + crB.formatAsString() + "]");
            }

            if ( !equalAddress) {
                errors.add( new CheckMessage( "Z", expectedAdressBuffer.toString(), actualAddress.toString()));
            }

        }

        int maxColumnNum = -1;
        if ( expected instanceof HSSFSheet) {
            maxColumnNum = HSSF_MAX_COLUMN_NUMBER;
        } else if ( expected instanceof XSSFSheet) {
            maxColumnNum = XSSF_MAX_COLUMN_NUMBER;
        }
        for ( int i = 0; i < maxColumnNum; i++) {
            try {
                // X^C
                checkCellStyle( expected.getWorkbook(), expected.getColumnStyle( i), actual.getWorkbook(), actual.getColumnStyle( i));
            } catch ( ReportsCheckException e) {
                CheckMessage checkMessage = e.getCheckMessages().iterator().next();
                checkMessage.setMessage( "[" + i + "]" + checkMessage.getMessage());
                errors.add( checkMessage);
            }

            // 
            if ( expected.getColumnWidth( i) != actual.getColumnWidth( i)) {
                errors.add( new CheckMessage( "[" + i + "]", String.valueOf( expected.getColumnWidth( i)), String.valueOf( actual.getColumnWidth( i))));
            }
        }

        // sPʃ`FbN
        if ( expected.getLastRowNum() != actual.getLastRowNum()) {
            // Ғl܂ŁAluN
            if ( expected.getLastRowNum() < actual.getLastRowNum()) {
                int lastRowIndex = -1;
                if ( expected instanceof HSSFSheet) {
                    lastRowIndex = 0;
                }
                Iterator<Row> rowIterator = actual.rowIterator();
                while ( rowIterator.hasNext()) {
                    Row row = rowIterator.next();
                    // ׂăuŃA󔒍s
                    Iterator<Cell> cellIterator = row.cellIterator();
                    while ( cellIterator.hasNext()) {
                        Cell cell = cellIterator.next();
                        if ( cell.getCellType() != Cell.CELL_TYPE_BLANK) {
                            lastRowIndex = row.getRowNum();
                            break;
                        }
                    }
                }
                if ( expected.getLastRowNum() != lastRowIndex) {
                    errors.add( new CheckMessage( "ŏIs", String.valueOf( expected.getLastRowNum()), String.valueOf( lastRowIndex)));
                }
            } else {
                errors.add( new CheckMessage( "ŏIs", String.valueOf( expected.getLastRowNum()), String.valueOf( actual.getLastRowNum())));
            }

        }

        if ( errors.isEmpty()) {
            for ( int i = 0; i <= expected.getLastRowNum(); i++) {
                try {
                    checkRow( expected.getRow( i), actual.getRow( i));
                } catch ( ReportsCheckException e) {
                    errors.addAll( e.getCheckMessages());
                }
            }
        }

        if ( !errors.isEmpty()) {
            if ( log.isErrorEnabled()) {
                for ( CheckMessage message : errors) {
                    log.error( "L[" + message.getMessage() + "]");
                    log.error( "Ғl:" + message.getExpected());
                    log.error( "l:" + message.getActual());
                }
            }
            throw new ReportsCheckException( errors);
        }

        if ( log.isDebugEnabled()) {
            log.debug( "V[g[" + actualWorkbook.getSheetName( actualWorkbook.getSheetIndex( actual)) + "] check end.");
        }

    }

    /**
     * s
     * 
     * @param expected Ғls
     * @param actual ls
     * @throws ReportsCheckException G[
     */
    public static void checkRow( Row expected, Row actual) throws ReportsCheckException {

        List<CheckMessage> errors = new ArrayList<CheckMessage>();

        // ----------------------
        // sPʂ̃`FbN
        // ----------------------

        if ( expected == null && actual == null) {
            return;
        }

        if ( expected == null) {
            if ( actual.iterator().hasNext()) {
                errors.add( new CheckMessage( "s[" + actual.getRowNum() + "]", null, actual.toString()));
                throw new ReportsCheckException( errors);
            } else {
                return;
            }
        }
        if ( actual == null) {
            if ( expected.iterator().hasNext()) {
                errors.add( new CheckMessage( "s[" + expected.getRowNum() + "]", expected.toString(), null));
                throw new ReportsCheckException( errors);
            } else {
                return;
            }
        }

        // s̍(shiftRowƍs̍Ȃ邽߁A`FbNȂ)
        // float adjustHight = 0f;
        // if ( hasHeightAdjustBorderCell( actual.getSheet().getRow( actual.getRowNum() - 1), actual, actual.getSheet().getRow( actual.getRowNum() + 1))) {
        // log.error( "true");
        // adjustHight = 0.75f;
        // }
        //
        // if ( expected.getHeightInPoints() != actual.getHeightInPoints() + adjustHight) {
        // if ( log.isErrorEnabled()) {
        // log.error( "expectedROW[" + expected.getRowNum() + "]:" + expected.getHeightInPoints());
        // log.error( "actualROW[" + actual.getRowNum() + "]:" + (actual.getHeightInPoints() + adjustHight));
        // }
        // throw new Exception( "s̍");
        // }

        // ŏIZ
        if ( expected.getLastCellNum() != actual.getLastCellNum()) {
            errors.add( new CheckMessage( "s[" + expected.getRowNum() + "]ŏIZ", String.valueOf( expected.getLastCellNum()), String.valueOf( actual.getLastCellNum())));
            throw new ReportsCheckException( errors);
        }

        // ZPʃ`FbN
        for ( int i = 0; i < expected.getLastCellNum(); i++) {
            try {
                checkCell( expected.getCell( i), actual.getCell( i));
            } catch ( ReportsCheckException e) {
                errors.addAll( e.getCheckMessages());
            }
        }
        if ( !errors.isEmpty()) {
            throw new ReportsCheckException( errors);
        }
    }

    /**
     * Z
     * 
     * @param expected ҒlZ
     * @param actual lZ
     * @throws ReportsCheckException G[
     */
    public static void checkCell( Cell expected, Cell actual) throws ReportsCheckException {

        List<CheckMessage> errors = new ArrayList<CheckMessage>();

        // ----------------------
        // ZPʂ̃`FbN
        // ----------------------

        if ( expected == null && actual == null) {
            return;
        }

        if ( expected == null) {
            // if(actual.getCellStyle() != null || actual.getCellType() != Cell.CELL_TYPE_BLANK){
            errors.add( new CheckMessage( "Z(" + actual.getRowIndex() + "," + actual.getColumnIndex() + ")", null, actual.toString()));
            throw new ReportsCheckException( errors);
            // }
        }
        if ( actual == null) {
            errors.add( new CheckMessage( "Z(" + expected.getRowIndex() + "," + expected.getColumnIndex() + ")", expected.toString(), null));
            throw new ReportsCheckException( errors);
        }

        // ^
        if ( expected.getCellType() != actual.getCellType()) {
            errors.add( new CheckMessage( "^[" + "Z(" + expected.getRowIndex() + "," + expected.getColumnIndex() + ")" + "]", getCellTypeString( expected.getCellType()), getCellTypeString( actual
                .getCellType())));
            throw new ReportsCheckException( errors);
        }

        try {
            checkCellStyle( expected.getRow().getSheet().getWorkbook(), expected.getCellStyle(), actual.getRow().getSheet().getWorkbook(), actual.getCellStyle());
        } catch ( ReportsCheckException e) {
            CheckMessage checkMessage = e.getCheckMessages().iterator().next();
            checkMessage.setMessage( "Z(" + expected.getRowIndex() + "," + expected.getColumnIndex() + ")" + checkMessage.getMessage());
            errors.add( checkMessage);
            throw new ReportsCheckException( errors);
        }

        // l
        if ( !getCellValue( expected).equals( getCellValue( actual))) {
            log.error( getCellValue( expected) + " / " + getCellValue( actual));
            errors.add( new CheckMessage( "l[" + "Z(" + expected.getRowIndex() + "," + expected.getColumnIndex() + ")" + "]", String.valueOf( getCellValue( expected)), String
                .valueOf( getCellValue( actual))));
            throw new ReportsCheckException( errors);
        }

    }

    /**
     * X^C
     * 
     * @param expectedWorkbook ҒlubN
     * @param expected ҒlX^C
     * @param actualWorkbook lX^CubN
     * @param actual lX^C
     * @throws ReportsCheckException G[
     */
    private static void checkCellStyle( Workbook expectedWorkbook, CellStyle expected, Workbook actualWorkbook, CellStyle actual) throws ReportsCheckException {

        List<CheckMessage> errors = new ArrayList<CheckMessage>();

        if ( expected == null && actual == null) {
            return;
        }

        if ( expected == null) {
            errors.add( new CheckMessage( "X^C", null, actual.toString()));
            throw new ReportsCheckException( errors);
        }

        if ( actual == null) {
            errors.add( new CheckMessage( "X^C", expected.toString(), null));
            throw new ReportsCheckException( errors);
        }

        String eCellStyleString = null;
        String aCellStyleString = null;

        if ( expected instanceof HSSFCellStyle) {
            HSSFCellStyle expectedStyle = ( HSSFCellStyle) expected;
            HSSFCellStyle actualStyle = ( HSSFCellStyle) actual;
            eCellStyleString = getCellStyleString( expectedWorkbook, expectedStyle);
            aCellStyleString = getCellStyleString( actualWorkbook, actualStyle);
        } else if ( expected instanceof XSSFCellStyle) {
            XSSFCellStyle expectedStyle = ( XSSFCellStyle) expected;
            XSSFCellStyle actualStyle = ( XSSFCellStyle) actual;
            eCellStyleString = getCellStyleString( expectedStyle);
            aCellStyleString = getCellStyleString( actualStyle);
        }

        if ( !eCellStyleString.equals( aCellStyleString)) {
            errors.add( new CheckMessage( "X^C", eCellStyleString, aCellStyleString));
            throw new ReportsCheckException( errors);

        }
    }

    /**
     * HSSFX^C̕\擾
     * 
     * @param workbook ubN
     * @param cellStyle X^C
     * @return X^C̕\
     */
    private static String getCellStyleString( Workbook workbook, HSSFCellStyle cellStyle) {
        StringBuffer sb = new StringBuffer();
        if ( cellStyle != null) {
            HSSFFont font = cellStyle.getFont( workbook);
            // sb.append("FontIndex=").append( cellStyle.getFontIndex()).append( ",");
            sb.append( "Font=").append( getHSSFFontString( ( HSSFWorkbook) workbook, font)).append( ",");

            sb.append( "DataFormat=").append( cellStyle.getDataFormat()).append( ",");
            sb.append( "DataFormatString=").append( cellStyle.getDataFormatString()).append( ",");
            sb.append( "Hidden=").append( cellStyle.getHidden()).append( ",");
            sb.append( "Locked=").append( cellStyle.getLocked()).append( ",");
            sb.append( "Alignment=").append( cellStyle.getAlignment()).append( ",");
            sb.append( "WrapText=").append( cellStyle.getWrapText()).append( ",");
            sb.append( "VerticalAlignment=").append( cellStyle.getVerticalAlignment()).append( ",");
            sb.append( "Rotation=").append( cellStyle.getRotation()).append( ",");
            sb.append( "Indention=").append( cellStyle.getIndention()).append( ",");
            sb.append( "BorderLeft=").append( cellStyle.getBorderLeft()).append( ",");
            sb.append( "BorderRight=").append( cellStyle.getBorderRight()).append( ",");
            sb.append( "BorderTop=").append( cellStyle.getBorderTop()).append( ",");
            sb.append( "BorderBottom=").append( cellStyle.getBorderBottom()).append( ",");

            sb.append( "LeftBorderColor=").append( getHSSFColorString( ( HSSFWorkbook) workbook, cellStyle.getLeftBorderColor())).append( ",");
            sb.append( "RightBorderColor=").append( getHSSFColorString( ( HSSFWorkbook) workbook, cellStyle.getRightBorderColor())).append( ",");
            sb.append( "TopBorderColor=").append( getHSSFColorString( ( HSSFWorkbook) workbook, cellStyle.getTopBorderColor())).append( ",");
            sb.append( "BottomBorderColor=").append( getHSSFColorString( ( HSSFWorkbook) workbook, cellStyle.getBottomBorderColor())).append( ",");

            sb.append( "FillPattern=").append( cellStyle.getFillPattern()).append( ",");
            sb.append( "FillForegroundColor=").append( getHSSFColorString( ( HSSFWorkbook) workbook, cellStyle.getFillForegroundColor())).append( ",");
            sb.append( "FillBackgroundColor=").append( getHSSFColorString( ( HSSFWorkbook) workbook, cellStyle.getFillBackgroundColor()));
        }
        return sb.toString();
    }

    /**
     * HSSFtHg̕\擾
     * 
     * @param workbook ubN
     * @param font tHg
     * @return tHg̕\
     */
    private static String getHSSFFontString( HSSFWorkbook workbook, HSSFFont font) {
        StringBuffer sb = new StringBuffer();
        sb.append( "[FONT]");
        sb.append( "fontheight=").append( Integer.toHexString( font.getFontHeight())).append( ",");
        sb.append( "italic=").append( font.getItalic()).append( ",");
        sb.append( "strikout=").append( font.getStrikeout()).append( ",");
        sb.append( "colorpalette=").append( getHSSFColorString( ( HSSFWorkbook) workbook, font.getColor())).append( ",");
        sb.append( "boldweight=").append( Integer.toHexString( font.getBoldweight())).append( ",");
        sb.append( "supersubscript=").append( Integer.toHexString( font.getTypeOffset())).append( ",");
        sb.append( "underline=").append( Integer.toHexString( font.getUnderline())).append( ",");
        sb.append( "charset=").append( Integer.toHexString( font.getCharSet())).append( ",");
        sb.append( "fontname=").append( font.getFontName());
        sb.append( "[/FONT]");
        return sb.toString();
    }

    /**
     * HSSFF̕\擾
     * 
     * @param workbook ubN
     * @param index FCfbNX
     * @return HSSFF̕\
     */
    private static String getHSSFColorString( HSSFWorkbook workbook, short index) {
        HSSFPalette palette = workbook.getCustomPalette();
        if ( palette.getColor( index) != null) {
            HSSFColor color = palette.getColor( index);
            return color.getHexString();
        } else {
            return "";
        }
    }

    /**
     * XSSFX^C̕\擾
     * 
     * @param cellStyle X^C
     * @return X^C̕\
     */
    private static String getCellStyleString( XSSFCellStyle cellStyle) {
        StringBuffer sb = new StringBuffer();
        if ( cellStyle != null) {
            XSSFFont font = cellStyle.getFont();
            sb.append( "Font=").append( font.getCTFont()).append( ",");
            sb.append( "DataFormat=").append( cellStyle.getDataFormat()).append( ",");
            sb.append( "DataFormatString=").append( cellStyle.getDataFormatString()).append( ",");
            sb.append( "Hidden=").append( cellStyle.getHidden()).append( ",");
            sb.append( "Locked=").append( cellStyle.getLocked()).append( ",");
            sb.append( "Alignment=").append( cellStyle.getAlignment()).append( ",");
            sb.append( "WrapText=").append( cellStyle.getWrapText()).append( ",");
            sb.append( "VerticalAlignment=").append( cellStyle.getVerticalAlignment()).append( ",");
            sb.append( "Rotation=").append( cellStyle.getRotation()).append( ",");
            sb.append( "Indention=").append( cellStyle.getIndention()).append( ",");
            sb.append( "BorderLeft=").append( cellStyle.getBorderLeft()).append( ",");
            sb.append( "BorderRight=").append( cellStyle.getBorderRight()).append( ",");
            sb.append( "BorderTop=").append( cellStyle.getBorderTop()).append( ",");
            sb.append( "BorderBottom=").append( cellStyle.getBorderBottom()).append( ",");

            sb.append( "LeftBorderColor=").append( getXSSFColorString( cellStyle.getLeftBorderXSSFColor())).append( ",");
            sb.append( "RightBorderColor=").append( getXSSFColorString( cellStyle.getRightBorderXSSFColor())).append( ",");
            sb.append( "TopBorderColor=").append( getXSSFColorString( cellStyle.getTopBorderXSSFColor())).append( ",");
            sb.append( "BottomBorderColor=").append( getXSSFColorString( cellStyle.getBottomBorderXSSFColor())).append( ",");

            sb.append( "FillPattern=").append( cellStyle.getFillPattern()).append( ",");
            try {
                sb.append( "FillForegroundColor=").append( getXSSFColorString( cellStyle.getFillForegroundXSSFColor())).append( ",");
            } catch ( NullPointerException e) {
                // POI-3.7O
                sb.append( "FillForegroundColor=none,");
            }
            
            try {
                sb.append( "FillBackgroundColor=").append( getXSSFColorString( cellStyle.getFillBackgroundXSSFColor()));
            } catch ( NullPointerException e) {
                // POI-3.7O
                sb.append( "FillBackgroundColor=none,");
            }
        }
        return sb.toString();
    }

    /**
     * XSSFF̕\擾
     * 
     * @param color XSSFF
     * @return XSSFF̕\
     */
    private static String getXSSFColorString( XSSFColor color) {
        StringBuffer sb = new StringBuffer( "[");
        if ( color != null) {
            sb.append( "Indexed=").append( color.getIndexed()).append( ",");
            sb.append( "Rgb=");
            if ( color.getRgb() != null) {
                for ( byte b : color.getRgb()) {
                    sb.append( String.format( "%02x", b).toUpperCase());
                }
            }
            sb.append( ",");
            sb.append( "Tint=").append( color.getTint()).append( ",");
            sb.append( "Theme=").append( color.getTheme()).append( ",");
            sb.append( "Auto=").append( color.isAuto());
        }
        return sb.append( "]").toString();
    }

    /**
     * ݒ̕\擾B
     * 
     * @param printSetup ݒ
     * @return ݒ̕\
     */
    public static String getPrintSetupString( PrintSetup printSetup) {
        StringBuffer sb = new StringBuffer();
        if ( printSetup != null) {
            sb.append( "PaperSize=").append( printSetup.getPaperSize()).append( ",");
            sb.append( "Scale=").append( printSetup.getScale()).append( ",");
            sb.append( "PageStart=").append( printSetup.getPageStart()).append( ",");
            sb.append( "FitWidth=").append( printSetup.getFitWidth()).append( ",");
            sb.append( "FitHeight=").append( printSetup.getFitHeight()).append( ",");
            sb.append( "LeftToRight=").append( printSetup.getLeftToRight()).append( ",");
            sb.append( "Landscape=").append( printSetup.getLandscape()).append( ",");
            sb.append( "ValidSettings=").append( printSetup.getValidSettings()).append( ",");
            sb.append( "NoColor=").append( printSetup.getNoColor()).append( ",");
            sb.append( "Draft=").append( printSetup.getDraft()).append( ",");
            sb.append( "Notes=").append( printSetup.getNotes()).append( ",");
            sb.append( "NoOrientation=").append( printSetup.getNoOrientation()).append( ",");
            sb.append( "UsePage=").append( printSetup.getUsePage()).append( ",");
            sb.append( "HResolution=").append( printSetup.getHResolution()).append( ",");
            sb.append( "VResolution=").append( printSetup.getVResolution()).append( ",");
            sb.append( "HeaderMargin=").append( printSetup.getHeaderMargin()).append( ",");
            sb.append( "FooterMargin=").append( printSetup.getFooterMargin()).append( ",");
            sb.append( "Copies=").append( printSetup.getCopies());
        }
        return sb.toString();

    }

    /**
     * wb_̕\擾B
     * 
     * @param header wb_
     * @return wb_̕\
     */
    private static String getHeaderString( Header header) {
        if ( header != null) {
            return "left=" + header.getLeft() + ",center=" + header.getCenter() + ",right=" + header.getRight();
        } else {
            return "";
        }
    }

    /**
     * @param footer
     * @return
     */
    private static String getFooterString( Footer footer) {
        if ( footer != null) {
            return "left=" + footer.getLeft() + ",center=" + footer.getCenter() + ",right=" + footer.getRight();
        } else {
            return "";
        }
    }

    /**
     * y[W̕\擾B
     * 
     * @param sheet V[g
     * @return y[W̕\
     */
    private static String getBreaksString( Sheet sheet) {

        return "row=" + Arrays.toString( sheet.getRowBreaks()) + ",column=" + Arrays.toString( sheet.getColumnBreaks());

    }

    /**
     * EBhEg̕\擾B
     * 
     * @param information EBhEg
     * @return EBhEg̕\
     */
    private static String getPaneInformationString( PaneInformation information) {
        StringBuffer sb = new StringBuffer();
        if ( information != null) {
            sb.append( "HorizontalSplitPosition=").append( information.getHorizontalSplitPosition()).append( ",");
            sb.append( "HorizontalSplitTopRow=").append( information.getHorizontalSplitTopRow()).append( ",");
            sb.append( "VerticalSplitPosition=").append( information.getVerticalSplitPosition()).append( ",");
            sb.append( "VerticalSplitLeftColumn=").append( information.getVerticalSplitLeftColumn());
        }
        return sb.toString();
    }

    /**
     * Z̒l̕\擾
     * 
     * @param cell Z
     * @return Z̒l̕\
     */
    private static String getCellValue( Cell cell) {
        String value = null;

        if ( cell != null) {
            switch ( cell.getCellType()) {
                case Cell.CELL_TYPE_BLANK:
                    value = cell.getStringCellValue();
                    break;
                case Cell.CELL_TYPE_BOOLEAN:
                    value = String.valueOf( cell.getBooleanCellValue());
                    break;
                case Cell.CELL_TYPE_ERROR:
                    value = String.valueOf( cell.getErrorCellValue());
                    break;
                case Cell.CELL_TYPE_NUMERIC:
                    value = String.valueOf( cell.getNumericCellValue());
                    break;
                case Cell.CELL_TYPE_STRING:
                    value = cell.getStringCellValue();
                    break;
                case Cell.CELL_TYPE_FORMULA:
                    value = cell.getCellFormula();
                default:
                    value = "";
            }
        }
        return value;
    }

    /**
     * Z^Cv̕\擾
     * 
     * @param cellType Z^Cv
     * @return Z^Cv̕\
     */
    private static String getCellTypeString( int cellType) {
        switch ( cellType) {
            case Cell.CELL_TYPE_BLANK:
                return "BLANK";
            case Cell.CELL_TYPE_BOOLEAN:
                return "BOOLEAN";
            case Cell.CELL_TYPE_ERROR:
                return "BLANK";
            case Cell.CELL_TYPE_NUMERIC:
                return "NUMERIC";
            case Cell.CELL_TYPE_STRING:
                return "STRING";
            case Cell.CELL_TYPE_FORMULA:
                return "FORMULA";
            default:
                return "";
        }
    }

    public static String getTestOutputDir() {

        String tempDir = System.getProperty( "user.dir") + "/work/test/";
        File file = new File( tempDir);
        if ( !file.exists()) {
            file.mkdirs();
        }

        return tempDir;
    }

    /**
     * ͈͌
     * 
     * @param expectedPrintArea Ғl͈
     * @param actualPrintArea l͈
     * @param isCopy lV[gҒlV[g̃Rs[Ȃtrue
     * @return
     */
    // private static boolean equalPrintArea( String expectedPrintArea, String actualPrintArea, boolean isActCopyOfExp) {
    // boolean returnValue = true;
    // if ( isActCopyOfExp) {
    // String expPrintAreaWithoutSheetName = expectedPrintArea.substring( expectedPrintArea.indexOf( '!'));
    // String actPrintAreaWithoutSheetName = actualPrintArea.substring( actualPrintArea.indexOf( '!'));
    // if ( !expPrintAreaWithoutSheetName.equals( actPrintAreaWithoutSheetName)) {
    // returnValue = false;
    // }
    // } else {
    // if ( !expectedPrintArea.equals( actualPrintArea)) {
    // returnValue = false;
    // }
    // }
    // return returnValue;
    // }
}
