/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Reports - Excelt@C𗘗p[c[
 *
 * $Id: ConvertConfiguration.java 137 2010-07-29 04:35:30Z akira-yokoi $
 * $Revision: 137 $
 *
 * This file is part of ExCella Reports.
 *
 * ExCella Reports is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Reports is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Reports .  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.reports.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * ϊێNX
 * 
 * @since 1.0
 */
@SuppressWarnings("serial")
public class ConvertConfiguration implements Serializable{

    /**
     * tH[}bg
     */
    private String formatType = null;

    /**
     * o̓IvV
     */
    private Map<String, Object> options = new HashMap<String, Object>();
    
    /**
     * ftHgRXgN^
     */
    public ConvertConfiguration(){
    }
    
    /**
     * RXgN^
     * 
     * @param formatType tH[}bg
     */
    public ConvertConfiguration( String formatType) {
        this.formatType = formatType;
    }

    /**
     * IvVǉB
     * 
     * @param property vpeB
     * @param value l
     */
    public void addOption( String property, Object value) {
        options.put( property, value);
    }

    /**
     * IvVǉB
     * 
     * @param options IvV
     */
    public void addOptions( Map<String, Object> options) {
        this.options.putAll( options);
    }

    /**
     * IvVB
     */
    public void clearOptions() {
        options.clear();
    }

    /**
     * IvV폜B
     * 
     * @param property vpeB
     */
    public void removeOption( String property) {
        options.remove( property);
    }

    /**
     * IvVvpeBꗗ̎擾B
     * 
     * @return vpeBꗗ
     */
    public Set<String> getOptionsProperties() {
        return options.keySet();
    }

    /**
     * IvVݒl擾B
     * 
     * @param property vpeB
     * @return IvVݒl
     */
    public Object getOptionValue( String property) {
        return options.get( property);
    }

    /**
     * IvV擾B
     * 
     * @return IvV
     */
    public Map<String, Object> getOptions() {
        return new HashMap<String, Object>( options);
    }

    /**
     * tH[}bg擾܂B
     * 
     * @return tH[}bg
     */
    public String getFormatType() {
        return formatType;
    }

    /**
     * tH[}bgݒ肵܂B
     * 
     * @param formatType tH[}bg
     */
    public void setFormatType( String formatType) {
        this.formatType = formatType;
    }

}
