/*
 * Decompiled with CFR 0.152.
 */
package org.bbreak.excella.core.exporter.sheet;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.Sheet;
import org.bbreak.excella.core.SheetData;
import org.bbreak.excella.core.exception.ExportException;
import org.bbreak.excella.core.exporter.sheet.SheetExporter;

public class TextFileExporter
implements SheetExporter {
    private static Log log = LogFactory.getLog(TextFileExporter.class);
    private String directoryPath = null;
    private String baseFilePath = null;

    @Override
    public void setup() {
    }

    @Override
    public void export(Sheet sheet, SheetData sheetdata) throws ExportException {
        if (this.directoryPath == null && this.baseFilePath == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u51fa\u529b\u5148\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            }
        } else {
            if (this.directoryPath != null) {
                File file = new File(this.directoryPath, sheetdata.getSheetName() + ".txt");
                this.writeTextFile(file, sheetdata.toString());
            }
            if (this.baseFilePath != null) {
                int parentPathIndex = this.baseFilePath.lastIndexOf(File.separatorChar);
                String parentPath = "";
                String headFileName = "";
                try {
                    parentPath = this.baseFilePath.substring(0, parentPathIndex);
                    headFileName = this.baseFilePath.substring(parentPathIndex + 1);
                }
                catch (IndexOutOfBoundsException iobe) {
                    throw new ExportException(iobe);
                }
                File file = new File(parentPath, headFileName + sheetdata.getSheetName() + ".txt");
                this.writeTextFile(file, sheetdata.toString());
            }
        }
    }

    @Override
    public void tearDown() {
    }

    public String getDirectoryPath() {
        return this.directoryPath;
    }

    public void setDirectoryPath(String directoryPath) {
        this.directoryPath = directoryPath;
    }

    public String getBaseFilePath() {
        return this.baseFilePath;
    }

    public void setBaseFilePath(String baseFilePath) {
        this.baseFilePath = baseFilePath;
    }

    private void writeTextFile(File file, String fileData) throws ExportException {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(file));
            writer.write(fileData);
        }
        catch (IOException ioe) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u30d5\u30a1\u30a4\u30eb\u3092\u66f8\u304d\u8fbc\u3080\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3002");
            }
            throw new ExportException(ioe);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException ioe) {
                throw new ExportException(ioe);
            }
        }
    }
}

