/*
 * Decompiled with CFR 0.152.
 */
package org.bbreak.excella.reports.tag;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.util.PoiUtil;
import org.bbreak.excella.core.util.TagUtil;
import org.bbreak.excella.reports.model.ParamInfo;
import org.bbreak.excella.reports.model.ParsedReportInfo;
import org.bbreak.excella.reports.processor.ReportsParserInfo;
import org.bbreak.excella.reports.tag.ReportsTagParser;
import org.bbreak.excella.reports.util.ReportsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColRepeatParamParser
extends ReportsTagParser<Object[]> {
    private static Log log = LogFactory.getLog(ColRepeatParamParser.class);
    public static final String DEFAULT_TAG = "$C[]";
    public static final String PARAM_VALUE = "";
    protected static final String PARAM_DUPLICATE = "hideDuplicate";
    public static final String PARAM_REPEAT_NUM = "repeatNum";
    public static final String PARAM_SHEET_LINK = "sheetLink";
    public static final String PARAM_PROPERTY = "property";

    public ColRepeatParamParser() {
        super(DEFAULT_TAG);
    }

    public ColRepeatParamParser(String tag) {
        super(tag);
    }

    @Override
    public boolean useControlRow() {
        return false;
    }

    @Override
    public ParsedReportInfo parse(Sheet sheet, Cell tagCell, Object data) throws ParseException {
        Map paramDef = TagUtil.getParams((String)tagCell.getStringCellValue());
        this.checkParam(paramDef, tagCell);
        String tag = tagCell.getStringCellValue();
        ReportsParserInfo info = (ReportsParserInfo)data;
        ParamInfo paramInfo = info.getParamInfo();
        ParsedReportInfo parsedReportInfo = new ParsedReportInfo();
        Object[] paramValues = null;
        try {
            String replaceParam = (String)paramDef.get(PARAM_VALUE);
            Integer repeatNum = null;
            if (paramDef.containsKey(PARAM_REPEAT_NUM)) {
                repeatNum = Integer.valueOf((String)paramDef.get(PARAM_REPEAT_NUM));
            }
            boolean sheetLink = false;
            if (paramDef.containsKey(PARAM_SHEET_LINK)) {
                sheetLink = Boolean.valueOf((String)paramDef.get(PARAM_SHEET_LINK));
            }
            String propertyName = null;
            if (paramDef.containsKey(PARAM_PROPERTY)) {
                propertyName = (String)paramDef.get(PARAM_PROPERTY);
            }
            boolean hideDuplicate = false;
            if (paramDef.containsKey(PARAM_DUPLICATE)) {
                hideDuplicate = Boolean.valueOf((String)paramDef.get(PARAM_DUPLICATE));
            }
            if ("#SHEET_NAME[]".equals(replaceParam)) {
                paramValues = ReportsUtil.getSheetNames(info.getReportBook()).toArray();
            } else if ("#SHEET_VALUE[]".equals(replaceParam)) {
                paramValues = ReportsUtil.getSheetValues(info.getReportBook(), propertyName, info.getReportParsers()).toArray();
            } else if (paramInfo != null) {
                paramValues = (Object[])this.getParamData(paramInfo, replaceParam);
            }
            if (paramValues == null || paramValues.length == 0) {
                paramValues = new Object[]{null};
            }
            if (hideDuplicate && paramValues.length > 1) {
                ArrayList<Object> paramValuesList = new ArrayList<Object>();
                for (int i = 0; i <= paramValues.length - 1; ++i) {
                    if (!paramValuesList.contains(paramValues[i])) {
                        paramValuesList.add(paramValues[i]);
                        continue;
                    }
                    paramValuesList.add(null);
                }
                paramValues = paramValuesList.toArray();
            }
            int shiftNum = paramValues.length;
            int paramLength = paramValues.length;
            int defaultFromCellRowIndex = tagCell.getRowIndex();
            int defaultFromCellColIndex = tagCell.getColumnIndex();
            int unitColSize = 1;
            ArrayList<CellRangeAddress> maegedAddresses = new ArrayList<CellRangeAddress>();
            for (int i = 0; i < sheet.getNumMergedRegions(); ++i) {
                CellRangeAddress targetAddress = sheet.getMergedRegion(i);
                maegedAddresses.add(targetAddress);
            }
            if (maegedAddresses.size() > 0) {
                for (CellRangeAddress curMergedAdress : maegedAddresses) {
                    if (defaultFromCellColIndex != curMergedAdress.getFirstColumn() || defaultFromCellRowIndex != curMergedAdress.getFirstRow()) continue;
                    unitColSize = curMergedAdress.getLastColumn() - curMergedAdress.getFirstColumn() + 1;
                    shiftNum *= unitColSize;
                }
            }
            if (repeatNum != null && repeatNum < shiftNum) {
                shiftNum = repeatNum * unitColSize;
                paramLength = repeatNum;
            }
            ArrayList<Cell> cellList = new ArrayList<Cell>();
            int defaultToOverCellColIndex = tagCell.getColumnIndex() + unitColSize;
            for (int i = defaultFromCellColIndex; i < defaultToOverCellColIndex; ++i) {
                Row targetCellRow = sheet.getRow(tagCell.getRowIndex());
                cellList.add(targetCellRow.getCell(i));
            }
            if (shiftNum > 1) {
                int shiftColSize = tagCell.getColumnIndex() + shiftNum - unitColSize - 1;
                CellRangeAddress rangeAddress = new CellRangeAddress(tagCell.getRowIndex(), tagCell.getRowIndex(), tagCell.getColumnIndex(), shiftColSize);
                PoiUtil.insertRangeRight((Sheet)sheet, (CellRangeAddress)rangeAddress);
                int tagCellWidth = sheet.getColumnWidth(tagCell.getColumnIndex());
                for (int i = tagCell.getColumnIndex() + 1; i <= shiftColSize; ++i) {
                    int colWidth = sheet.getColumnWidth(i);
                    if (colWidth >= tagCellWidth) continue;
                    sheet.setColumnWidth(i, tagCellWidth);
                }
            }
            Workbook workbook = sheet.getWorkbook();
            String sheetName = workbook.getSheetName(workbook.getSheetIndex(sheet));
            List<String> sheetNames = ReportsUtil.getSheetNames(info.getReportBook());
            ArrayList<Object> resultValues = new ArrayList<Object>();
            Object beforeValue = null;
            int valueIndex = -1;
            for (int colIndex = 0; colIndex < shiftNum; ++colIndex) {
                Cell cell;
                Row row = sheet.getRow(tagCell.getRowIndex());
                if (row == null) {
                    row = sheet.createRow(tagCell.getRowIndex());
                }
                if ((cell = row.getCell(tagCell.getColumnIndex() + colIndex)) == null) {
                    cell = row.createCell(tagCell.getColumnIndex() + colIndex);
                }
                Object value = null;
                int cellIndex = colIndex % unitColSize;
                boolean skipCol = false;
                if (cellIndex != 0) {
                    skipCol = true;
                } else {
                    ++valueIndex;
                }
                PoiUtil.copyCell((Cell)((Cell)cellList.get(cellIndex)), (Cell)cell);
                Object currentValue = paramValues[valueIndex];
                boolean duplicateValue = false;
                if (beforeValue != null && currentValue != null && beforeValue.equals(currentValue)) {
                    duplicateValue = true;
                }
                if (!(skipCol || hideDuplicate && duplicateValue)) {
                    value = currentValue;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("[\u30b7\u30fc\u30c8\u540d=" + sheetName + ",\u30bb\u30eb=(" + cell.getRowIndex() + "," + cell.getColumnIndex() + ")]  " + tag + " \u21d2 " + value));
                }
                PoiUtil.setCellValue((Cell)cell, (Object)value);
                resultValues.add(value);
                if (sheetLink && !skipCol && valueIndex < sheetNames.size()) {
                    PoiUtil.setHyperlink((Cell)cell, (int)2, (String)("'" + sheetNames.get(valueIndex) + "'!A1"));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("[\u30b7\u30fc\u30c8\u540d=" + sheetName + ",\u30bb\u30eb=(" + cell.getRowIndex() + "," + cell.getColumnIndex() + ")]  Hyperlink \u21d2 " + "'" + sheetNames.get(valueIndex) + "'!A1"));
                    }
                }
                if (!skipCol && unitColSize > 1 && paramLength > valueIndex + 1) {
                    CellRangeAddress rangeAddress = new CellRangeAddress(cell.getRowIndex(), cell.getRowIndex(), cell.getColumnIndex(), cell.getColumnIndex() + unitColSize - 1);
                    sheet.addMergedRegion(rangeAddress);
                    beforeValue = value;
                }
                if (unitColSize != 1) continue;
                beforeValue = value;
            }
            parsedReportInfo.setDefaultRowIndex(tagCell.getRowIndex());
            parsedReportInfo.setDefaultColumnIndex(tagCell.getColumnIndex() + unitColSize - 1);
            parsedReportInfo.setRowIndex(tagCell.getRowIndex());
            parsedReportInfo.setColumnIndex(tagCell.getColumnIndex() + shiftNum - 1);
            parsedReportInfo.setParsedObject(resultValues);
            if (log.isDebugEnabled()) {
                log.debug((Object)parsedReportInfo);
            }
            return parsedReportInfo;
        }
        catch (Exception e) {
            throw new ParseException(tagCell, (Throwable)e);
        }
    }

    private void checkParam(Map<String, String> paramDef, Cell tagCell) throws ParseException {
        if (paramDef.containsKey(PARAM_DUPLICATE) && paramDef.containsKey(PARAM_SHEET_LINK)) {
            throw new ParseException(tagCell, "\u4e8c\u91cd\u5b9a\u7fa9\uff1ahideDuplicate,sheetLink");
        }
    }
}

