/*
 * Decompiled with CFR 0.152.
 */
package org.bbreak.excella.reports.tag;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.util.PoiUtil;
import org.bbreak.excella.core.util.TagUtil;
import org.bbreak.excella.reports.model.ParamInfo;
import org.bbreak.excella.reports.model.ParsedReportInfo;
import org.bbreak.excella.reports.processor.ReportsParserInfo;
import org.bbreak.excella.reports.tag.ReportsTagParser;
import org.bbreak.excella.reports.util.ReportsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColRepeatParamParser
extends ReportsTagParser<Object[]> {
    private static Log log = LogFactory.getLog(ColRepeatParamParser.class);
    public static final String DEFAULT_TAG = "$C[]";
    public static final String PARAM_VALUE = "";
    protected static final String PARAM_DUPLICATE = "hideDuplicate";
    public static final String PARAM_REPEAT_NUM = "repeatNum";
    public static final String PARAM_SHEET_LINK = "sheetLink";
    public static final String PARAM_PROPERTY = "property";

    public ColRepeatParamParser() {
        super(DEFAULT_TAG);
    }

    public ColRepeatParamParser(String tag) {
        super(tag);
    }

    @Override
    public boolean useControlRow() {
        return false;
    }

    @Override
    public ParsedReportInfo parse(Sheet sheet, Cell tagCell, Object data) throws ParseException {
        Map paramDef = TagUtil.getParams((String)tagCell.getStringCellValue());
        this.checkParam(paramDef, tagCell);
        String tag = tagCell.getStringCellValue();
        ReportsParserInfo info = (ReportsParserInfo)data;
        ParamInfo paramInfo = info.getParamInfo();
        ParsedReportInfo parsedReportInfo = new ParsedReportInfo();
        Object[] paramValues = null;
        try {
            String replaceParam = (String)paramDef.get(PARAM_VALUE);
            Integer repeatNum = null;
            if (paramDef.containsKey(PARAM_REPEAT_NUM)) {
                repeatNum = Integer.valueOf((String)paramDef.get(PARAM_REPEAT_NUM));
            }
            boolean sheetLink = false;
            if (paramDef.containsKey(PARAM_SHEET_LINK)) {
                sheetLink = Boolean.valueOf((String)paramDef.get(PARAM_SHEET_LINK));
            }
            String propertyName = null;
            if (paramDef.containsKey(PARAM_PROPERTY)) {
                propertyName = (String)paramDef.get(PARAM_PROPERTY);
            }
            boolean duplicate = false;
            if (paramDef.containsKey(PARAM_DUPLICATE)) {
                duplicate = Boolean.valueOf((String)paramDef.get(PARAM_DUPLICATE));
            }
            if ("#SHEET_NAME[]".equals(replaceParam)) {
                paramValues = ReportsUtil.getSheetNames(info.getReportBook()).toArray();
            } else if ("#SHEET_VALUE[]".equals(replaceParam)) {
                paramValues = ReportsUtil.getSheetValues(info.getReportBook(), propertyName, info.getReportParsers()).toArray();
            } else if (paramInfo != null) {
                paramValues = (Object[])this.getParamData(paramInfo, replaceParam);
            }
            if (paramValues == null || paramValues.length == 0) {
                paramValues = new Object[]{null};
            }
            if (duplicate && paramValues.length > 1) {
                ArrayList<Object> paramValuesList = new ArrayList<Object>();
                for (int i = 0; i <= paramValues.length - 1; ++i) {
                    if (!paramValuesList.contains(paramValues[i])) {
                        paramValuesList.add(paramValues[i]);
                        continue;
                    }
                    paramValuesList.add(null);
                }
                paramValues = paramValuesList.toArray();
            }
            int shiftNum = paramValues.length;
            if (repeatNum != null && repeatNum < shiftNum) {
                shiftNum = repeatNum;
            }
            if (shiftNum > 1) {
                CellRangeAddress rangeAddress = new CellRangeAddress(tagCell.getRowIndex(), tagCell.getRowIndex(), tagCell.getColumnIndex(), tagCell.getColumnIndex() + shiftNum - 2);
                PoiUtil.insertRangeRight((Sheet)sheet, (CellRangeAddress)rangeAddress);
                int tagCellWidth = sheet.getColumnWidth(tagCell.getColumnIndex());
                for (int i = tagCell.getColumnIndex() + 1; i <= tagCell.getColumnIndex() + shiftNum - 2; ++i) {
                    int colWidth = sheet.getColumnWidth(i);
                    if (colWidth >= tagCellWidth) continue;
                    sheet.setColumnWidth(i, tagCellWidth);
                }
            }
            Workbook workbook = sheet.getWorkbook();
            String sheetName = workbook.getSheetName(workbook.getSheetIndex(sheet));
            List<String> sheetNames = ReportsUtil.getSheetNames(info.getReportBook());
            ArrayList<Object> resultValues = new ArrayList<Object>();
            Object beforeValue = null;
            for (int i = 0; i < shiftNum; ++i) {
                Row row = sheet.getRow(tagCell.getRowIndex());
                Cell cell = row.getCell(tagCell.getColumnIndex() + i);
                if (cell == null) {
                    cell = row.createCell(tagCell.getColumnIndex() + i);
                }
                PoiUtil.copyCell((Cell)tagCell, (Cell)cell);
                Object value = null;
                if (beforeValue == null || !duplicate || !beforeValue.equals(paramValues[i])) {
                    value = paramValues[i];
                    beforeValue = paramValues[i];
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("[\u30b7\u30fc\u30c8\u540d=" + sheetName + ",\u30bb\u30eb=(" + cell.getRowIndex() + "," + cell.getColumnIndex() + ")]  " + tag + " \u21d2 " + paramValues[i]));
                }
                PoiUtil.setCellValue((Cell)cell, (Object)value);
                resultValues.add(value);
                if (!sheetLink || i >= sheetNames.size()) continue;
                PoiUtil.setHyperlink((Cell)cell, (int)2, (String)("'" + sheetNames.get(i) + "'!A1"));
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("[\u30b7\u30fc\u30c8\u540d=" + sheetName + ",\u30bb\u30eb=(" + cell.getRowIndex() + "," + cell.getColumnIndex() + ")]  Hyperlink \u21d2 " + "'" + sheetNames.get(i) + "'!A1"));
            }
            parsedReportInfo.setDefaultRowIndex(tagCell.getRowIndex());
            parsedReportInfo.setDefaultColumnIndex(tagCell.getColumnIndex());
            parsedReportInfo.setRowIndex(tagCell.getRowIndex());
            parsedReportInfo.setColumnIndex(tagCell.getColumnIndex() + shiftNum - 1);
            parsedReportInfo.setParsedObject(resultValues);
            if (log.isDebugEnabled()) {
                log.debug((Object)parsedReportInfo);
            }
            return parsedReportInfo;
        }
        catch (Exception e) {
            throw new ParseException(tagCell, (Throwable)e);
        }
    }

    private void checkParam(Map<String, String> paramDef, Cell tagCell) throws ParseException {
        if (paramDef.containsKey(PARAM_DUPLICATE) && paramDef.containsKey(PARAM_SHEET_LINK)) {
            throw new ParseException(tagCell, "\u4e8c\u91cd\u5b9a\u7fa9\uff1ahideDuplicate,sheetLink");
        }
    }
}

