/*
 * Decompiled with CFR 0.152.
 */
package org.bbreak.excella.reports.listener;

import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.bbreak.excella.core.SheetData;
import org.bbreak.excella.core.SheetParser;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.tag.TagParser;
import org.bbreak.excella.core.util.PoiUtil;
import org.bbreak.excella.core.util.TagUtil;
import org.bbreak.excella.reports.listener.ReportProcessAdaptor;
import org.bbreak.excella.reports.tag.ReportsTagParser;

public class RemoveAdapter
extends ReportProcessAdaptor {
    public static final String ROW = "row";
    public static final String COLUMN = "column";
    public static final String CELL = "cell";
    public static final String LEFT = "left";
    public static final String UP = "up";

    public void postParse(Sheet sheet, SheetParser sheetParser, SheetData sheetData) throws ParseException {
        int firstRowNum = sheet.getFirstRowNum();
        int lastRowNum = sheet.getLastRowNum();
        for (int rowIndex = firstRowNum; rowIndex <= lastRowNum; ++rowIndex) {
            Row row = sheet.getRow(rowIndex);
            if (row == null) continue;
            int firstColNum = row.getFirstCellNum();
            int lastColNum = row.getLastCellNum() - 1;
            boolean isRowFlag = false;
            for (int colIndex = firstColNum; colIndex <= lastColNum; ++colIndex) {
                Cell cell = row.getCell(colIndex);
                if (cell == null) continue;
                if (cell.getCellType() == 1 && cell.getStringCellValue().contains("$REMOVE")) {
                    String[] paramArray = this.getStrParam(sheet, rowIndex, colIndex);
                    String removeUnit = paramArray[0];
                    row.removeCell(cell);
                    if (removeUnit.equals("") || removeUnit.equals(ROW)) {
                        this.removeControlRow(sheet, rowIndex);
                        isRowFlag = true;
                        break;
                    }
                    if (removeUnit.equals(CELL) || removeUnit.equals(COLUMN)) {
                        this.removeCellOrCol(paramArray, removeUnit, sheet, row, cell, rowIndex, colIndex);
                    }
                    lastColNum = row.getLastCellNum() - 1;
                    --colIndex;
                }
                if (!this.isControlRow(sheet, sheetParser, row, cell)) continue;
                this.removeControlRow(sheet, rowIndex);
                isRowFlag = true;
                break;
            }
            if (!isRowFlag) continue;
            lastRowNum = sheet.getLastRowNum();
            --rowIndex;
        }
    }

    private String[] getStrParam(Sheet sheet, int rowIndex, int colIndex) throws ParseException {
        Row row = sheet.getRow(rowIndex);
        Cell cell = row.getCell(colIndex);
        String strValue = cell.getStringCellValue();
        String param = TagUtil.getParam((String)strValue);
        String[] paramArray = param.split(",");
        return paramArray;
    }

    private void removeCellOrCol(String[] paramArray, String removeUnit, Sheet sheet, Row row, Cell cell, int rowIndex, int colIndex) {
        block6: {
            block3: {
                block4: {
                    String direction;
                    block5: {
                        if (!removeUnit.equals(CELL)) break block3;
                        if (paramArray.length <= 1) break block4;
                        direction = paramArray[1];
                        if (!direction.equals(LEFT)) break block5;
                        this.shiftLeft(row, cell, colIndex);
                        break block6;
                    }
                    if (!direction.equals(UP)) break block6;
                    this.shiftUp(sheet, cell, rowIndex, colIndex);
                    break block6;
                }
                this.shiftLeft(row, cell, colIndex);
                break block6;
            }
            if (removeUnit.equals(COLUMN)) {
                for (int rowNum = 0; rowNum <= sheet.getLastRowNum(); ++rowNum) {
                    Cell removeCell;
                    Row removeCol = sheet.getRow(rowNum);
                    if (removeCol != null && (removeCell = removeCol.getCell(colIndex)) != null) {
                        removeCol.removeCell(removeCell);
                    }
                    this.shiftLeft(sheet.getRow(rowNum), cell, colIndex);
                }
            }
        }
    }

    private void shiftLeft(Row row, Cell cell, int colIndex) {
        int startCopyIndex = colIndex + 1;
        if (row == null) {
            return;
        }
        int finishCopyIndex = row.getLastCellNum() - 1;
        for (int copyColNum = startCopyIndex; copyColNum <= finishCopyIndex; ++copyColNum) {
            Cell fromCell = row.getCell(copyColNum);
            Cell toCell = row.getCell(copyColNum - 1);
            if (fromCell == null) continue;
            if (toCell == null) {
                toCell = row.createCell(copyColNum - 1);
            }
            PoiUtil.copyCell((Cell)fromCell, (Cell)toCell);
            row.removeCell(fromCell);
        }
    }

    private void shiftUp(Sheet sheet, Cell cell, int rowIndex, int colIndex) {
        int startCopyIndex = rowIndex + 1;
        int finishCopyIndex = sheet.getLastRowNum();
        for (int copyRowNum = startCopyIndex; copyRowNum <= finishCopyIndex; ++copyRowNum) {
            Row row = sheet.getRow(copyRowNum);
            if (row == null) continue;
            Row preRow = sheet.getRow(copyRowNum - 1);
            Cell fromCell = row.getCell(colIndex);
            if (fromCell == null) continue;
            Cell toCell = null;
            if (preRow == null) {
                preRow = sheet.createRow(copyRowNum - 1);
            }
            if ((toCell = preRow.getCell(colIndex)) == null) {
                toCell = preRow.createCell(colIndex);
            }
            PoiUtil.copyCell((Cell)fromCell, (Cell)toCell);
            row.removeCell(fromCell);
        }
    }

    private void removeControlRow(Sheet sheet, int rowIndex) {
        if (rowIndex == sheet.getLastRowNum()) {
            sheet.removeRow(sheet.getRow(rowIndex));
        } else {
            sheet.removeRow(sheet.getRow(rowIndex));
            sheet.shiftRows(rowIndex + 1, sheet.getLastRowNum(), -1);
        }
    }

    private boolean isControlRow(Sheet sheet, SheetParser sheetParser, Row row, Cell cell) {
        List parsers = sheetParser.getTagParsers();
        for (TagParser parser : parsers) {
            try {
                ReportsTagParser reportsTagParser;
                if (!parser.isParse(sheet, cell) || !(parser instanceof ReportsTagParser) || !(reportsTagParser = (ReportsTagParser)parser).useControlRow()) continue;
                return true;
            }
            catch (ParseException e) {
            }
        }
        return false;
    }
}

