package org.bbreak.excella.reports.others;

import static org.junit.Assert.fail;

import java.io.File;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;

import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.bbreak.excella.reports.ReportsTestUtil;
import org.bbreak.excella.reports.exporter.ExcelExporter;
import org.bbreak.excella.reports.model.ReportBook;
import org.bbreak.excella.reports.model.ReportSheet;
import org.bbreak.excella.reports.processor.ReportProcessor;
import org.bbreak.excella.reports.processor.ReportsCheckException;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

/**
 * ev[gV[gRs[̈ݒmF̂߂̃eXgNX
 * 
 * @since 1.0
 */
public class PrintSettingCopyTest {

    /**
     * ev[gV[g̃V[gRs[
     */
    private static final Integer SINGLE_COPY_NUM_OF_SHETTS = 3;

    /**
     * ev[g̏ꍇ1ڂ̃ev[gV[g̃Rs[
     */
    private static final Integer PLURAL_COPY_FIRST_NUM_OF_SHEETS = 3;

    /**
     * ev[g̏ꍇ2ڂ̃ev[gV[g̃Rs[
     */
    private static final Integer PLURAL_COPY_SECOND_NUM_OF_SHEETS = 4;

    /**
     * @throws java.lang.Exception
     */
    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    /**
     * @throws java.lang.Exception
     */
    @Before
    public void setUp() throws Exception {
    }

    /**
     * ݒt̃Rs[eXgAt@Co͂܂
     */
    @Test
    public void testCopyOfPrintSetting() throws Exception {
        // ݒtev[gɏ㏑Ńt@Co
        printWithPrintSetting( false);
        // ݒtev[gRs[ăt@Co
        printWithPrintSetting( true);
        // ݒtev[g𕡐V[gRs[ăt@Co
        printPluralWithPrintSetting( true);
        // ݒtev[g2V[geXV[gRs[ăt@Co
        printPluralWithPrintSetting( false);
    }

    private static void printWithPrintSetting( boolean copyTemplate) throws Exception {
        // Excel 2003`
        printExcel( "ݒLev[g.xls", copyTemplate);
        // Excel 2007`
        printExcel( "ݒLev[g.xlsx", copyTemplate);
    }

    private static void printPluralWithPrintSetting( boolean singleTempSheet) throws Exception {
        // Excel 2003`ŏo
        if ( singleTempSheet) {
            printPluralExcel( "ݒLev[g.xls", singleTempSheet);
        } else {
            printPluralExcel( "ݒLev[g.xls", singleTempSheet);
        }
        // Excel 2007`ŏo
        if ( singleTempSheet) {
            printPluralExcel( "ݒLev[g.xlsx", singleTempSheet);
        } else {
            printPluralExcel( "ݒLev[g.xlsx", singleTempSheet);
        }
    }

    private static void printExcel( String templateFileName, boolean copyTemplate) throws Exception {
        // ReportBook̐
        ReportBook outputBook = null;
        if ( copyTemplate) {
            outputBook = createReportBook( templateFileName, "Print_Setting_Copy_Template");
        } else {
            outputBook = createReportBook( templateFileName, "Print_Setting_Overwrite_Template");
        }
        // ReportSheet̃Zbg
        setReportSheet( outputBook, copyTemplate);
        // V[gRs[̈ݒ̔fmF
        Workbook workbook = getTemplateWorkbook( outputBook.getTemplateFileName());
        templateCopyTest( workbook, outputBook);
        // Processor̎s
        executeProcessor( new ReportProcessor(), outputBook);
    }

    private static void printPluralExcel( String templateFileName, boolean singleTempSheet) throws Exception {
        // ReportBook̐
        ReportBook outputBook = null;
        if ( singleTempSheet) {
            outputBook = createReportBook( templateFileName, "Print_Setting_Single_Template_Plural_Copy");
        } else {
            outputBook = createReportBook( templateFileName, "Print_Setting_Plural_Template_Plural_Copy");
        }
        // ReportSheet̃Zbg()
        setReportSheets( singleTempSheet, outputBook);
        // V[gRs[̈ݒ̔fmF
        Workbook workbook = getTemplateWorkbook( outputBook.getTemplateFileName());
        templateCopyTest( workbook, outputBook);
        // Processor̎s
        executeProcessor( new ReportProcessor(), outputBook);
    }

    private static void setReportSheet( ReportBook outputBook, boolean copyTemplate) throws Exception {
        ReportSheet outputSheet = null;
        if ( copyTemplate) {
            outputSheet = new ReportSheet( "", "Rs[");
        } else {
            outputSheet = new ReportSheet( "");
        }
        // ubNɃV[gZbg
        outputBook.addReportSheet( outputSheet);
    }

    private static void setReportSheets( boolean singleTempSheet, ReportBook outputBook) throws Exception {
        if ( singleTempSheet) {
            for ( int i = 1; i <= SINGLE_COPY_NUM_OF_SHETTS; i++) {
                ReportSheet outputSheet = new ReportSheet( "", "Rs[" + i);
                // ubNɃV[gZbg
                outputBook.addReportSheet( outputSheet);
            }
        } else {
            for ( int i = 1; i <= PLURAL_COPY_FIRST_NUM_OF_SHEETS; i++) {
                ReportSheet outputSheet = new ReportSheet( "A", "ARs[" + i);
                // ubNɃV[gZbg
                outputBook.addReportSheet( outputSheet);
            }
            int start = PLURAL_COPY_FIRST_NUM_OF_SHEETS + 1;
            int end = PLURAL_COPY_FIRST_NUM_OF_SHEETS + PLURAL_COPY_SECOND_NUM_OF_SHEETS;
            for ( int i = start; i <= end; i++) {
                ReportSheet outputSheet = new ReportSheet( "B", "BRs[" + i);
                // ubNɃV[gZbg
                outputBook.addReportSheet( outputSheet);
            }
        }
    }

    private static void executeProcessor( ReportProcessor reportProcessor, ReportBook outputBook) throws Exception {
        reportProcessor.process( outputBook);
    }

    private static ReportBook createReportBook( String templateFileName, String outputFileName) throws UnsupportedEncodingException {
        String templateFilePath = getTemplateFilePath( templateFileName);
        String tmpDirPath = System.getProperty( "user.dir") + "/work/test/";
        File file = new File( tmpDirPath);
        if ( !file.exists()) {
            file.mkdirs();
        }
        String outputFilePath = tmpDirPath.concat( outputFileName);
        ReportBook outputBook = new ReportBook( templateFilePath, outputFilePath, ExcelExporter.FORMAT_TYPE);
        return outputBook;
    }

    private static String getTemplateFilePath( String templateFileName) throws UnsupportedEncodingException {
        URL templateFileUrl = PrintSettingCopyTest.class.getResource( templateFileName);
        String templateFilePath = URLDecoder.decode( templateFileUrl.getPath(), "UTF-8");
        return templateFilePath;
    }

    private static void templateCopyTest( Workbook workbook, ReportBook reportBook) {
        // o̓V[gPʂɃRs[
        for ( ReportSheet reportSheet : reportBook.getReportSheets()) {
            if ( reportSheet != null) {
                if ( !reportSheet.getSheetName().equals( reportSheet.getTemplateName())) {
                    // ev[g ! o̓V[g
                    int tempIdx = workbook.getSheetIndex( reportSheet.getTemplateName());
                    Sheet expectedSheet = workbook.getSheetAt( tempIdx);
                    Sheet actualSheet = workbook.cloneSheet( tempIdx);
                    try {
                        ReportsTestUtil.checkSheet( expectedSheet, actualSheet, true);
                    } catch ( ReportsCheckException e) {
                        fail( e.getCheckMessagesToString());
                    }
                }
            }
        }
    }

    private static Workbook getTemplateWorkbook( String filepath) throws Exception {
        FileInputStream fileIn = null;
        Workbook wb = null;

        try {
            fileIn = new FileInputStream( filepath);
            wb = WorkbookFactory.create( fileIn);
        } finally {
            if ( fileIn != null) {
                fileIn.close();
            }
        }

        return wb;
    }
}
