/*
 * Decompiled with CFR 0.152.
 */
package org.bbreak.excella.core.handler;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.handler.ParseErrorHandler;
import org.bbreak.excella.core.util.PoiUtil;

public class DebugErrorHandler
implements ParseErrorHandler {
    private static Log log = LogFactory.getLog(DebugErrorHandler.class);
    private String errorFilePath = null;

    public void notifyException(Workbook workbook, Sheet sheet, ParseException exception) {
        String resultFileName;
        Cell errorCell;
        boolean isXssf = false;
        if (exception != null && (errorCell = exception.getCell()) != null) {
            workbook.setActiveSheet(workbook.getSheetIndex(errorCell.getSheet()));
            errorCell.setAsActiveCell();
            if (workbook instanceof XSSFWorkbook) {
                isXssf = true;
                XSSFWorkbook xssfWorkbook = (XSSFWorkbook)workbook;
                XSSFCellStyle errorCellStyle = xssfWorkbook.createCellStyle();
                errorCellStyle.setFillForegroundColor((short)10);
                errorCellStyle.setFillPattern((short)1);
                errorCell.setCellStyle((CellStyle)errorCellStyle);
            } else {
                HSSFWorkbook hssfWorkbook = (HSSFWorkbook)workbook;
                HSSFCellStyle errorCellStyle = hssfWorkbook.createCellStyle();
                errorCellStyle.setFillForegroundColor((short)10);
                errorCellStyle.setFillPattern((short)1);
                errorCell.setCellStyle((CellStyle)errorCellStyle);
            }
        }
        if ((resultFileName = this.errorFilePath) == null) {
            resultFileName = "./" + System.currentTimeMillis();
            resultFileName = isXssf ? resultFileName + ".xlsx" : resultFileName + ".xls";
        }
        try {
            PoiUtil.writeBook(workbook, resultFileName);
            System.out.println("\n" + resultFileName + "\u306b\u30a8\u30e9\u30fc\u30d5\u30a1\u30a4\u30eb\u3092\u751f\u6210\u3057\u307e\u3057\u305f");
        }
        catch (Exception e) {
            log.warn((Object)"\u30a8\u30e9\u30fc\u30d5\u30a1\u30a4\u30eb\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f", (Throwable)e);
        }
    }

    public String getErrorFilePath() {
        return this.errorFilePath;
    }

    public void setErrorFilePath(String errorFilePath) {
        this.errorFilePath = errorFilePath;
    }
}

