/*
 * Decompiled with CFR 0.152.
 */
package org.bbreak.excella.core.util;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class TagUtil {
    private TagUtil() {
    }

    public static Map<String, String> getParams(String tagDef) {
        HashMap<String, String> params = new HashMap<String, String>();
        String paramDef = TagUtil.getParam(tagDef);
        if (paramDef == null) {
            return params;
        }
        StringTokenizer commaTokenizer = new StringTokenizer(paramDef, ",");
        while (commaTokenizer.hasMoreTokens()) {
            String keyValue = commaTokenizer.nextToken();
            if (keyValue.indexOf("=") == -1) {
                params.put("", keyValue);
                continue;
            }
            StringTokenizer eqTokenizer = new StringTokenizer(keyValue, "=");
            while (eqTokenizer.hasMoreTokens()) {
                params.put(eqTokenizer.nextToken(), eqTokenizer.nextToken());
            }
        }
        return params;
    }

    public static String getParam(String tagDef) {
        return TagUtil.getParam(tagDef, "{", "}");
    }

    public static String getParam(String tagDef, String tagParamPrefix, String tagParamSuffix) {
        String param = null;
        int paramStartIdx = tagDef.indexOf(tagParamPrefix) + 1;
        int paramEndIdx = tagDef.lastIndexOf(tagParamSuffix);
        if (paramStartIdx == 0) {
            return param;
        }
        param = tagDef.substring(paramStartIdx, paramEndIdx);
        return param;
    }

    public static String getTag(String tagDef) {
        return TagUtil.getTag(tagDef, "{");
    }

    public static String getTag(String tagDef, String tagParamPrefix) {
        int paramStartIdx = tagDef.indexOf(tagParamPrefix);
        if (paramStartIdx == -1) {
            return tagDef;
        }
        return tagDef.substring(0, paramStartIdx);
    }

    public static int adjustValue(int baseValue, Map<String, String> paramMap, String paramKey, int defaultAdjust) {
        int adjustValue = baseValue;
        if (paramMap.containsKey(paramKey)) {
            String value = paramMap.get(paramKey);
            adjustValue += Integer.valueOf(value).intValue();
        } else {
            adjustValue += defaultAdjust;
        }
        return adjustValue;
    }
}

