/**
 * 
 */
package net.seesaa.kyoto.uml.sequence.wizard;

import java.util.ArrayList;
import java.util.List;

import net.seesaa.kyoto.uml.sequence.Activation;
import net.seesaa.kyoto.uml.sequence.Diagram;
import net.seesaa.kyoto.uml.sequence.MessageType;
import net.seesaa.kyoto.uml.sequence.ObjectModel;
import net.seesaa.kyoto.uml.sequence.ReceiveAnchor;
import net.seesaa.kyoto.uml.sequence.SequencePlugin;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;

/**
 * @author shida
 *
 */
public class LayoutOrderPage extends WizardPage {

	private Diagram diagram;
	
	private List<ObjectModel> order = new ArrayList<ObjectModel>();
	
	public static final Image IMAGE = ImageDescriptor.createFromFile(SequencePlugin.class, "icon/object_model.gif").createImage();

	protected LayoutOrderPage(String pageName, Diagram diagram) {
		super(pageName);
		this.diagram = diagram;
		initModel();
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createControl(Composite parent) {
		setTitle("CAEgݒ");
		setDescription("CAEg̏Ԃݒ肵܂B\nȂƂЂƂ̓[gɂȂIuWFNgƃCAEgł܂B");
		setControl(new OrderConfigPanel(parent, SWT.NONE));
	}
	
	@SuppressWarnings("unchecked")
	private void initModel() {
		List<ObjectModel> models = diagram.getContents();
		for (ObjectModel model : models) {
			boolean root = true;
			List<Activation> activations = model.getActivations();
			for (Activation activation : activations) {
				List<ReceiveAnchor> anchors = activation.getIncoming();
				for (ReceiveAnchor anchor : anchors) {
					if (!(anchor.getIncoming().getType().equals(MessageType.get(MessageType.RECEIVE)))) {
						root = false;
					}
				}
			}
			if (root) {
				order.add(model);
			}
		}
	}
	
	public Diagram getModel() {
		return diagram;
	}
	
	public List<ObjectModel> getOrder() {
		return order;
	}
	
	class OrderConfigPanel extends Composite {

		private Tree leftTree = null;
		private Composite composite = null;
		private Button upButton = null;
		private Button downButton = null;
		
		private TreeViewer viewer = null;
		
		/**
		 * This method initializes leftTree	
		 *
		 */
		private void createLeftTree() {
			GridData gridData = new GridData();
			gridData.grabExcessVerticalSpace = true;
			gridData.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
			gridData.verticalAlignment = org.eclipse.swt.layout.GridData.FILL;
			gridData.grabExcessHorizontalSpace = true;
			leftTree = new Tree(this, SWT.NONE);
			leftTree.setLayoutData(gridData);
			viewer = new TreeViewer(leftTree);
			viewer.setContentProvider(new TreeContentProvider());
			viewer.setLabelProvider(new LabelProvider() {
				@Override
				public String getText(Object element) {
					ObjectModel model = (ObjectModel) element;
					return model.getName() != null ? model.getName() : "";
				}
				
				@Override
				public Image getImage(Object element) {
					return IMAGE;
				}
			});
			viewer.setInput(order);
		}

		/**
		 * This method initializes composite	
		 *
		 */
		private void createComposite() {
			RowLayout rowLayout = new RowLayout();
			rowLayout.type = org.eclipse.swt.SWT.VERTICAL;
			rowLayout.fill = true;
			GridData gridData2 = new GridData();
			gridData2.grabExcessVerticalSpace = true;
			gridData2.verticalAlignment = org.eclipse.swt.layout.GridData.FILL;
			composite = new Composite(this, SWT.NONE);
			composite.setLayoutData(gridData2);
			composite.setLayout(rowLayout);
			upButton = new Button(composite, SWT.NONE);
			upButton.setText("UP");
			upButton.addSelectionListener(new SelectionAdapter(){
				@Override
				public void widgetSelected(SelectionEvent e) {
					ISelection selection = viewer.getSelection();
					if (selection instanceof IStructuredSelection) {
						IStructuredSelection structuredSelection = (IStructuredSelection) selection;
						ObjectModel model = (ObjectModel) structuredSelection.getFirstElement();
						int index = order.indexOf(model);
						if (index > 0) {
							index --;
							order.remove(model);
							order.add(index, model);
						}
					}
					viewer.refresh();
				}
			});
			downButton = new Button(composite, SWT.NONE);
			downButton.setText("Down");
			downButton.addSelectionListener(new SelectionAdapter(){
			@Override
			public void widgetSelected(SelectionEvent e) {
				ISelection selection = viewer.getSelection();
				if (selection instanceof IStructuredSelection) {
					IStructuredSelection structuredSelection = (IStructuredSelection) selection;
					ObjectModel model = (ObjectModel) structuredSelection.getFirstElement();
					int index = order.indexOf(model);
					if (index < order.size() - 1) {
						index ++;
						order.remove(model);
						order.add(index, model);
					}
				}
				viewer.refresh();
			}
			});
		}
		
		public OrderConfigPanel(Composite parent, int style) {
			super(parent, style);
			initialize();
		}

		private void initialize() {
			GridLayout gridLayout = new GridLayout();
			gridLayout.numColumns = 2;
			this.setLayout(gridLayout);
			createLeftTree();
			createComposite();
		}

	}

	class TreeContentProvider extends ArrayContentProvider implements ITreeContentProvider {

		public Object[] getChildren(Object parentElement) {
			return getElements(parentElement);
		}

		public Object getParent(Object element) {
			return null;
		}

		public boolean hasChildren(Object element) {
			return false;
		}		
	}
}
