/**
 * 
 */
package net.seesaa.kyoto.uml.sequence.util;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import net.seesaa.kyoto.uml.sequence.Activation;
import net.seesaa.kyoto.uml.sequence.MessageType;
import net.seesaa.kyoto.uml.sequence.ReceiveAnchor;
import net.seesaa.kyoto.uml.sequence.SendAnchor;
import net.seesaa.kyoto.uml.sequence.command.AutoResizeCommand;
import net.seesaa.kyoto.uml.sequence.command.MoveReturnMessageCommand;

import org.eclipse.gef.commands.Command;

/**
 * @author shida
 *
 */
public class SequenceUtil {

	private SequenceUtil() {}

	@SuppressWarnings("unchecked")
	public static Set<Activation> getChildRelationActivations(Activation a) {
		Set<Activation> rv = new HashSet<Activation>(); 
		addChildActivation(a, rv);
		return rv;
	}
	
	@SuppressWarnings("unchecked")
	private static void addChildActivation(Activation a, Set<Activation> set) {
		List<SendAnchor> source = a.getOutgoing();
		for (SendAnchor anchor : source) {
			Activation activation = anchor.getOutgoing().getTarget().getOwner();
			if (!set.contains(activation)) {
				set.add(activation);
				addChildActivation(activation, set);				
			}
		}
	}
	
	public static Set<Activation> getParentRelationActivations(Activation a) {
		Set<Activation> rv = new HashSet<Activation>();
		addParentActivation(a, rv);
		return rv;
	}
	
	@SuppressWarnings("unchecked")
	private static void addParentActivation(Activation a, Set<Activation> set) {
		List<ReceiveAnchor> source = a.getIncoming();
		for (ReceiveAnchor anchor : source) {
			Activation activation = anchor.getIncoming().getSource().getOwner();
			if (!set.contains(activation)) {
				set.add(activation);
				addParentActivation(activation, set);				
			}
		}
	}
	
	@SuppressWarnings("unchecked")
	public static int getMaximunDelta(Activation a) {
		int rv = Integer.MAX_VALUE;
		List<ReceiveAnchor> receiveAnchor = a.getIncoming();
		for (ReceiveAnchor anchor : receiveAnchor) {
			SendAnchor sendAnchor = anchor.getIncoming().getSource();
			Activation source = sendAnchor.getOwner();
			int delta = source.getHeight() - sendAnchor.getPosition();
			if (rv > delta) {
				rv = delta;
			}
		}
		return rv;
	}
	
	@SuppressWarnings("unchecked")
	public static int getMinimumDelta(Activation a) {
		int rv = Integer.MIN_VALUE;
		List<ReceiveAnchor> receiveAnchor = a.getIncoming();
		for (ReceiveAnchor anchor : receiveAnchor) {
			SendAnchor sendAnchor = anchor.getIncoming().getSource();
			int delta = - sendAnchor.getPosition();
			if (rv < delta) {
				rv = delta;
			}
		}
		return rv;
		
	}
		
	@SuppressWarnings("unchecked")
	private static Command createAutoResizeCommand(Command parent, Activation model, Activation caller) {
		Command c = parent.chain(new AutoResizeCommand(model, caller));
		List<SendAnchor> anchors = model.getOutgoing();
		for (SendAnchor anchor : anchors) {
			if (anchor.getOutgoing().getType().equals(MessageType.get(MessageType.RECEIVE))) {
				return createMoveReturnCommand(c, anchor);
			}
		}
		return c;
	}
	
	/**
	 * ReturnbZ[WɊԂ̍Ōɒu.
	 * @param parent
	 * @param anchor
	 * @return
	 */
	public static Command createMoveReturnCommand(Command parent, SendAnchor anchor) {
		Command c = parent.chain(new MoveReturnMessageCommand(anchor));
		if (anchor.getOutgoing() == null) {
			return parent;
		}
		return createAutoResizeCommand(c, anchor.getOutgoing().getTarget().getOwner(), anchor.getOwner());
	}
	/**
	 * bZ[WvZ.
	 * @param activation
	 */
	public static void computeMessageOrder(Activation activation) {
		
	}
}
