package net.seesaa.kyoto.uml.sequence.util;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class EcoreModelUtil {

	public static final String[] ATTRIBUTES = new String[] { "name", "message" };
	
	public static String getStringValue(EObject obj) {
		EStructuralFeature feature = getStringFeature(obj);
		if (feature != null) {
			return (String) (obj.eGet(feature) != null ? obj.eGet(feature) : "");
		}
		return "";
	}
	
	public static EStructuralFeature getStringFeature(EObject obj) {
		for (String s : ATTRIBUTES) {
			EStructuralFeature feature = obj.eClass().getEStructuralFeature(s);
			if (feature != null) {
				return feature;
			}
		}
		return null;
	}
}
