package net.seesaa.kyoto.uml.sequence.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;

import net.seesaa.kyoto.uml.sequence.Diagram;
import net.seesaa.kyoto.uml.sequence.Message;
import net.seesaa.kyoto.uml.sequence.MessageType;
import net.seesaa.kyoto.uml.sequence.SequenceFactory;
import net.seesaa.kyoto.uml.sequence.SequencePackage;
import net.seesaa.kyoto.uml.sequence.SequencePlugin;
import net.seesaa.kyoto.uml.sequence.actions.LayoutTestAction;
import net.seesaa.kyoto.uml.sequence.editpart.SequenceEditPartFactory;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.ConnectionCreationToolEntry;
import org.eclipse.gef.palette.CreationToolEntry;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PaletteStack;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.AlignmentAction;
import org.eclipse.gef.ui.actions.DirectEditAction;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.parts.GraphicalEditorWithPalette;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class SequenceDiagramEditor extends GraphicalEditorWithPalette {

	private ResourceSet resourceSet = new ResourceSetImpl();

	private Diagram sequence;

	private Resource resource;

	public Diagram getSequence() {
		return sequence;
	}

	public static SequenceDiagramEditor getActivityDiagramEditor() {
		IEditorPart editorPart = PlatformUI.getWorkbench()
				.getActiveWorkbenchWindow().getActivePage().getActiveEditor();
		if (editorPart instanceof SequenceDiagramEditor) {
			return (SequenceDiagramEditor) editorPart;
		}
		return null;
	}

	public SequenceDiagramEditor() {
		super();
		setEditDomain(new DefaultEditDomain(this));
	}

	@Override
	protected PaletteRoot getPaletteRoot() {
		PaletteRoot root = new PaletteRoot();
		PaletteGroup group = new PaletteGroup("{"); //$NON-NLS-1$

		ToolEntry tool = new SelectionToolEntry();
		group.add(tool);
		root.setDefaultEntry(tool);

		tool = new MarqueeToolEntry();
		group.add(tool);

		root.add(group);

		PaletteDrawer drawer = new PaletteDrawer("IuWFNg");

		EcoreModelFactory factory = null;
		CreationToolEntry entry = null;

		factory = new EcoreModelFactory(SequencePackage.eINSTANCE.getActor());
		entry = new CombinedTemplateCreationEntry("AN^[", "AN^[", factory,
				factory, ImageDescriptor.createFromFile(SequencePlugin.class,
						"icon/actor16.gif"), ImageDescriptor.createFromFile(
						SequencePlugin.class, "icon/actor16.gif"));
		drawer.add(entry);

		factory = new EcoreModelFactory(SequencePackage.eINSTANCE
				.getObjectModel());
		entry = new CombinedTemplateCreationEntry("IuWFNg", "IuWFNg", factory,
				factory, ImageDescriptor.createFromFile(SequencePlugin.class,
						"icon/object_model.gif"), ImageDescriptor
						.createFromFile(SequencePlugin.class,
								"icon/object_model.gif"));
		drawer.add(entry);

		factory = new EcoreModelFactory(SequencePackage.eINSTANCE
				.getActivation());
		entry = new CombinedTemplateCreationEntry("", "", factory,
				factory, ImageDescriptor.createFromFile(SequencePlugin.class,
						"icon/activation.gif"), ImageDescriptor.createFromFile(
						SequencePlugin.class, "icon/activation.gif"));
		drawer.add(entry);

		ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
		factory = new EcoreModelFactory(SequencePackage.eINSTANCE.getComment());
		entry = new CombinedTemplateCreationEntry("Rg", "Rg", factory,
				factory, images.getImageDescriptor(ISharedImages.IMG_OBJ_FILE),
				images.getImageDescriptor(ISharedImages.IMG_OBJ_FILE));
		drawer.add(entry);

		root.add(drawer);

		drawer = new PaletteDrawer("bZ[W");
		PaletteStack stack = new PaletteStack("bZ[W", "e탁bZ[W", null);
		factory = new EcoreModelFactory(SequencePackage.eINSTANCE.getMessage());
		entry = new ConnectionCreationToolEntry("bZ[W", "bZ[W", factory,
				ImageDescriptor.createFromFile(SequencePlugin.class,
						"icon/msg_sync.gif"), ImageDescriptor.createFromFile(
						SequencePlugin.class, "icon/msg_sync.gif"));
		stack.add(0, entry);

		factory = new EcoreModelFactory(SequencePackage.eINSTANCE.getMessage()) {
			@Override
			public Object getNewObject() {
				Message message = (Message) super.getNewObject();
				message.setType(MessageType.get(MessageType.ASYNC));
				return message;
			}
		};
		entry = new ConnectionCreationToolEntry("񓯊bZ[W", "񓯊bZ[W",
				factory, ImageDescriptor.createFromFile(SequencePlugin.class,
						"icon/msg_async.gif"), ImageDescriptor.createFromFile(
						SequencePlugin.class, "icon/msg_async.gif"));
		stack.add(1, entry);

		factory = new EcoreModelFactory(SequencePackage.eINSTANCE.getMessage()) {
			@Override
			public Object getNewObject() {
				Message message = (Message) super.getNewObject();
				message.setType(MessageType.get(MessageType.RECEIVE));
				return message;
			}
		};
		entry = new ConnectionCreationToolEntry("ԋpbZ[W", "ԋpbZ[W", factory,
				ImageDescriptor.createFromFile(SequencePlugin.class,
						"icon/msg_return.gif"), ImageDescriptor.createFromFile(
						SequencePlugin.class, "icon/msg_return.gif"));
		stack.add(2, entry);

		drawer.add(stack);

		root.add(drawer);
		return root;
	}

	@SuppressWarnings("unchecked")
	@Override
	protected void setInput(IEditorInput input) {
		super.setInput(input);

		IFile file = ((IFileEditorInput) input).getFile();

		// try {
		// loadContent(file.getParent());
		// } catch (CoreException e) {
		// // TODO Auto-generated catch block
		// e.printStackTrace();
		// }
		URI uri = URI.createPlatformResourceURI(file.getFullPath().toString());

		try {
			resource = resourceSet.getResource(uri, true);
		} catch (RuntimeException e) {
			SequencePlugin.getDefault().getLog().log(
					new Status(IStatus.INFO, SequencePlugin.class.getName(), 0,
							"EMFfł͂Ȃ悤Ȃ̂ŁAVɃf쐬܂.", e));
			resource = resourceSet.createResource(uri);
		}
		if (resource.getContents().isEmpty()) {
			sequence = SequenceFactory.eINSTANCE.createDiagram();
			resource.getContents().add(sequence);
		} else {
			sequence = (Diagram) resource.getContents().get(0);
		}
		setPartName(file.getName());
	}

	@Override
	protected void initializeGraphicalViewer() {
		GraphicalViewer viewer = getGraphicalViewer();
		viewer.setContents(sequence);
	}

	@Override
	public void doSave(IProgressMonitor monitor) {
		Map<String, String> map = new HashMap<String, String>();
		map.put(XMLResource.OPTION_ENCODING, "UTF-8");
		try {
			resource.save(map);
		} catch (IOException e) {
			e.printStackTrace();
		}
		getCommandStack().markSaveLocation();
	}

	public void commandStackChanged(EventObject event) {
		firePropertyChange(IEditorPart.PROP_DIRTY);
		super.commandStackChanged(event);
	}

	public void execute(Command c) {
		getCommandStack().execute(c);
	}

	@Override
	public boolean isDirty() {
		return getCommandStack().isDirty();
	}

	@Override
	public void doSaveAs() {
		doSave(null);
	}

	@Override
	public boolean isSaveAsAllowed() {
		return true;
	}

	@SuppressWarnings("unchecked")
	protected void configureGraphicalViewer() {
		super.configureGraphicalViewer();
		GraphicalViewer viewer = getGraphicalViewer();
		ScalableRootEditPart root = new ScalableRootEditPart();
		viewer.setRootEditPart(root);
		viewer.setEditPartFactory(new SequenceEditPartFactory());
		getGraphicalViewer().setKeyHandler(
				new GraphicalViewerKeyHandler(getGraphicalViewer()) {
					@Override
					public boolean keyPressed(KeyEvent event) {
						if (event.keyCode == 13) {
							getFocusEditPart().performRequest(
									new DirectEditRequest());
						}
						return super.keyPressed(event);
					}
				});
		ZoomManager manager = root.getZoomManager();

		double[] zoomLevels = new double[] { 0.25, 0.5, 0.75, 1.0, 1.5, 2.0,
				2.5, 3.0, 4.0, 5.0, 10.0, 20.0 };
		manager.setZoomLevels(zoomLevels);
		ArrayList zoomContributions = new ArrayList();
		zoomContributions.add(ZoomManager.FIT_ALL);
		zoomContributions.add(ZoomManager.FIT_HEIGHT);
		zoomContributions.add(ZoomManager.FIT_WIDTH);
		manager.setZoomLevelContributions(zoomContributions);

		IAction action = new ZoomInAction(manager);
		getActionRegistry().registerAction(action);
		action = new ZoomOutAction(manager);
		getActionRegistry().registerAction(action);
		LayoutTestAction testAction = new LayoutTestAction(this);
		getActionRegistry().registerAction(testAction);
		System.out.println(testAction.getId());
		getGraphicalViewer().setContextMenu(
				new SequenceDiagramEditorContextMenuProvider(
						getGraphicalViewer(), getActionRegistry()));
	}

	public EditPart getEditPart(Point location) {
		return getGraphicalViewer().findObjectAt(location);
	}

	@SuppressWarnings("unchecked")
	@Override
	protected void createActions() {
		super.createActions();
		ActionRegistry registry = getActionRegistry();

		IAction action = new DirectEditAction((IWorkbenchPart) this);
		registry.registerAction(action);

		getSelectionActions().add(action.getId());

		action = new AlignmentAction((IWorkbenchPart) this,
				PositionConstants.LEFT);
		registry.registerAction(action);
		getSelectionActions().add(action.getId());

		action = new AlignmentAction((IWorkbenchPart) this,
				PositionConstants.CENTER);
		registry.registerAction(action);
		getSelectionActions().add(action.getId());

		action = new AlignmentAction((IWorkbenchPart) this,
				PositionConstants.RIGHT);
		registry.registerAction(action);
		getSelectionActions().add(action.getId());

		action = new AlignmentAction((IWorkbenchPart) this,
				PositionConstants.TOP);
		registry.registerAction(action);
		getSelectionActions().add(action.getId());

		action = new AlignmentAction((IWorkbenchPart) this,
				PositionConstants.MIDDLE);
		registry.registerAction(action);
		getSelectionActions().add(action.getId());

		action = new AlignmentAction((IWorkbenchPart) this,
				PositionConstants.BOTTOM);
		registry.registerAction(action);
		getSelectionActions().add(action.getId());
	}

	@Override
	public Object getAdapter(Class type) {
		// if (type == IPropertySheetPage.class) {
		// PropertySheetPage page = new PropertySheetPage();
		// PropertySheetEntry entry = new PropertySheetEntry() {
		// @Override
		// protected IPropertySource getPropertySource(Object object) {
		// if (object instanceof EditPart
		// && !(object instanceof RootEditPart)) {
		// Object model = ((EditPart) object).getModel();
		// return super.getPropertySource(model);
		// }
		// return super.getPropertySource(object);
		// }
		//				
		// };
		// entry.setPropertySourceProvider(new AdapterFactoryContentProvider(
		// new SequenceItemProviderAdapterFactory()));
		// page.setRootEntry(entry);
		// return page;
		// // return new TabbedPropertySheetPage(this);
		// }

		if (type == ZoomManager.class)
			return ((ScalableRootEditPart) getGraphicalViewer()
					.getRootEditPart()).getZoomManager();

		return super.getAdapter(type);
	}

}
