/**
 * 
 */
package net.seesaa.kyoto.uml.sequence.policy;

import net.seesaa.kyoto.uml.sequence.figure.ActorFigure;
import net.seesaa.kyoto.uml.sequence.figure.ObjectModelFigure;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Text;

/**
 * @author shida
 *
 */
public class ObjectModelCellEditorLocator implements CellEditorLocator {

	private IFigure figure;
	
	
	/**
	 * @param figure
	 */
	public ObjectModelCellEditorLocator(IFigure figure) {
		super();
		this.figure = figure;
	}


	/* (non-Javadoc)
	 * @see org.eclipse.gef.tools.CellEditorLocator#relocate(org.eclipse.jface.viewers.CellEditor)
	 */
	public void relocate(CellEditor celleditor) {
	    Text text = (Text) celleditor.getControl();
	    Rectangle rect = figure.getBounds().getCopy();
	    figure.translateToAbsolute(rect);
	    if (figure instanceof ObjectModelFigure) {
		    text.setBounds(rect.x + 25, rect.y + 5, rect.width, 16);	    	
	    } else if (figure instanceof ActorFigure) {
		    text.setBounds(rect.x + 5, rect.y + 32, rect.width, 16);	    		    	
	    }
	}

}
