/*
 * Created on 2005/06/06
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package net.seesaa.kyoto.uml.sequence.policy;

import net.seesaa.kyoto.uml.sequence.Activation;
import net.seesaa.kyoto.uml.sequence.Message;
import net.seesaa.kyoto.uml.sequence.MessageType;
import net.seesaa.kyoto.uml.sequence.command.CreateConnectionCommand;
import net.seesaa.kyoto.uml.sequence.command.ReconnectSourceCommand;
import net.seesaa.kyoto.uml.sequence.command.ReorderMessageCommand;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;

/**
 * @author shida TODO To change the template for this generated type comment go
 *         to Window - Preferences - Java - Code Style - Code Templates
 */
public class ConnectorEditPolicy extends GraphicalNodeEditPolicy {

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy#getConnectionCompleteCommand(org.eclipse.gef.requests.CreateConnectionRequest)
     */
    protected Command getConnectionCompleteCommand(
            CreateConnectionRequest request) {
        CreateConnectionCommand rv = (CreateConnectionCommand) request
                .getStartCommand();
        Activation target = (Activation) getHost().getModel();
        rv.setTarget(target);
        return rv.chain(new ReorderMessageCommand(rv.getSource()));
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy#getConnectionCreateCommand(org.eclipse.gef.requests.CreateConnectionRequest)
     */
    protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
        Activation source = (Activation) getHost().getModel();
        IFigure sourceFigure = getHostFigure();
        Message connection = (Message) request.getNewObject();
        CreateConnectionCommand rv = new CreateConnectionCommand(connection);
        rv.setSource(source);
        Point location = request.getLocation();
        rv.setAbsoluteY(location.y);
        Point p = sourceFigure.getBounds().getLocation();
        sourceFigure.translateToRelative(location);
            
        rv.setLocation(new Point(p.x, location.y - p.y));
        request.setStartCommand(rv);
        return rv;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy#getReconnectTargetCommand(org.eclipse.gef.requests.ReconnectRequest)
     */
    protected Command getReconnectTargetCommand(ReconnectRequest request) {
    	return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy#getReconnectSourceCommand(org.eclipse.gef.requests.ReconnectRequest)
     */
    protected Command getReconnectSourceCommand(ReconnectRequest request) {
        Activation source = (Activation) getHost().getModel();
        IFigure sourceFigure = getHostFigure();
        ConnectionEditPart editPart = request.getConnectionEditPart();
        Message message = (Message) editPart.getModel();
        if (message.getType().equals(MessageType.get(MessageType.RECEIVE))) {
        	return null;
        }
        if (source.equals(message.getSource().getOwner())) {
        	ReconnectSourceCommand command = new ReconnectSourceCommand(message);
            Point location = request.getLocation();
            command.setAbsoluteY(location.y);
            Point p = sourceFigure.getBounds().getLocation();
            sourceFigure.translateToRelative(location);
            command.setSourceLocation(new Point(p.x, location.y - p.y));
            return command.chain(new ReorderMessageCommand(source));
        }
    	return null;
    }

}
