/**
 * 
 */
package net.seesaa.kyoto.uml.sequence.policy;

import net.seesaa.kyoto.uml.sequence.Activation;
import net.seesaa.kyoto.uml.sequence.ReceiveAnchor;
import net.seesaa.kyoto.uml.sequence.SendAnchor;
import net.seesaa.kyoto.uml.sequence.command.DeleteActivationCommand;
import net.seesaa.kyoto.uml.sequence.command.DeleteConnectorCommand;

import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.GroupRequest;

/**
 * @author shida
 *
 */
public class ActivationComponentEditPolicy extends ComponentEditPolicy {

	@Override
	protected Command createDeleteCommand(GroupRequest deleteRequest) {
		CompoundCommand command = new CompoundCommand("remove activation");
		Activation activation = (Activation) getHost().getModel();
		for (Object o : activation.getOutgoing()) {
			SendAnchor anchor = (SendAnchor) o;
			command.add(new DeleteConnectorCommand(anchor.getOutgoing()));
		}
		for (Object o : activation.getIncoming()) {
			ReceiveAnchor anchor = (ReceiveAnchor) o;
			command.add(new DeleteConnectorCommand(anchor.getIncoming()));
		}
		command.add(new DeleteActivationCommand(activation));
		return command;
	}
}
