/**
 * 
 */
package net.seesaa.kyoto.uml.sequence.figure;

import net.seesaa.kyoto.uml.sequence.Message;
import net.seesaa.kyoto.uml.sequence.MessageType;
import net.seesaa.kyoto.uml.sequence.SequencePlugin;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MidpointLocator;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;

/**
 * @author shida
 *
 */
public class MessageFigure extends PolylineConnection implements
		ISequenceFigure {

	private static final Image SYNC_IMAGE = ImageDescriptor.createFromFile(SequencePlugin.class, "icon/msg_sync.gif").createImage();
	
	private static final Image ASYNC_IMAGE = ImageDescriptor.createFromFile(SequencePlugin.class, "icon/msg_async.gif").createImage();
	
	private static final Image RETAURN_IMAGE = ImageDescriptor.createFromFile(SequencePlugin.class, "icon/msg_return.gif").createImage();
	
	private Label label = new Label();
	/**
	 * 
	 */
	public MessageFigure(Message message) {
		super();
		MidpointLocator locator = new MidpointLocator(this, 0);
		locator.setRelativePosition(PositionConstants.NORTH);
		add(label, locator);
		initFigure(message);
	}

	private void initFigure(Message message) {
		if (message.getType().getValue() == MessageType.SYNC) {
			createSyncMessage();
		} else if (message.getType().getValue() == MessageType.ASYNC) {
			createAsyncMessage();
		} else {
			createReturnMessage();
		}
	}
	
	private void createSyncMessage() {
//		label.setIcon(SYNC_IMAGE);
		setLineStyle(SWT.LINE_SOLID);
		setTargetDecoration(new PolygonDecoration());
	}
	
	private void createAsyncMessage() {
//		label.setIcon(ASYNC_IMAGE);
		setLineStyle(SWT.LINE_SOLID);
		setTargetDecoration(new PolylineDecoration());		
	}
	
	private void createReturnMessage() {
//		label.setIcon(RETAURN_IMAGE);
		setLineStyle(SWT.LINE_DASHDOTDOT);
		setTargetDecoration(new PolygonDecoration());
	}
	
	@Override
	public void paint(Graphics graphics) {
		graphics.setAntialias(SWT.ON);
		super.paint(graphics);
	}
	
	/* (non-Javadoc)
	 * @see net.seesaa.kyoto.uml.sequence.figure.ISequenceFigure#updateModel(org.eclipse.emf.ecore.EObject)
	 */
	public void updateModel(EObject obj) {
		Message m = (Message) obj;
		label.setText(m.getMessage() != null ? m.getMessage() : "");
	}

	public int getDefaultVerticalMargin() {
		// TODO Auto-generated method stub
		return 0;
	}

	public int getDefaultWidth() {
		// TODO Auto-generated method stub
		return 0;
	}

	public int getDefaultHeight() {
		// TODO Auto-generated method stub
		return 0;
	}

}
