/**
 * 
 */
package net.seesaa.kyoto.uml.sequence.editpart;

import java.util.List;

import net.seesaa.kyoto.uml.sequence.ObjectModel;
import net.seesaa.kyoto.uml.sequence.SequencePackage;
import net.seesaa.kyoto.uml.sequence.figure.ISequenceFigure;
import net.seesaa.kyoto.uml.sequence.figure.ObjectModelFigure;
import net.seesaa.kyoto.uml.sequence.policy.ObjectComponentEditPolicy;
import net.seesaa.kyoto.uml.sequence.policy.ObjectModelCellEditorLocator;
import net.seesaa.kyoto.uml.sequence.policy.ObjectModelLayoutEditPolicy;
import net.seesaa.kyoto.uml.sequence.policy.SequenceDirectEditManager;
import net.seesaa.kyoto.uml.sequence.policy.StringAttributeDirectEditPolicy;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.DirectEditRequest;

/**
 * @author shida
 * 
 */
public class ObjectModelEditPart extends BaseGraphicalEditPart {

	private SequenceDirectEditManager directManager;

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.editparts.AbstractGraphicalEditPart#createFigure()
	 */
	@Override
	protected IFigure createFigure() {
		ObjectModelFigure figure = new ObjectModelFigure();
		figure.setLayoutManager(new XYLayout());
		return figure;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.editparts.AbstractEditPart#createEditPolicies()
	 */
	@Override
	protected void createEditPolicies() {
		installEditPolicy(EditPolicy.LAYOUT_ROLE,
				new ObjectModelLayoutEditPolicy());
		installEditPolicy(EditPolicy.COMPONENT_ROLE,
				new ObjectComponentEditPolicy());
		installEditPolicy(EditPolicy.DIRECT_EDIT_ROLE,
				new StringAttributeDirectEditPolicy());
	}

	@Override
	public EditPolicy getEditPolicy(Object key) {
		return super.getEditPolicy(key);
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.emf.common.notify.Adapter#notifyChanged(org.eclipse.emf.common.notify.Notification)
	 */
	public void notifyChanged(Notification notification) {
		refreshVisuals();
		refreshChildren();
	}

	private ObjectModel getObject() {
		return (ObjectModel) getModel();
	}

	@Override
	protected List getModelChildren() {
		return getObject().getActivations();
	}

	@Override
	protected void refreshVisuals() {
		((ISequenceFigure) getFigure()).updateModel(getObject());
		Rectangle constraint = new Rectangle(getObject().getX(), getObject()
				.getY(), getObject().getWidth(), getObject().getHeight());
		getFigure().setBounds(constraint);
		((GraphicalEditPart) getParent()).setLayoutConstraint(this,
				getFigure(), constraint);
		getFigure().repaint();
	}

	@Override
	public void performRequest(Request req) {
		if (req instanceof DirectEditRequest) {
			performDirectEdit();
			return;
		}
		if (req instanceof CreateRequest) {
			CreateRequest request = (CreateRequest) req;
			if( request.getNewObjectType().equals(SequencePackage.eINSTANCE.getActivation())) {
				super.performRequest(req);
			} else {
				getParent().performRequest(req);
			}
		}
		super.performRequest(req);
	}

	@SuppressWarnings("unchecked")
	@Override
	public Command getCommand(Request request) {
		if (request instanceof CreateRequest) {
			CreateRequest req = (CreateRequest) request;
			if( req.getNewObjectType().equals(SequencePackage.eINSTANCE.getComment())) {
				GraphicalEditPart parent = (GraphicalEditPart) getParent();
				parent.getFigure().translateToRelative(req.getLocation());
				return getParent().getCommand(req);
			} else {
				return super.getCommand(req);
			}
		}
//		if (request instanceof ChangeBoundsRequest) {
//			ChangeBoundsRequest boundsRequest = (ChangeBoundsRequest) request;
//			List<EditPart> list = boundsRequest.getEditParts();
//			for (EditPart part : list) {
//				if (part.getModel() instanceof Activation) {
//				} else {
//					return getParent().getCommand(request);
//				}
//			}
//		}
		return super.getCommand(request);
	}
	private void performDirectEdit() {
		if (directManager == null) {
			directManager = new SequenceDirectEditManager(this,
					ContentsAssistCellEditor.class,
					new ObjectModelCellEditorLocator(getFigure()));
		}
		directManager.show();
	}
}
