/*
 * Created on 2005/06/06
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package net.seesaa.kyoto.uml.sequence.editpart;

import net.seesaa.kyoto.uml.sequence.Message;
import net.seesaa.kyoto.uml.sequence.command.DeleteConnectorCommand;
import net.seesaa.kyoto.uml.sequence.figure.ISequenceFigure;
import net.seesaa.kyoto.uml.sequence.figure.MessageFigure;
import net.seesaa.kyoto.uml.sequence.policy.MessageCellEditorLocator;
import net.seesaa.kyoto.uml.sequence.policy.SequenceDirectEditManager;
import net.seesaa.kyoto.uml.sequence.policy.StringAttributeDirectEditPolicy;

import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editpolicies.ConnectionEditPolicy;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.requests.GroupRequest;

/**
 * @author shida TODO To change the template for this generated type comment go
 *         to Window - Preferences - Java - Code Style - Code Templates
 */
public class MessageEditPart extends AbstractConnectionEditPart {

	private OutgoingAnchor sourceAnchor;
	
	private IncomingAnchor targetAnchor;
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.editparts.AbstractEditPart#createEditPolicies()
	 */
	protected void createEditPolicies() {
		installEditPolicy(EditPolicy.CONNECTION_ENDPOINTS_ROLE,
				new ConnectionEndpointEditPolicy());
		installEditPolicy(EditPolicy.CONNECTION_ROLE, new ConnectionEditPolicy(){

			@Override
			protected Command getDeleteCommand(GroupRequest request) {
				return new DeleteConnectorCommand((Message) getHost().getModel());
			}
			
		});
		installEditPolicy(EditPolicy.DIRECT_EDIT_ROLE, new StringAttributeDirectEditPolicy());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.editparts.AbstractGraphicalEditPart#createFigure()
	 */
	protected IFigure createFigure() {
		MessageFigure figure = new MessageFigure(getMessage());
		return figure;
	}


	private Message getMessage() {
		return (Message) getModel();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.EditPart#activate()
	 */
	@SuppressWarnings("unchecked")
	public void activate() {
		if (!isActive()) {
			super.activate();
			getMessage().eAdapters().add(adapter);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.EditPart#deactivate()
	 */
	public void deactivate() {
		if (isActive()) {
			getMessage().eAdapters().remove(adapter);
			super.deactivate();
		}
	}

	private class GraphicalConnectionAdapter implements Adapter {
		private Notifier target;

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.emf.common.notify.Adapter#notifyChanged(org.eclipse.emf.common.notify.Notification)
		 */
		public void notifyChanged(Notification notification) {
			refreshVisuals();
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.emf.common.notify.Adapter#getTarget()
		 */
		public Notifier getTarget() {
			return target;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.emf.common.notify.Adapter#setTarget(org.eclipse.emf.common.notify.Notifier)
		 */
		public void setTarget(Notifier newTarget) {
			target = newTarget;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.emf.common.notify.Adapter#isAdapterForType(java.lang.Object)
		 */
		public boolean isAdapterForType(Object type) {
			return type.equals(target);
		}

	}

	private GraphicalConnectionAdapter adapter = new GraphicalConnectionAdapter();

	private SequenceDirectEditManager directManager;

	public OutgoingAnchor getSourceAnchor() {
		return sourceAnchor;
	}

	public void setSourceAnchor(OutgoingAnchor sourceAnchor) {
		this.sourceAnchor = sourceAnchor;
	}

	public IncomingAnchor getTargetAnchor() {
		return targetAnchor;
	}

	public void setTargetAnchor(IncomingAnchor targetAnchor) {
		this.targetAnchor = targetAnchor;
	}
	
	@Override
	protected void refreshVisuals() {
		ISequenceFigure figure = (ISequenceFigure) getFigure();
		figure.updateModel(getMessage());
		super.refreshVisuals();
	}
	
	@Override
	public void performRequest(Request req) {
		if (req instanceof DirectEditRequest) {
			performDirectEdit();
			return;
		}
		super.performRequest(req);
	}

	private void performDirectEdit() {
		if (directManager == null) {
			directManager = new SequenceDirectEditManager(this,
					ContentsAssistCellEditor.class,
					new MessageCellEditorLocator((IFigure) getFigure().getChildren().get(0)));
		}
		directManager.show();
	}
}
