/**
 * 
 */
package net.seesaa.kyoto.uml.sequence.editpart;

import net.seesaa.kyoto.uml.sequence.ObjectModel;
import net.seesaa.kyoto.uml.sequence.ReceiveAnchor;
import net.seesaa.kyoto.uml.sequence.SendAnchor;

import org.eclipse.draw2d.AbstractConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;

/**
 * @author shida
 *
 */
public class IncomingAnchor extends AbstractConnectionAnchor {

	private ReceiveAnchor anchor;
	
	private IFigure source;
	
	public IncomingAnchor(ReceiveAnchor anchor, IFigure owner, IFigure source) {
		super(owner);
		this.anchor = anchor;
		this.source = source;
	}

	public void setModel(ReceiveAnchor anchor) {
		this.anchor = anchor;
	}
	
	public ReceiveAnchor getModel() {
		return anchor;
	}
	
	public Point getLocation(Point reference) {
		SendAnchor s = anchor.getIncoming().getSource();
		int y = source.getBounds().y + s.getPosition();
		int x = getOwner().getBounds().x;
		/*
		 * ef̈ʒuo߂.
		 */
		ObjectModel target = anchor.getOwner().getOwner();
		ObjectModel source = anchor.getIncoming().getSource().getOwner().getOwner();
		if (source.getX() > target.getX()) {
			x += getOwner().getBounds().width;
		}
		Point p = new Point(x, y);
		getOwner().translateToAbsolute(p);
		return p;
	}
}
