/**
 * 
 */
package net.seesaa.kyoto.uml.sequence.editpart;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.contentassist.IContentAssistSubjectControl;
import org.eclipse.jface.contentassist.ISubjectControlContentAssistProcessor;
import org.eclipse.jface.contentassist.SubjectControlContentAssistant;
import org.eclipse.jface.contentassist.TextContentAssistSubjectAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

/**
 * @author shida
 * 
 */
public class ContentsAssistCellEditor extends TextCellEditor {

	
	private TextContentAssistSubjectAdapter adapter;
	private SubjectControlContentAssistant assistant;

	/**
	 * @param parent
	 */
	public ContentsAssistCellEditor(Composite parent) {
		super(parent);
	}

	@Override
	protected Control createControl(Composite parent) {
		Text text = (Text) super.createControl(parent);
		adapter = new TextContentAssistSubjectAdapter(
						text);
		assistant = new SubjectControlContentAssistant();
		assistant.install(adapter);
		assistant.setContentAssistProcessor(new TextContentsAssistProcesser(),
				IDocument.DEFAULT_CONTENT_TYPE);

		adapter.appendVerifyKeyListener(new VerifyKeyListener() {
			public void verifyKey(VerifyEvent event) {
				if (event.stateMask == SWT.CTRL && event.character == ' ') {
					assistant.showPossibleCompletions();
					event.doit = false;
				}
			}
		});
		return text;
	}
	
	@Override
	public void dispose() {
		assistant.uninstall();
		super.dispose();
	}
	
	class TextContentsAssistProcesser implements
			ISubjectControlContentAssistProcessor {

		private String[] modifiers = new String[] { "abstract", "final",
				"native", "private", "protected", "public", "static",
				"synchronized" };

		public ICompletionProposal[] computeCompletionProposals(
				IContentAssistSubjectControl arg0, int arg1) {
			List<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
			for (int i = 0; i < modifiers.length; i++) {
				result.add(new CompletionProposal(modifiers[i], arg1, 0,
						modifiers[i].length()));
			}

			ICompletionProposal[] proposals = new ICompletionProposal[result
					.size()];
			result.toArray(proposals);
			return proposals;
		}

		public IContextInformation[] computeContextInformation(
				IContentAssistSubjectControl arg0, int arg1) {
			// TODO Auto-generated method stub
			return null;
		}

		public ICompletionProposal[] computeCompletionProposals(
				ITextViewer arg0, int arg1) {
			// TODO Auto-generated method stub
			return null;
		}

		public IContextInformation[] computeContextInformation(
				ITextViewer arg0, int arg1) {
			// TODO Auto-generated method stub
			return null;
		}

		public char[] getCompletionProposalAutoActivationCharacters() {
			// TODO Auto-generated method stub
			return null;
		}

		public char[] getContextInformationAutoActivationCharacters() {
			// TODO Auto-generated method stub
			return null;
		}

		public String getErrorMessage() {
			// TODO Auto-generated method stub
			return null;
		}

		public IContextInformationValidator getContextInformationValidator() {
			// TODO Auto-generated method stub
			return null;
		}

	}
}
