/**
 * 
 */
package net.seesaa.kyoto.uml.sequence.editpart;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;

/**
 * @author shida
 *
 */
public abstract class BaseGraphicalEditPart extends AbstractGraphicalEditPart implements Adapter {

	private Notifier notifier;
		
	@SuppressWarnings("unchecked")
	@Override
	public void activate() {
		super.activate();
		EObject object = (EObject) getModel();
		object.eAdapters().add(this);
	}

	@Override
	public void deactivate() {
		EObject object = (EObject) getModel();
		object.eAdapters().remove(this);
		super.deactivate();
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.emf.common.notify.Adapter#getTarget()
	 */
	public Notifier getTarget() {
		return (EObject) getModel();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.emf.common.notify.Adapter#setTarget(org.eclipse.emf.common.notify.Notifier)
	 */
	public void setTarget(Notifier newTarget) {
		this.notifier = newTarget;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.emf.common.notify.Adapter#isAdapterForType(java.lang.Object)
	 */
	public boolean isAdapterForType(Object type) {
		EClass eclass = ((EObject) getModel()).eClass();
		return eclass.isInstance(type);
	}

	/**
	 * 
	 * @return
	 */
	public Notifier getNotifier() {
		return notifier;
	}
}
