/**
 * 
 */
package net.seesaa.kyoto.uml.sequence.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import net.seesaa.kyoto.uml.sequence.Diagram;
import net.seesaa.kyoto.uml.sequence.ObjectModel;

import org.eclipse.gef.commands.Command;

/**
 * @author shida
 *
 */
public class ReorderObjectCommand extends Command{

	private Diagram model;
	
	/**
	 * @param model
	 */
	public ReorderObjectCommand(Diagram model) {
		super();
		this.model = model;
	}

	@SuppressWarnings("unchecked")
	@Override
	public void execute() {
		List<ObjectModel> models = new ArrayList<ObjectModel>(model.getContents());
		Collections.sort(models, new Comparator<ObjectModel>(){

			public int compare(ObjectModel o1, ObjectModel o2) {
				if (o1.getX() < o2.getX()) {
					return -1;
				} else if (o1.getX() == o2.getX()) {
					return 0;
				} else {
					return 1;
				}
			}
		});
		model.getContents().clear();
		model.getContents().addAll(models);
		super.execute();
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public void undo() {
		List<ObjectModel> models = new ArrayList<ObjectModel>(model.getContents());
		Collections.sort(models, new Comparator<ObjectModel>(){

			public int compare(ObjectModel o1, ObjectModel o2) {
				if (o1.getX() < o2.getX()) {
					return -1;
				} else if (o1.getX() == o2.getX()) {
					return 0;
				} else {
					return 1;
				}
			}
		});
		model.getContents().clear();
		model.getContents().addAll(models);
		super.undo();
	}
}
