/**
 * 
 */
package net.seesaa.kyoto.uml.sequence.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import net.seesaa.kyoto.uml.sequence.Activation;
import net.seesaa.kyoto.uml.sequence.SendAnchor;

import org.eclipse.gef.commands.Command;

/**
 * @author shida
 *
 */
public class ReorderMessageCommand extends Command{

	private Activation activation;
	
	
	/**
	 * @param activation
	 */
	public ReorderMessageCommand(Activation activation) {
		super();
		this.activation = activation;
	}

	@SuppressWarnings("unchecked")
	@Override
	public void execute() {
		List<SendAnchor> anchors = new ArrayList<SendAnchor>(activation.getOutgoing());
		Collections.sort(anchors, new Comparator<SendAnchor>(){

			public int compare(SendAnchor o1, SendAnchor o2) {
				if (o1.getPosition() < o2.getPosition()) {
					return -1;
				} else if (o1.getPosition() == o2.getPosition()) {
					return 0;
				} else {
					return 1;
				}
			}
		});
		activation.getOutgoing().clear();
		activation.getOutgoing().addAll(anchors);
		super.execute();
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public void undo() {
		List<SendAnchor> anchors = new ArrayList<SendAnchor>(activation.getOutgoing());
		Collections.sort(anchors, new Comparator<SendAnchor>(){

			public int compare(SendAnchor o1, SendAnchor o2) {
				if (o1.getPosition() < o2.getPosition()) {
					return -1;
				} else if (o1.getPosition() == o2.getPosition()) {
					return 0;
				} else {
					return 1;
				}
			}
		});
		activation.getOutgoing().clear();
		activation.getOutgoing().addAll(anchors);
		super.undo();
	}
}
