/**
 * 
 */
package net.seesaa.kyoto.uml.sequence.command;

import net.seesaa.kyoto.uml.sequence.Activation;
import net.seesaa.kyoto.uml.sequence.figure.ActivationFigure;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.commands.Command;

/**
 * @author shida
 *
 */
public class MoveVerticalCommand extends Command {
	
	private Activation model;
	
	private Point location;
	
	private Dimension size;
	
	private int oldLocation, oldSize;
	
	
	
	/**
	 * @param model
	 * @param location
	 * @param size
	 */
	public MoveVerticalCommand(Activation model, Point location, Dimension size) {
		super();
		this.model = model;
		this.location = location;
		this.size = size;
	}

	@SuppressWarnings("unchecked")
	@Override
	public void execute() {
		oldLocation = model.getY();
		oldSize = model.getHeight();
		model.setY(location.y);
		model.setWidth(ActivationFigure.DEFAULT_SIZE.width);
		if (size.height < ActivationFigure.DEFAULT_SIZE.height) {
			model.setHeight(ActivationFigure.DEFAULT_SIZE.height);
		} else {
			model.setHeight(size.height);
		}
	}
	
	@Override
	public void undo() {
		model.setY(oldLocation);
		model.setHeight(oldSize);
		super.undo();
	}
}
