/**
 * 
 */
package net.seesaa.kyoto.uml.sequence.command;

import net.seesaa.kyoto.uml.sequence.Activation;
import net.seesaa.kyoto.uml.sequence.Message;
import net.seesaa.kyoto.uml.sequence.ReceiveAnchor;
import net.seesaa.kyoto.uml.sequence.SendAnchor;

import org.eclipse.gef.commands.Command;

/**
 * @author shida
 *
 */
public class MoveMessageDeltaCommand extends Command {

	private int delta;
	
	private Message message;
	
	private int old_send, old_receive, old_source;
	
	/**
	 * @param delta
	 * @param message
	 */
	public MoveMessageDeltaCommand(int delta, Message message) {
		super();
		// TODO Auto-generated constructor stub
		this.delta = delta;
		this.message = message;
	}

	@Override
	public void execute() {
		SendAnchor sendAnchor = message.getSource();
		ReceiveAnchor receiveAnchor = message.getTarget();
		old_send = sendAnchor.getPosition();
		old_receive = receiveAnchor.getPosition();
		sendAnchor.setPosition(old_send + delta);
		receiveAnchor.setPosition(old_receive + delta);
		//constraint.
		Activation activation = sendAnchor.getOwner();
		old_source = activation.getHeight();
		if (activation.getHeight() < sendAnchor.getPosition()) {
			activation.setHeight(sendAnchor.getPosition());
		}
	}
	
	
	@Override
	public void undo() {
		SendAnchor sendAnchor = message.getSource();
		ReceiveAnchor receiveAnchor = message.getTarget();
		sendAnchor.setPosition(old_send);
		receiveAnchor.setPosition(old_receive);
		sendAnchor.getOwner().setHeight(old_source);
	}
}
