/**
 * 
 */
package net.seesaa.kyoto.uml.sequence.command;

import net.seesaa.kyoto.uml.sequence.Comment;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;

/**
 * @author shida
 *
 */
public class MoveCommentCommand extends Command {

	private Rectangle rectangle;
	
	private Comment comment;
	
	private Rectangle old;
	
	
	/**
	 * @param comment
	 * @param rectangle
	 */
	public MoveCommentCommand(Comment comment, Rectangle rectangle) {
		super();
		this.comment = comment;
		this.rectangle = rectangle;
	}

	@Override
	public void execute() {
		old = new Rectangle(comment.getX(), comment.getY(), comment.getWidth(), comment.getHeight());
		comment.setX(rectangle.x);
		comment.setY(rectangle.y);
		if (rectangle.getSize() != null) {
			comment.setWidth(rectangle.width );
			comment.setHeight(rectangle.height);			
		}
	}
	
	@Override
	public void undo() {
		comment.setX(old.x);
		comment.setY(old.y);
		comment.setWidth(old.width);
		comment.setHeight(old.height);
	}
}
