/**
 * 
 */
package net.seesaa.kyoto.uml.sequence.command;

import net.seesaa.kyoto.uml.sequence.Activation;
import net.seesaa.kyoto.uml.sequence.Message;

import org.eclipse.gef.commands.Command;

/**
 * @author shida
 * 
 */
public class DeleteConnectorCommand extends Command {

	private Message message;

	private Activation source;

	private Activation target;

	/**
	 * @param message
	 */
	public DeleteConnectorCommand(Message message) {
		super();
		this.message = message;
	}

	@Override
	public boolean canExecute() {
		return message != null && message.getSource().getOwner() != null
				&& message.getTarget().getOwner() != null;
	}

	@Override
	public void execute() {
		if (canExecute()) {
			source = message.getSource().getOwner();
			target = message.getTarget().getOwner();
			source.getOutgoing().remove(message.getSource());
			target.getIncoming().remove(message.getTarget());						
		}
	}

	@SuppressWarnings("unchecked")
	@Override
	public void undo() {
		if (source != null && target != null) {
			source.getOutgoing().add(message.getSource());
			target.getIncoming().add(message.getTarget());			
		}
	}
}
